


#include <sql-parser/gda-sql-parser.h>
#include <sql-parser/gda-sql-statement.h>
#include <glib-object.h>

/* enumerations from "gda-sql-parser.h" */
GType
gda_sql_parser_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_PARSER_SYNTAX_ERROR, "GDA_SQL_PARSER_SYNTAX_ERROR", "syntax-error" },
      { GDA_SQL_PARSER_OVERFLOW_ERROR, "GDA_SQL_PARSER_OVERFLOW_ERROR", "overflow-error" },
      { GDA_SQL_PARSER_EMPTY_SQL_ERROR, "GDA_SQL_PARSER_EMPTY_SQL_ERROR", "empty-sql-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlParserError", values);
  }
  return etype;
}
GType
gda_sql_parser_mode_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_PARSER_MODE_PARSE, "GDA_SQL_PARSER_MODE_PARSE", "parse" },
      { GDA_SQL_PARSER_MODE_DELIMIT, "GDA_SQL_PARSER_MODE_DELIMIT", "delimit" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlParserMode", values);
  }
  return etype;
}
GType
gda_sql_parser_flavour_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_PARSER_FLAVOUR_STANDARD, "GDA_SQL_PARSER_FLAVOUR_STANDARD", "standard" },
      { GDA_SQL_PARSER_FLAVOUR_SQLITE, "GDA_SQL_PARSER_FLAVOUR_SQLITE", "sqlite" },
      { GDA_SQL_PARSER_FLAVOUR_MYSQL, "GDA_SQL_PARSER_FLAVOUR_MYSQL", "mysql" },
      { GDA_SQL_PARSER_FLAVOUR_ORACLE, "GDA_SQL_PARSER_FLAVOUR_ORACLE", "oracle" },
      { GDA_SQL_PARSER_FLAVOUR_POSTGRESQL, "GDA_SQL_PARSER_FLAVOUR_POSTGRESQL", "postgresql" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlParserFlavour", values);
  }
  return etype;
}

/* enumerations from "gda-statement-struct-decl.h" */
GType
gda_sql_error_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_STRUCTURE_CONTENTS_ERROR, "GDA_SQL_STRUCTURE_CONTENTS_ERROR", "structure-contents-error" },
      { GDA_SQL_MALFORMED_IDENTIFIER_ERROR, "GDA_SQL_MALFORMED_IDENTIFIER_ERROR", "malformed-identifier-error" },
      { GDA_SQL_MISSING_IDENTIFIER_ERROR, "GDA_SQL_MISSING_IDENTIFIER_ERROR", "missing-identifier-error" },
      { GDA_SQL_VALIDATION_ERROR, "GDA_SQL_VALIDATION_ERROR", "validation-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlError", values);
  }
  return etype;
}
GType
gda_sql_statement_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_STATEMENT_SELECT, "GDA_SQL_STATEMENT_SELECT", "select" },
      { GDA_SQL_STATEMENT_INSERT, "GDA_SQL_STATEMENT_INSERT", "insert" },
      { GDA_SQL_STATEMENT_UPDATE, "GDA_SQL_STATEMENT_UPDATE", "update" },
      { GDA_SQL_STATEMENT_DELETE, "GDA_SQL_STATEMENT_DELETE", "delete" },
      { GDA_SQL_STATEMENT_COMPOUND, "GDA_SQL_STATEMENT_COMPOUND", "compound" },
      { GDA_SQL_STATEMENT_BEGIN, "GDA_SQL_STATEMENT_BEGIN", "begin" },
      { GDA_SQL_STATEMENT_ROLLBACK, "GDA_SQL_STATEMENT_ROLLBACK", "rollback" },
      { GDA_SQL_STATEMENT_COMMIT, "GDA_SQL_STATEMENT_COMMIT", "commit" },
      { GDA_SQL_STATEMENT_SAVEPOINT, "GDA_SQL_STATEMENT_SAVEPOINT", "savepoint" },
      { GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT, "GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT", "rollback-savepoint" },
      { GDA_SQL_STATEMENT_DELETE_SAVEPOINT, "GDA_SQL_STATEMENT_DELETE_SAVEPOINT", "delete-savepoint" },
      { GDA_SQL_STATEMENT_UNKNOWN, "GDA_SQL_STATEMENT_UNKNOWN", "unknown" },
      { GDA_SQL_STATEMENT_NONE, "GDA_SQL_STATEMENT_NONE", "none" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlStatementType", values);
  }
  return etype;
}
GType
gda_sql_any_part_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_ANY_STMT_SELECT, "GDA_SQL_ANY_STMT_SELECT", "stmt-select" },
      { GDA_SQL_ANY_STMT_INSERT, "GDA_SQL_ANY_STMT_INSERT", "stmt-insert" },
      { GDA_SQL_ANY_STMT_UPDATE, "GDA_SQL_ANY_STMT_UPDATE", "stmt-update" },
      { GDA_SQL_ANY_STMT_DELETE, "GDA_SQL_ANY_STMT_DELETE", "stmt-delete" },
      { GDA_SQL_ANY_STMT_COMPOUND, "GDA_SQL_ANY_STMT_COMPOUND", "stmt-compound" },
      { GDA_SQL_ANY_STMT_BEGIN, "GDA_SQL_ANY_STMT_BEGIN", "stmt-begin" },
      { GDA_SQL_ANY_STMT_ROLLBACK, "GDA_SQL_ANY_STMT_ROLLBACK", "stmt-rollback" },
      { GDA_SQL_ANY_STMT_COMMIT, "GDA_SQL_ANY_STMT_COMMIT", "stmt-commit" },
      { GDA_SQL_ANY_STMT_SAVEPOINT, "GDA_SQL_ANY_STMT_SAVEPOINT", "stmt-savepoint" },
      { GDA_SQL_ANY_STMT_ROLLBACK_SAVEPOINT, "GDA_SQL_ANY_STMT_ROLLBACK_SAVEPOINT", "stmt-rollback-savepoint" },
      { GDA_SQL_ANY_STMT_DELETE_SAVEPOINT, "GDA_SQL_ANY_STMT_DELETE_SAVEPOINT", "stmt-delete-savepoint" },
      { GDA_SQL_ANY_STMT_UNKNOWN, "GDA_SQL_ANY_STMT_UNKNOWN", "stmt-unknown" },
      { GDA_SQL_ANY_EXPR, "GDA_SQL_ANY_EXPR", "expr" },
      { GDA_SQL_ANY_SQL_FIELD, "GDA_SQL_ANY_SQL_FIELD", "sql-field" },
      { GDA_SQL_ANY_SQL_TABLE, "GDA_SQL_ANY_SQL_TABLE", "sql-table" },
      { GDA_SQL_ANY_SQL_FUNCTION, "GDA_SQL_ANY_SQL_FUNCTION", "sql-function" },
      { GDA_SQL_ANY_SQL_OPERATION, "GDA_SQL_ANY_SQL_OPERATION", "sql-operation" },
      { GDA_SQL_ANY_SQL_CASE, "GDA_SQL_ANY_SQL_CASE", "sql-case" },
      { GDA_SQL_ANY_SQL_SELECT_FIELD, "GDA_SQL_ANY_SQL_SELECT_FIELD", "sql-select-field" },
      { GDA_SQL_ANY_SQL_SELECT_TARGET, "GDA_SQL_ANY_SQL_SELECT_TARGET", "sql-select-target" },
      { GDA_SQL_ANY_SQL_SELECT_JOIN, "GDA_SQL_ANY_SQL_SELECT_JOIN", "sql-select-join" },
      { GDA_SQL_ANY_SQL_SELECT_FROM, "GDA_SQL_ANY_SQL_SELECT_FROM", "sql-select-from" },
      { GDA_SQL_ANY_SQL_SELECT_ORDER, "GDA_SQL_ANY_SQL_SELECT_ORDER", "sql-select-order" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlAnyPartType", values);
  }
  return etype;
}

/* enumerations from "gda-statement-struct-compound.h" */
GType
gda_sql_statement_compound_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_STATEMENT_COMPOUND_UNION, "GDA_SQL_STATEMENT_COMPOUND_UNION", "union" },
      { GDA_SQL_STATEMENT_COMPOUND_UNION_ALL, "GDA_SQL_STATEMENT_COMPOUND_UNION_ALL", "union-all" },
      { GDA_SQL_STATEMENT_COMPOUND_INTERSECT, "GDA_SQL_STATEMENT_COMPOUND_INTERSECT", "intersect" },
      { GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL, "GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL", "intersect-all" },
      { GDA_SQL_STATEMENT_COMPOUND_EXCEPT, "GDA_SQL_STATEMENT_COMPOUND_EXCEPT", "except" },
      { GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL, "GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL", "except-all" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlStatementCompoundType", values);
  }
  return etype;
}

/* enumerations from "gda-statement-struct-parts.h" */
GType
gda_sql_operator_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_OPERATOR_TYPE_AND, "GDA_SQL_OPERATOR_TYPE_AND", "and" },
      { GDA_SQL_OPERATOR_TYPE_OR, "GDA_SQL_OPERATOR_TYPE_OR", "or" },
      { GDA_SQL_OPERATOR_TYPE_EQ, "GDA_SQL_OPERATOR_TYPE_EQ", "eq" },
      { GDA_SQL_OPERATOR_TYPE_IS, "GDA_SQL_OPERATOR_TYPE_IS", "is" },
      { GDA_SQL_OPERATOR_TYPE_LIKE, "GDA_SQL_OPERATOR_TYPE_LIKE", "like" },
      { GDA_SQL_OPERATOR_TYPE_BETWEEN, "GDA_SQL_OPERATOR_TYPE_BETWEEN", "between" },
      { GDA_SQL_OPERATOR_TYPE_GT, "GDA_SQL_OPERATOR_TYPE_GT", "gt" },
      { GDA_SQL_OPERATOR_TYPE_LT, "GDA_SQL_OPERATOR_TYPE_LT", "lt" },
      { GDA_SQL_OPERATOR_TYPE_GEQ, "GDA_SQL_OPERATOR_TYPE_GEQ", "geq" },
      { GDA_SQL_OPERATOR_TYPE_LEQ, "GDA_SQL_OPERATOR_TYPE_LEQ", "leq" },
      { GDA_SQL_OPERATOR_TYPE_DIFF, "GDA_SQL_OPERATOR_TYPE_DIFF", "diff" },
      { GDA_SQL_OPERATOR_TYPE_REGEXP, "GDA_SQL_OPERATOR_TYPE_REGEXP", "regexp" },
      { GDA_SQL_OPERATOR_TYPE_REGEXP_CI, "GDA_SQL_OPERATOR_TYPE_REGEXP_CI", "regexp-ci" },
      { GDA_SQL_OPERATOR_TYPE_NOT_REGEXP, "GDA_SQL_OPERATOR_TYPE_NOT_REGEXP", "not-regexp" },
      { GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI, "GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI", "not-regexp-ci" },
      { GDA_SQL_OPERATOR_TYPE_SIMILAR, "GDA_SQL_OPERATOR_TYPE_SIMILAR", "similar" },
      { GDA_SQL_OPERATOR_TYPE_ISNULL, "GDA_SQL_OPERATOR_TYPE_ISNULL", "isnull" },
      { GDA_SQL_OPERATOR_TYPE_ISNOTNULL, "GDA_SQL_OPERATOR_TYPE_ISNOTNULL", "isnotnull" },
      { GDA_SQL_OPERATOR_TYPE_NOT, "GDA_SQL_OPERATOR_TYPE_NOT", "not" },
      { GDA_SQL_OPERATOR_TYPE_IN, "GDA_SQL_OPERATOR_TYPE_IN", "in" },
      { GDA_SQL_OPERATOR_TYPE_NOTIN, "GDA_SQL_OPERATOR_TYPE_NOTIN", "notin" },
      { GDA_SQL_OPERATOR_TYPE_CONCAT, "GDA_SQL_OPERATOR_TYPE_CONCAT", "concat" },
      { GDA_SQL_OPERATOR_TYPE_PLUS, "GDA_SQL_OPERATOR_TYPE_PLUS", "plus" },
      { GDA_SQL_OPERATOR_TYPE_MINUS, "GDA_SQL_OPERATOR_TYPE_MINUS", "minus" },
      { GDA_SQL_OPERATOR_TYPE_STAR, "GDA_SQL_OPERATOR_TYPE_STAR", "star" },
      { GDA_SQL_OPERATOR_TYPE_DIV, "GDA_SQL_OPERATOR_TYPE_DIV", "div" },
      { GDA_SQL_OPERATOR_TYPE_REM, "GDA_SQL_OPERATOR_TYPE_REM", "rem" },
      { GDA_SQL_OPERATOR_TYPE_BITAND, "GDA_SQL_OPERATOR_TYPE_BITAND", "bitand" },
      { GDA_SQL_OPERATOR_TYPE_BITOR, "GDA_SQL_OPERATOR_TYPE_BITOR", "bitor" },
      { GDA_SQL_OPERATOR_TYPE_BITNOT, "GDA_SQL_OPERATOR_TYPE_BITNOT", "bitnot" },
      { GDA_SQL_OPERATOR_TYPE_ILIKE, "GDA_SQL_OPERATOR_TYPE_ILIKE", "ilike" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlOperatorType", values);
  }
  return etype;
}
GType
gda_sql_select_join_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GDA_SQL_SELECT_JOIN_CROSS, "GDA_SQL_SELECT_JOIN_CROSS", "cross" },
      { GDA_SQL_SELECT_JOIN_NATURAL, "GDA_SQL_SELECT_JOIN_NATURAL", "natural" },
      { GDA_SQL_SELECT_JOIN_INNER, "GDA_SQL_SELECT_JOIN_INNER", "inner" },
      { GDA_SQL_SELECT_JOIN_LEFT, "GDA_SQL_SELECT_JOIN_LEFT", "left" },
      { GDA_SQL_SELECT_JOIN_RIGHT, "GDA_SQL_SELECT_JOIN_RIGHT", "right" },
      { GDA_SQL_SELECT_JOIN_FULL, "GDA_SQL_SELECT_JOIN_FULL", "full" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GdaSqlSelectJoinType", values);
  }
  return etype;
}



