/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 * Copyright (C) 2003 Anders Carlsson <andersca@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SONG_H__
#define __SONG_H__

#include <time.h>
#include <glib.h>

typedef struct _Song Song;
typedef struct _StringEntry StringEntry;

struct _Song
{
  guint64 filesize;

  char *filename;

  StringEntry *title;
  StringEntry *artist;
  StringEntry *album;
  
  /*  char *title;
  char *artist;
  char *album;
  */
  /* Pre-calculated collate keys for sorting. */
  /*  char *title_key;
  char *artist_key;
  char *album_key;
  */
  GList *playlists;

  time_t last_played;
  time_t date_added;
  time_t date_modified;

  int length;

  /* Is this really needed? */
  int samplerate;

  /* Get rid of this. */
  int random;

  int bitrate;

  int genre;
  int year;

  int track_number;
  int play_count;
  int rating;
};

void         song_free                 (Song        *song);
StringEntry *string_entry_ref          (StringEntry *entry);
void         string_entry_unref        (StringEntry *entry);
StringEntry *string_entry_add          (gchar       *str);
StringEntry *string_entry_add_const    (const gchar *str);
const gchar *string_entry_get_str      (StringEntry *entry);
const gchar *string_entry_get_collated (StringEntry *entry);
const gchar *string_entry_get_folded   (StringEntry *entry);
void         string_entry_init         (void);
void         string_entry_shutdown     (void);

#endif /* __SONG_H__ */
