/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PLAYLIST_H__
#define __PLAYLIST_H__

#include <glib.h>
#include "query.h"

typedef struct _Playlist Playlist;

typedef enum
{
  PLAYLIST_TYPE_LIBRARY,
  PLAYLIST_TYPE_REGULAR,
  PLAYLIST_TYPE_SMART,
  PLAYLIST_TYPE_IRADIO
} PlaylistType;

struct _Playlist
{
  PlaylistType type;
  char *name;
  int id;
  
  union {
    struct {
      Query *query;
    } regular;

    struct {
      Query *query;
    } smart;

    struct {
      char *url;
    } iradio;
  } v;
};


void        playlist_free        (Playlist     *playlist);
Playlist *  playlist_new         (PlaylistType  type,
				  const char   *name);
void        playlist_save        (Playlist     *playlist);
Query *     playlist_get_query   (Playlist     *playlist);
void        playlist_set_query   (Playlist     *playlist,
				  Query        *query);
gboolean    playlist_is_editable (Playlist     *playlist);
const char *playlist_get_name    (Playlist     *playlist);
void        playlist_set_name    (Playlist     *playlist,
				  const char   *name);
void        playlist_set_id      (Playlist     *playlist,
				  int           id);
int         playlist_get_id      (Playlist     *playlist);

#endif /* __PLAYLIST_H__ */
