%define cvs 0
%define cvsbuild
%define ver 0.3

%if%{cvs}
%define version %{cvsbuild}
%else
%define version %{ver}
%endif

Name: gnome-jabber
Version: %{version}
Release: 1
Summary: Instant message client for Gnome using the Jabber protocol
Group: Applications/Internet
License: GPL
URL: http://gnome-jabber.sourceforge.net/
Source: http://prdownloads.sourceforge.net/gnome-jabber/gnome-jabber-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
#Patch: 

Requires: gtk2 >= 2
Requires: gnet2 >= 2

BuildRequires: gtk2-devel 
BuildRequires: gnet2-devel >= 2.0
BuildRequires: glib2 >= 2.0.3
BuildRequires: gtk2 >= 2.0.4
BuildRequires: libglade2 >= 2.0.0
BuildRequires: libgnomeui >= 2.0.0
BuildRequires: libxml2


%description
Gnome Jabber is an instant message client for Gnome using the Jabber protocol. The idea behind Jabber is to be able to deliver a common protocol to interface to all other major IM protocols, such as ICQ, MSN, AIM, etc. Jabber is not just there as a gateway between multiple IM systems, a Jabber server also allows users to register and communicate without the need to operate through an account with ICQ, MSN, AIM, etc

%package devel
Summary: Libraries/include files for gnome-jabber
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel

%prep
%setup -q -n %{name}-%{version}
#%setup -q
#%setup -q -n %{name}-%{version}.%{cvsbuild}
#%patch -p1 -b .rh

%build

# If configure does not exist then we are likely using a CVS build
if [ ! -f ./configure ] || %{cvs}; then
        aclocal
        autoheader
        autoconf
        automake
        automake --add-missing
        intltoolize
fi

%configure 
#	--prefix=%{_prefix} \
#	--bindir=%{_bindir} \
#	--datadir=%{_datadir}/%{name} \
#	--mandir=%{_mandir} \
#	--confdir=%{_sysconfdir}/%{name}

make

%install  
mkdir -p $RPM_BUILD_ROOT/
mkdir -p $RPM_BUILD_ROOT/%{_bindir}

%makeinstall

# create a launcher icon
mkdir -p %{buildroot}%{_sysconfdir}/X11/applnk/Internet
cat > %{buildroot}%{_sysconfdir}/X11/applnk/Internet/gnome-jabber.desktop << EOF
[Desktop Entry]
Name=Gnome Jabber
Comment=%{summary}
Exec=gnome-jabber
Icon=gnome-jabber.png
Terminal=0
Type=Application
EOF


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS COPYING README TODO INSTALL NEWS ChangeLog 
%{_bindir}/%name
%{_datadir}/%name/*
%{_datadir}/locale/*
%{_sysconfdir}/gconf/schemas/gnome-jabber.schemas
%{_sysconfdir}/X11/applnk/Internet/gnome-jabber.desktop

%files devel
%defattr(-, root, root)
#%dir %{_includedir}/%{name}-%{major}
#%{_includedir}/%{name}-%{major}/*
#%{_libdir}/debug/usr/bin/%name.debug
#%{_prefix}/src/debug/%name-%version/*

%changelog
* Fri Aug 22 2003 Gawain Lynch <gawain_lynch@yahoo.com> 0.3-1
- update to v0.3
- fix my braindead CVS build logic
- development headers temporarily removed

* Fri Aug 22 2003 Gawain Lynch <gawain_lynch@yahoo.com> 0.2-3
- add ability to build from CVS
- add launcher

* Tue Aug 05 2003 Gawain Lynch <gawain_lynch@yahoo.com> 0.2-1
- inital spec
