/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-bonobo-extensions.h"
#include "gul-tb-button.h"
#include <gtk/gtklabel.h>
#include <gtk/gtkstock.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include "gul-tbi-test.h"
#include "prefs-strings.h"
#include "eel-gconf-extensions.h"
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GulTbiTestPrivate 
{
	GulTbButton *b;
	gchar *label;
};

/**
 * Private functions, only availble from this file
 */
static void		gul_tbi_test_class_init			(GulTbiTestClass *klass);
static void		gul_tbi_test_init			(GulTbiTest *tb);
static void		gul_tbi_test_finalize_impl		(GObject *o);
static GtkWidget *	gul_tbi_test_get_widget_impl		(GulTbItem *i);
static GdkPixbuf *	gul_tbi_test_get_icon_impl		(GulTbItem *i);
static gchar *		gul_tbi_test_get_name_human_impl	(GulTbItem *i);
static gchar *		gul_tbi_test_to_string_impl		(GulTbItem *i);
static gboolean		gul_tbi_test_is_unique_impl		(GulTbItem *i);
static GulTbItem *	gul_tbi_test_clone_impl			(GulTbItem *i);
static void		gul_tbi_test_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		gul_tbi_test_add_to_bonobo_tb_impl	(GulTbItem *i, 
								 BonoboUIComponent *ui, 
								 const char *container_path,
								 guint index);


static gpointer gul_tb_item_class;

/**
 * TbiTest object
 */

MAKE_GET_TYPE (gul_tbi_test, "GulTbiTest", GulTbiTest, gul_tbi_test_class_init, 
	       gul_tbi_test_init, GUL_TYPE_TB_ITEM);

static void
gul_tbi_test_class_init (GulTbiTestClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = gul_tbi_test_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = gul_tbi_test_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = gul_tbi_test_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = gul_tbi_test_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = gul_tbi_test_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->is_unique = gul_tbi_test_is_unique_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = gul_tbi_test_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = gul_tbi_test_parse_properties_impl;
	GUL_TB_ITEM_CLASS (klass)->add_to_bonobo_tb = gul_tbi_test_add_to_bonobo_tb_impl;
	
	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
gul_tbi_test_init (GulTbiTest *tbi)
{
	GulTbiTestPrivate *p = g_new0 (GulTbiTestPrivate, 1);
	tbi->priv = p;
	p->label = g_strdup ("Test button");
}

GulTbiTest *
gul_tbi_test_new (void)
{
	GulTbiTest *ret = g_object_new (GUL_TYPE_TBI_TEST, NULL);
	return ret;
}

static void
gul_tbi_test_finalize_impl (GObject *o)
{
	GulTbiTest *it = GUL_TBI_TEST (o);
	GulTbiTestPrivate *p = it->priv;

	if (p->b)
	{
		g_object_unref (p->b);
	}
	
	g_free (p->label);

	g_free (p);
	
	DEBUG_MSG (("GulTbiTest finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}

static GtkWidget *
gul_tbi_test_get_widget_impl (GulTbItem *i)
{
	GulTbiTest *iz = GUL_TBI_TEST (i);
	GulTbiTestPrivate *p = iz->priv;

	if (!p->b)
	{
		gchar *tt = gul_tb_item_to_string (i);
		p->b = gul_tb_button_new ();
		g_object_ref (p->b);
		gul_tb_button_set_priority (p->b, TRUE);
		gul_tb_button_set_use_stock (p->b, TRUE);
		gul_tb_button_set_label (p->b, p->label);
		gul_tb_button_set_tooltip_text (p->b, tt);
		gul_tb_button_set_enable_menu (p->b, TRUE);
		gul_tb_button_set_show_arrow (p->b, TRUE);
		gtk_widget_show (GTK_WIDGET (p->b));
		g_free (tt);
	}

	return GTK_WIDGET (p->b);
}

static GdkPixbuf *
gul_tbi_test_get_icon_impl (GulTbItem *i)
{
	return NULL;
}

static gchar *
gul_tbi_test_get_name_human_impl (GulTbItem *i)
{
	return g_strdup ("Test");
}

static gchar *
gul_tbi_test_to_string_impl (GulTbItem *i)
{
	GulTbiTestPrivate *p = GUL_TBI_TEST (i)->priv;
	/* if it had any properties, the string should include them */
	return g_strdup_printf ("%s=test(label=%s)", i->id, p->label);
}

static gboolean
gul_tbi_test_is_unique_impl (GulTbItem *i)
{
	return FALSE;
}

static GulTbItem *
gul_tbi_test_clone_impl (GulTbItem *i)
{
	GulTbItem *ret = GUL_TB_ITEM (gul_tbi_test_new ());
	GulTbiTestPrivate *p = GUL_TBI_TEST (i)->priv;
	
	gul_tb_item_set_id (ret, i->id);

	/* should copy properties too, if any */
	gul_tbi_test_set_label (GUL_TBI_TEST (ret), p->label);

	return ret;
}

static void
gul_tbi_test_add_to_bonobo_tb_impl (GulTbItem *i, BonoboUIComponent *ui, 
				    const char *container_path, guint index)
{
	GtkWidget *w = gul_tb_item_get_widget (i);
	GulTbiTestPrivate *p = GUL_TBI_TEST (i)->priv;
	gtk_widget_show (w);
	gul_bonobo_add_numbered_widget (ui, GTK_WIDGET (p->b), index, container_path);
}

static void
gul_tbi_test_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* yes, this is quite hacky, but works */

	/* we have aproperty, the label */
	const gchar *label_prop;

	label_prop = strstr (props, "label=");
	if (label_prop)
	{
		label_prop += strlen ("label=");
		gul_tbi_test_set_label (GUL_TBI_TEST (it), label_prop);
	}
}

void
gul_tbi_test_set_label (GulTbiTest *t, const gchar *label)
{
	GulTbiTestPrivate *p = GUL_TBI_TEST (t)->priv;
	GulTbButton *b;

	g_free (p->label);
	p->label = g_strdup (label);
	b = GUL_TB_BUTTON (gul_tb_item_get_widget (GUL_TB_ITEM (t)));
	gul_tb_button_set_label (GUL_TB_BUTTON (b), p->label);
}
