/* signal-manager.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from signal-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
typedef struct _FolksInspectSignalManagerPrivate FolksInspectSignalManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_closure_unref0(var) ((var == NULL) ? NULL : (var = (g_closure_unref (var), NULL)))

struct _FolksInspectSignalManager {
	GObject parent_instance;
	FolksInspectSignalManagerPrivate * priv;
};

struct _FolksInspectSignalManagerClass {
	GObjectClass parent_class;
};

struct _FolksInspectSignalManagerPrivate {
	GeeHashMap* signals_by_class_type;
	GeeHashMap* signals_by_class_instance;
};


static gpointer folks_inspect_signal_manager_parent_class = NULL;

GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerPrivate))
enum  {
	FOLKS_INSPECT_SIGNAL_MANAGER_DUMMY_PROPERTY
};
FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_indent (void);
static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map);
void folks_inspect_utils_unindent (void);
void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string);
static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags);
guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string);
static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string);
guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id);
static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id);
static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue* return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data);
static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1);
static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self);
static void folks_inspect_signal_manager_finalize (GObject* obj);


FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type) {
	FolksInspectSignalManager * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_;
	self = (FolksInspectSignalManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->signals_by_class_type);
	self->priv->signals_by_class_type = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->signals_by_class_instance);
	self->priv->signals_by_class_instance = _tmp3_;
	return self;
}


FolksInspectSignalManager* folks_inspect_signal_manager_new (void) {
	return folks_inspect_signal_manager_construct (FOLKS_INSPECT_TYPE_SIGNAL_MANAGER);
}


void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance) {
	g_return_if_fail (self != NULL);
	if (class_type != G_TYPE_INVALID) {
		gpointer _tmp0_ = NULL;
		GeeHashMap* hook_ids;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_type, GINT_TO_POINTER (class_type));
		hook_ids = (GeeHashMap*) _tmp0_;
		_tmp1_ = g_type_name (class_type);
		folks_inspect_utils_print_line ("Signals on all instances of class type '%s':", _tmp1_);
		folks_inspect_utils_indent ();
		folks_inspect_signal_manager_list_signals_for_type (self, class_type, hook_ids);
		folks_inspect_utils_unindent ();
		_g_object_unref0 (hook_ids);
	} else {
		if (class_instance != NULL) {
			gpointer _tmp2_ = NULL;
			GeeHashMap* signal_handler_ids;
			GType _tmp3_;
			const gchar* _tmp4_ = NULL;
			GType _tmp5_;
			_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_instance, class_instance);
			signal_handler_ids = (GeeHashMap*) _tmp2_;
			_tmp3_ = G_TYPE_FROM_INSTANCE (class_instance);
			_tmp4_ = g_type_name (_tmp3_);
			folks_inspect_utils_print_line ("Signals on instance %p of class type '%s':", class_instance, _tmp4_);
			folks_inspect_utils_indent ();
			_tmp5_ = G_TYPE_FROM_INSTANCE (class_instance);
			folks_inspect_signal_manager_list_signals_for_type (self, _tmp5_, signal_handler_ids);
			folks_inspect_utils_unindent ();
			_g_object_unref0 (signal_handler_ids);
		} else {
			GeeMapIterator* _tmp6_ = NULL;
			GeeMapIterator* class_type_iter;
			GeeMapIterator* _tmp16_ = NULL;
			GeeMapIterator* class_instance_iter;
			_tmp6_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) self->priv->signals_by_class_type);
			class_type_iter = _tmp6_;
			folks_inspect_utils_print_line ("Connected signals on all instances of classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				gboolean _tmp7_;
				gpointer _tmp8_ = NULL;
				GeeHashMap* hook_ids;
				GeeMapIterator* _tmp9_ = NULL;
				GeeMapIterator* hook_iter;
				gpointer _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* class_name;
				_tmp7_ = gee_map_iterator_next (class_type_iter);
				if (!(_tmp7_ == TRUE)) {
					break;
				}
				_tmp8_ = gee_map_iterator_get_value (class_type_iter);
				hook_ids = (GeeHashMap*) _tmp8_;
				_tmp9_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) hook_ids);
				hook_iter = _tmp9_;
				_tmp10_ = gee_map_iterator_get_key (class_type_iter);
				_tmp11_ = g_type_name (GPOINTER_TO_INT (_tmp10_));
				_tmp12_ = g_strdup (_tmp11_);
				class_name = _tmp12_;
				while (TRUE) {
					gboolean _tmp13_;
					gpointer _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					_tmp13_ = gee_map_iterator_next (hook_iter);
					if (!(_tmp13_ == TRUE)) {
						break;
					}
					_tmp14_ = gee_map_iterator_get_key (hook_iter);
					_tmp15_ = g_signal_name (GPOINTER_TO_UINT (_tmp14_));
					folks_inspect_utils_print_line ("%s::%s — connected", class_name, _tmp15_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (hook_iter);
				_g_object_unref0 (hook_ids);
			}
			folks_inspect_utils_unindent ();
			_tmp16_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) self->priv->signals_by_class_instance);
			class_instance_iter = _tmp16_;
			folks_inspect_utils_print_line ("%s", "Connected signals on specific instances of " "classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				gboolean _tmp17_;
				gpointer _tmp18_ = NULL;
				GeeHashMap* signal_handler_ids;
				GeeMapIterator* _tmp19_ = NULL;
				GeeMapIterator* signal_handler_iter;
				gpointer _tmp20_ = NULL;
				GObject* _tmp21_;
				GType _tmp22_;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* class_name;
				_tmp17_ = gee_map_iterator_next (class_instance_iter);
				if (!(_tmp17_ == TRUE)) {
					break;
				}
				_tmp18_ = gee_map_iterator_get_value (class_instance_iter);
				signal_handler_ids = (GeeHashMap*) _tmp18_;
				_tmp19_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) signal_handler_ids);
				signal_handler_iter = _tmp19_;
				_tmp20_ = gee_map_iterator_get_key (class_instance_iter);
				_tmp21_ = (GObject*) _tmp20_;
				_tmp22_ = G_TYPE_FROM_INSTANCE (_tmp21_);
				_tmp23_ = g_type_name (_tmp22_);
				_tmp24_ = g_strdup (_tmp23_);
				class_name = (_tmp25_ = _tmp24_, _g_object_unref0 (_tmp21_), _tmp25_);
				while (TRUE) {
					gboolean _tmp26_;
					gpointer _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					_tmp26_ = gee_map_iterator_next (signal_handler_iter);
					if (!(_tmp26_ == TRUE)) {
						break;
					}
					_tmp27_ = gee_map_iterator_get_key (signal_handler_iter);
					_tmp28_ = g_signal_name (GPOINTER_TO_UINT (_tmp27_));
					folks_inspect_utils_print_line ("%s::%s — connected", class_name, _tmp28_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (signal_handler_iter);
				_g_object_unref0 (signal_handler_ids);
			}
			folks_inspect_utils_unindent ();
			_g_object_unref0 (class_instance_iter);
			_g_object_unref0 (class_type_iter);
		}
	}
}


void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string) {
	guint _tmp0_;
	guint signal_id;
	GSignalQuery query_info = {0};
	GSignalQuery _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_signal_lookup (signal_name, class_type);
	signal_id = _tmp0_;
	if (signal_id == 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = g_type_name (class_type);
		folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp1_);
		return;
	}
	g_signal_query (signal_id, &_tmp2_);
	query_info = _tmp2_;
	folks_inspect_utils_print_line ("Signal ID        %u", query_info.signal_id);
	folks_inspect_utils_print_line ("Signal name      %s", query_info.signal_name);
	_tmp3_ = g_type_name (query_info.itype);
	folks_inspect_utils_print_line ("Emitting type    %s", _tmp3_);
	_tmp4_ = folks_inspect_signal_manager_signal_flags_to_string (query_info.signal_flags);
	_tmp5_ = _tmp4_;
	folks_inspect_utils_print_line ("Signal flags     %s", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_type_name (query_info.return_type);
	folks_inspect_utils_print_line ("Return type      %s", _tmp6_);
	folks_inspect_utils_print_line ("Parameter types:");
	folks_inspect_utils_indent ();
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				const gchar* _tmp8_ = NULL;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				if (!(i < query_info.n_params)) {
					break;
				}
				_tmp8_ = g_type_name (query_info.param_types[i]);
				folks_inspect_utils_print_line ("%-4u  %s", i, _tmp8_);
			}
		}
	}
	folks_inspect_utils_unindent ();
}


guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0U);
	if (class_type != G_TYPE_INVALID) {
		_tmp0_ = signal_name != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp1_;
		guint signal_id;
		gboolean _tmp3_;
		_tmp1_ = g_signal_lookup (signal_name, class_type);
		signal_id = _tmp1_;
		if (signal_id == 0) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp2_);
			result = (guint) 0;
			return result;
		}
		_tmp3_ = folks_inspect_signal_manager_add_emission_hook (self, class_type, signal_id, detail_string);
		if (_tmp3_ == FALSE) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Not allowed to connect to signal '%s' on " "class '%s'.", signal_name, _tmp4_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		if (class_type != G_TYPE_INVALID) {
			_tmp5_ = signal_name == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gint _tmp6_;
			guint* _tmp7_ = NULL;
			guint* signal_ids;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count;
			_tmp7_ = g_signal_list_ids (class_type, &_tmp6_);
			signal_ids = _tmp7_;
			signal_ids_length1 = _tmp6_;
			_signal_ids_size_ = _tmp6_;
			signal_count = (guint) 0;
			{
				guint* signal_id_collection;
				int signal_id_collection_length1;
				int signal_id_it;
				signal_id_collection = signal_ids;
				signal_id_collection_length1 = signal_ids_length1;
				for (signal_id_it = 0; signal_id_it < signal_ids_length1; signal_id_it = signal_id_it + 1) {
					guint signal_id;
					signal_id = signal_id_collection[signal_id_it];
					{
						gboolean _tmp8_;
						_tmp8_ = folks_inspect_signal_manager_add_emission_hook (self, class_type, signal_id, NULL);
						if (_tmp8_ == TRUE) {
							signal_count++;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			if (class_instance != NULL) {
				_tmp9_ = signal_name != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GType _tmp10_;
				guint _tmp11_;
				guint signal_id;
				_tmp10_ = G_TYPE_FROM_INSTANCE (class_instance);
				_tmp11_ = g_signal_lookup (signal_name, _tmp10_);
				signal_id = _tmp11_;
				if (signal_id == 0) {
					GType _tmp12_;
					const gchar* _tmp13_ = NULL;
					_tmp12_ = G_TYPE_FROM_INSTANCE (class_instance);
					_tmp13_ = g_type_name (_tmp12_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", signal_name, class_instance, _tmp13_);
					result = (guint) 0;
					return result;
				}
				folks_inspect_signal_manager_add_signal_handler (self, class_instance, signal_id, detail_string);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp14_ = FALSE;
				if (class_instance != NULL) {
					_tmp14_ = signal_name == NULL;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					GType _tmp15_;
					gint _tmp16_;
					guint* _tmp17_ = NULL;
					guint* signal_ids;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count;
					_tmp15_ = G_TYPE_FROM_INSTANCE (class_instance);
					_tmp17_ = g_signal_list_ids (_tmp15_, &_tmp16_);
					signal_ids = _tmp17_;
					signal_ids_length1 = _tmp16_;
					_signal_ids_size_ = _tmp16_;
					signal_count = (guint) 0;
					{
						guint* signal_id_collection;
						int signal_id_collection_length1;
						int signal_id_it;
						signal_id_collection = signal_ids;
						signal_id_collection_length1 = signal_ids_length1;
						for (signal_id_it = 0; signal_id_it < signal_ids_length1; signal_id_it = signal_id_it + 1) {
							guint signal_id;
							signal_id = signal_id_collection[signal_id_it];
							{
								signal_count++;
								folks_inspect_signal_manager_add_signal_handler (self, class_instance, signal_id, NULL);
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0U);
	if (class_type != G_TYPE_INVALID) {
		_tmp0_ = signal_name != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp1_;
		guint signal_id;
		gboolean _tmp3_;
		_tmp1_ = g_signal_lookup (signal_name, class_type);
		signal_id = _tmp1_;
		if (signal_id == 0) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp2_);
			result = (guint) 0;
			return result;
		}
		_tmp3_ = folks_inspect_signal_manager_remove_emission_hook (self, class_type, signal_id);
		if (_tmp3_ == FALSE) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Could not remove hook for signal '%s' on " "class '%s'.", signal_name, _tmp4_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		if (class_type != G_TYPE_INVALID) {
			_tmp5_ = signal_name == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gint _tmp6_;
			guint* _tmp7_ = NULL;
			guint* signal_ids;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count;
			_tmp7_ = g_signal_list_ids (class_type, &_tmp6_);
			signal_ids = _tmp7_;
			signal_ids_length1 = _tmp6_;
			_signal_ids_size_ = _tmp6_;
			signal_count = (guint) 0;
			{
				guint* signal_id_collection;
				int signal_id_collection_length1;
				int signal_id_it;
				signal_id_collection = signal_ids;
				signal_id_collection_length1 = signal_ids_length1;
				for (signal_id_it = 0; signal_id_it < signal_ids_length1; signal_id_it = signal_id_it + 1) {
					guint signal_id;
					signal_id = signal_id_collection[signal_id_it];
					{
						gboolean _tmp8_;
						_tmp8_ = folks_inspect_signal_manager_remove_emission_hook (self, class_type, signal_id);
						if (_tmp8_ == TRUE) {
							signal_count--;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			if (class_instance != NULL) {
				_tmp9_ = signal_name != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GType _tmp10_;
				guint _tmp11_;
				guint signal_id;
				_tmp10_ = G_TYPE_FROM_INSTANCE (class_instance);
				_tmp11_ = g_signal_lookup (signal_name, _tmp10_);
				signal_id = _tmp11_;
				if (signal_id == 0) {
					GType _tmp12_;
					const gchar* _tmp13_ = NULL;
					_tmp12_ = G_TYPE_FROM_INSTANCE (class_instance);
					_tmp13_ = g_type_name (_tmp12_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", signal_name, class_instance, _tmp13_);
					result = (guint) 0;
					return result;
				}
				folks_inspect_signal_manager_remove_signal_handler (self, class_instance, signal_id);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp14_ = FALSE;
				if (class_instance != NULL) {
					_tmp14_ = signal_name == NULL;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					GType _tmp15_;
					gint _tmp16_;
					guint* _tmp17_ = NULL;
					guint* signal_ids;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count;
					_tmp15_ = G_TYPE_FROM_INSTANCE (class_instance);
					_tmp17_ = g_signal_list_ids (_tmp15_, &_tmp16_);
					signal_ids = _tmp17_;
					signal_ids_length1 = _tmp16_;
					_signal_ids_size_ = _tmp16_;
					signal_count = (guint) 0;
					{
						guint* signal_id_collection;
						int signal_id_collection_length1;
						int signal_id_it;
						signal_id_collection = signal_ids;
						signal_id_collection_length1 = signal_ids_length1;
						for (signal_id_it = 0; signal_id_it < signal_ids_length1; signal_id_it = signal_id_it + 1) {
							guint signal_id;
							signal_id = signal_id_collection[signal_id_it];
							{
								gboolean _tmp18_;
								_tmp18_ = folks_inspect_signal_manager_remove_signal_handler (self, class_instance, signal_id);
								if (_tmp18_) {
									signal_count--;
								}
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map) {
	gint _tmp0_;
	guint* _tmp1_ = NULL;
	guint* signal_ids;
	gint signal_ids_length1;
	gint _signal_ids_size_;
	guint _tmp7_;
	GType* _tmp8_ = NULL;
	GType* interfaces;
	gint interfaces_length1;
	gint _interfaces_size_;
	GType _tmp9_;
	GType parent_type;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_signal_list_ids (type, &_tmp0_);
	signal_ids = _tmp1_;
	signal_ids_length1 = _tmp0_;
	_signal_ids_size_ = _tmp0_;
	if (signal_ids != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* type_name;
		_tmp2_ = g_type_name (type);
		_tmp3_ = g_strdup (_tmp2_);
		type_name = _tmp3_;
		{
			guint* signal_id_collection;
			int signal_id_collection_length1;
			int signal_id_it;
			signal_id_collection = signal_ids;
			signal_id_collection_length1 = signal_ids_length1;
			for (signal_id_it = 0; signal_id_it < signal_ids_length1; signal_id_it = signal_id_it + 1) {
				guint signal_id;
				signal_id = signal_id_collection[signal_id_it];
				{
					const gchar* _tmp4_ = NULL;
					const gchar* signal_name;
					gboolean _tmp5_ = FALSE;
					_tmp4_ = g_signal_name (signal_id);
					signal_name = _tmp4_;
					if (signal_id_map != NULL) {
						gboolean _tmp6_;
						_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) signal_id_map, GUINT_TO_POINTER (signal_id));
						_tmp5_ = _tmp6_ == TRUE;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						folks_inspect_utils_print_line ("%s::%s — connected", type_name, signal_name);
					} else {
						folks_inspect_utils_print_line ("%s::%s", type_name, signal_name);
					}
				}
			}
		}
		_g_free0 (type_name);
	}
	_tmp8_ = g_type_interfaces (type, &_tmp7_);
	interfaces = _tmp8_;
	interfaces_length1 = _tmp7_;
	_interfaces_size_ = _tmp7_;
	{
		GType* interface_type_collection;
		int interface_type_collection_length1;
		int interface_type_it;
		interface_type_collection = interfaces;
		interface_type_collection_length1 = interfaces_length1;
		for (interface_type_it = 0; interface_type_it < interfaces_length1; interface_type_it = interface_type_it + 1) {
			GType interface_type;
			interface_type = interface_type_collection[interface_type_it];
			{
				folks_inspect_signal_manager_list_signals_for_type (self, interface_type, signal_id_map);
			}
		}
	}
	_tmp9_ = g_type_parent (type);
	parent_type = _tmp9_;
	if (parent_type != G_TYPE_INVALID) {
		folks_inspect_signal_manager_list_signals_for_type (self, parent_type, signal_id_map);
	}
	interfaces = (g_free (interfaces), NULL);
	signal_ids = (g_free (signal_ids), NULL);
}


static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data) {
	folks_inspect_signal_manager_signal_meta_marshaller (closure, return_value, param_values, param_values_length1, invocation_hint, marshal_data);
}


static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string) {
	GClosure* _tmp0_ = NULL;
	GClosure* closure;
	GQuark detail_quark;
	gulong _tmp2_;
	gulong signal_handler_id;
	gpointer _tmp3_ = NULL;
	GeeHashMap* signal_handler_ids;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_instance != NULL);
	_tmp0_ = g_closure_new_object ((gulong) sizeof (GClosure), (GObject*) self);
	closure = _tmp0_;
	g_closure_set_meta_marshal (closure, NULL, _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal);
	detail_quark = (GQuark) 0;
	if (detail_string != NULL) {
		GQuark _tmp1_;
		_tmp1_ = g_quark_try_string (detail_string);
		detail_quark = _tmp1_;
	}
	_tmp2_ = g_signal_connect_closure_by_id (class_instance, signal_id, detail_quark, closure, FALSE);
	signal_handler_id = _tmp2_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_instance, class_instance);
	signal_handler_ids = (GeeHashMap*) _tmp3_;
	if (signal_handler_ids == NULL) {
		GeeHashMap* _tmp4_ = NULL;
		GeeHashMap* _tmp5_;
		_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (signal_handler_ids);
		signal_handler_ids = _tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->signals_by_class_instance, class_instance, signal_handler_ids);
	}
	gee_abstract_map_set ((GeeAbstractMap*) signal_handler_ids, GUINT_TO_POINTER (signal_id), GUINT_TO_POINTER (signal_handler_id));
	_g_object_unref0 (signal_handler_ids);
	_g_closure_unref0 (closure);
}


static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	GeeHashMap* signal_handler_ids;
	gboolean _tmp1_ = FALSE;
	gpointer _tmp3_ = NULL;
	gulong signal_handler_id;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class_instance != NULL, FALSE);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_instance, class_instance);
	signal_handler_ids = (GeeHashMap*) _tmp0_;
	if (signal_handler_ids == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) signal_handler_ids, GUINT_TO_POINTER (signal_id));
		_tmp1_ = _tmp2_ == FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (signal_handler_ids);
		return result;
	}
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) signal_handler_ids, GUINT_TO_POINTER (signal_id));
	signal_handler_id = GPOINTER_TO_UINT (_tmp3_);
	g_signal_handler_disconnect (class_instance, signal_handler_id);
	gee_abstract_map_unset ((GeeAbstractMap*) signal_handler_ids, GUINT_TO_POINTER (signal_id), NULL);
	result = TRUE;
	_g_object_unref0 (signal_handler_ids);
	return result;
}


static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue* return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data) {
	GValue _return_value = {0};
	GSignalInvocationHint* hint;
	GSignalQuery query_info = {0};
	GSignalQuery _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	guint i;
	g_return_if_fail (closure != NULL);
	hint = (GSignalInvocationHint*) invocation_hint;
	g_signal_query ((*hint).signal_id, &_tmp0_);
	query_info = _tmp0_;
	_tmp1_ = g_type_name (query_info.itype);
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp1_, query_info.signal_name);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	{
		GValue* param_value_collection;
		int param_value_collection_length1;
		int param_value_it;
		param_value_collection = param_values;
		param_value_collection_length1 = param_values_length1;
		for (param_value_it = 0; param_value_it < param_values_length1; param_value_it = param_value_it + 1) {
			GValue _tmp2_;
			GValue _tmp3_ = {0};
			GValue param_value;
			_tmp2_ = G_IS_VALUE (&param_value_collection[param_value_it]) ? (g_value_init (&_tmp3_, G_VALUE_TYPE (&param_value_collection[param_value_it])), g_value_copy (&param_value_collection[param_value_it], &_tmp3_), _tmp3_) : param_value_collection[param_value_it];
			param_value = _tmp2_;
			{
				guint _tmp4_;
				GType _tmp5_;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
				_tmp5_ = G_VALUE_TYPE (&param_value);
				_tmp6_ = g_type_name (_tmp5_);
				_tmp7_ = folks_inspect_utils_transform_value_to_string (&param_value);
				_tmp8_ = _tmp7_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp4_, _tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	if (return_value) {
		*return_value = _return_value;
	} else {
		G_IS_VALUE (&_return_value) ? (g_value_unset (&_return_value), NULL) : NULL;
	}
}


static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self) {
	gboolean result;
	result = folks_inspect_signal_manager_emission_hook_cb (self, ihint, param_values, param_values_length1);
	return result;
}


static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string) {
	gboolean result = FALSE;
	GQuark detail_quark;
	GSignalQuery query = {0};
	GSignalQuery _tmp1_ = {0};
	gulong _tmp2_;
	gulong hook_id;
	gpointer _tmp3_ = NULL;
	GeeHashMap* hook_ids;
	g_return_val_if_fail (self != NULL, FALSE);
	detail_quark = (GQuark) 0;
	if (detail_string != NULL) {
		GQuark _tmp0_;
		_tmp0_ = g_quark_try_string (detail_string);
		detail_quark = _tmp0_;
	}
	g_signal_query (signal_id, &_tmp1_);
	query = _tmp1_;
	if ((query.signal_flags & G_SIGNAL_NO_HOOKS) != 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = g_signal_add_emission_hook (signal_id, detail_quark, _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook, self, NULL);
	hook_id = _tmp2_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_type, GINT_TO_POINTER (class_type));
	hook_ids = (GeeHashMap*) _tmp3_;
	if (hook_ids == NULL) {
		GeeHashMap* _tmp4_ = NULL;
		GeeHashMap* _tmp5_;
		_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (hook_ids);
		hook_ids = _tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->signals_by_class_type, GINT_TO_POINTER (class_type), hook_ids);
	}
	gee_abstract_map_set ((GeeAbstractMap*) hook_ids, GUINT_TO_POINTER (signal_id), GUINT_TO_POINTER (hook_id));
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	GeeHashMap* hook_ids;
	gboolean _tmp1_ = FALSE;
	gpointer _tmp3_ = NULL;
	gulong hook_id;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->signals_by_class_type, GINT_TO_POINTER (class_type));
	hook_ids = (GeeHashMap*) _tmp0_;
	if (hook_ids == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) hook_ids, GUINT_TO_POINTER (signal_id));
		_tmp1_ = _tmp2_ == FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (hook_ids);
		return result;
	}
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) hook_ids, GUINT_TO_POINTER (signal_id));
	hook_id = GPOINTER_TO_UINT (_tmp3_);
	g_signal_remove_emission_hook (signal_id, hook_id);
	gee_abstract_map_unset ((GeeAbstractMap*) hook_ids, GUINT_TO_POINTER (signal_id), NULL);
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1) {
	gboolean result = FALSE;
	GSignalQuery query_info = {0};
	GSignalQuery _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	guint i;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_query ((*hint).signal_id, &_tmp0_);
	query_info = _tmp0_;
	_tmp1_ = g_type_name (query_info.itype);
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp1_, query_info.signal_name);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	{
		GValue* param_value_collection;
		int param_value_collection_length1;
		int param_value_it;
		param_value_collection = param_values;
		param_value_collection_length1 = param_values_length1;
		for (param_value_it = 0; param_value_it < param_values_length1; param_value_it = param_value_it + 1) {
			GValue _tmp2_;
			GValue _tmp3_ = {0};
			GValue param_value;
			_tmp2_ = G_IS_VALUE (&param_value_collection[param_value_it]) ? (g_value_init (&_tmp3_, G_VALUE_TYPE (&param_value_collection[param_value_it])), g_value_copy (&param_value_collection[param_value_it], &_tmp3_), _tmp3_) : param_value_collection[param_value_it];
			param_value = _tmp2_;
			{
				guint _tmp4_;
				GType _tmp5_;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
				_tmp5_ = G_VALUE_TYPE (&param_value);
				_tmp6_ = g_type_name (_tmp5_);
				_tmp7_ = folks_inspect_utils_transform_value_to_string (&param_value);
				_tmp8_ = _tmp7_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp4_, _tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = TRUE;
	return result;
}


static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* output;
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	if ((flags & G_SIGNAL_RUN_FIRST) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat (output, "G_SIGNAL_RUN_FIRST", NULL);
		_g_free0 (output);
		output = _tmp1_;
	}
	if ((flags & G_SIGNAL_RUN_LAST) != 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		if (g_strcmp0 (output, "") != 0) {
			_tmp2_ = " | ";
		} else {
			_tmp2_ = "";
		}
		_tmp3_ = g_strconcat (_tmp2_, "G_SIGNAL_RUN_LAST", NULL);
		_tmp4_ = g_strconcat (output, _tmp3_, NULL);
		_g_free0 (output);
		output = _tmp4_;
		_g_free0 (_tmp3_);
	}
	if ((flags & G_SIGNAL_RUN_CLEANUP) != 0) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		if (g_strcmp0 (output, "") != 0) {
			_tmp5_ = " | ";
		} else {
			_tmp5_ = "";
		}
		_tmp6_ = g_strconcat (_tmp5_, "G_SIGNAL_RUN_CLEANUP", NULL);
		_tmp7_ = g_strconcat (output, _tmp6_, NULL);
		_g_free0 (output);
		output = _tmp7_;
		_g_free0 (_tmp6_);
	}
	if ((flags & G_SIGNAL_DETAILED) != 0) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		if (g_strcmp0 (output, "") != 0) {
			_tmp8_ = " | ";
		} else {
			_tmp8_ = "";
		}
		_tmp9_ = g_strconcat (_tmp8_, "G_SIGNAL_DETAILED", NULL);
		_tmp10_ = g_strconcat (output, _tmp9_, NULL);
		_g_free0 (output);
		output = _tmp10_;
		_g_free0 (_tmp9_);
	}
	if ((flags & G_SIGNAL_ACTION) != 0) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		if (g_strcmp0 (output, "") != 0) {
			_tmp11_ = " | ";
		} else {
			_tmp11_ = "";
		}
		_tmp12_ = g_strconcat (_tmp11_, "G_SIGNAL_ACTION", NULL);
		_tmp13_ = g_strconcat (output, _tmp12_, NULL);
		_g_free0 (output);
		output = _tmp13_;
		_g_free0 (_tmp12_);
	}
	if ((flags & G_SIGNAL_NO_HOOKS) != 0) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		if (g_strcmp0 (output, "") != 0) {
			_tmp14_ = " | ";
		} else {
			_tmp14_ = "";
		}
		_tmp15_ = g_strconcat (_tmp14_, "G_SIGNAL_NO_HOOKS", NULL);
		_tmp16_ = g_strconcat (output, _tmp15_, NULL);
		_g_free0 (output);
		output = _tmp16_;
		_g_free0 (_tmp15_);
	}
	result = output;
	return result;
}


static void folks_inspect_signal_manager_class_init (FolksInspectSignalManagerClass * klass) {
	folks_inspect_signal_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksInspectSignalManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_signal_manager_finalize;
}


static void folks_inspect_signal_manager_instance_init (FolksInspectSignalManager * self) {
	self->priv = FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE (self);
}


static void folks_inspect_signal_manager_finalize (GObject* obj) {
	FolksInspectSignalManager * self;
	self = FOLKS_INSPECT_SIGNAL_MANAGER (obj);
	_g_object_unref0 (self->priv->signals_by_class_type);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	G_OBJECT_CLASS (folks_inspect_signal_manager_parent_class)->finalize (obj);
}


GType folks_inspect_signal_manager_get_type (void) {
	static volatile gsize folks_inspect_signal_manager_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_signal_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectSignalManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_signal_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectSignalManager), 0, (GInstanceInitFunc) folks_inspect_signal_manager_instance_init, NULL };
		GType folks_inspect_signal_manager_type_id;
		folks_inspect_signal_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectSignalManager", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_signal_manager_type_id__volatile, folks_inspect_signal_manager_type_id);
	}
	return folks_inspect_signal_manager_type_id__volatile;
}



