/* backend-store.c generated by valac 0.9.7, the Vala compiler
 * generated from backend-store.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *          Travis Reitter <travis.reitter@collabora.co.uk>
 *
 * This file was originally part of Rygel.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gmodule.h>


#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;
typedef struct _FolksBackendStorePrivate FolksBackendStorePrivate;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksBackendStoreLoadBackendsData FolksBackendStoreLoadBackendsData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendStoreLoadModulesFromDirData FolksBackendStoreLoadModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _FolksBackendStoreIsDirData FolksBackendStoreIsDirData;

struct _FolksBackendStore {
	GObject parent_instance;
	FolksBackendStorePrivate * priv;
};

struct _FolksBackendStoreClass {
	GObjectClass parent_class;
};

typedef void (*FolksBackendStoreModuleFinalizeFunc) (FolksBackendStore* store);
struct _FolksBackendStorePrivate {
	GeeHashMap* backend_hash;
	GList* finalize_funcs;
};

struct _FolksBackendStoreLoadBackendsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	char* path;
	char* _tmp0_;
	GFile* dir;
	gboolean _tmp1_;
};

struct _FolksBackendStoreLoadModulesFromDirData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GFile* dir;
	char* _tmp0_;
	char* attributes;
	GList* infos;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	char* _tmp5_;
	GError * _error_;
	char* file_name;
	char* file_path;
	char* _tmp6_;
	char* _tmp7_;
	GFile* file;
	GFileType file_type;
	const char* content_type;
	gboolean is_symlink;
	char* mime;
	gboolean _tmp8_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* info;
	char* _tmp9_;
	GError * _inner_error_;
};

typedef void (*FolksBackendStoreModuleInitFunc) (FolksBackendStore* store);
struct _FolksBackendStoreIsDirData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gboolean result;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer folks_backend_store_parent_class = NULL;

GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKEND_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_BACKEND_STORE, FolksBackendStorePrivate))
enum  {
	FOLKS_BACKEND_STORE_DUMMY_PROPERTY
};
FolksBackendStore* folks_backend_store_new (void);
FolksBackendStore* folks_backend_store_construct (GType object_type);
static void folks_backend_store_load_backends_data_free (gpointer _data);
static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* data);
static void folks_backend_store_is_dir (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backend_store_is_dir_finish (GAsyncResult* _res_);
static void folks_backend_store_load_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backend_store_load_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_);
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend);
const char* folks_backend_get_name (FolksBackend* self);
FolksBackend* folks_backend_store_get_backend_by_name (FolksBackendStore* self, const char* name);
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self);
static void folks_backend_store_load_modules_from_dir_data_free (gpointer _data);
static void folks_backend_store_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backend_store_load_modules_from_dir_co (FolksBackendStoreLoadModulesFromDirData* data);
static void _g_list_free_g_object_unref (GList* self);
static void folks_backend_store_load_module_from_file (FolksBackendStore* self, const char* file_path);
static void folks_backend_store_is_dir_data_free (gpointer _data);
static void folks_backend_store_is_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backend_store_is_dir_co (FolksBackendStoreIsDirData* data);
static void folks_backend_store_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
   * Create a new BackendStore.
   */
FolksBackendStore* folks_backend_store_construct (GType object_type) {
	FolksBackendStore * self;
	GeeHashMap* _tmp0_;
	self = (FolksBackendStore*) g_object_new (object_type, NULL);
	self->priv->backend_hash = (_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL), _g_object_unref0 (self->priv->backend_hash), _tmp0_);
	return self;
}


FolksBackendStore* folks_backend_store_new (void) {
	return folks_backend_store_construct (FOLKS_TYPE_BACKEND_STORE);
}


static void folks_backend_store_load_backends_data_free (gpointer _data) {
	FolksBackendStoreLoadBackendsData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksBackendStoreLoadBackendsData, data);
}


void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadBackendsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_load_backends);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_load_backends_data_free);
	_data_->self = g_object_ref (self);
	folks_backend_store_load_backends_co (_data_);
}


void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendStoreLoadBackendsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backend_store_load_backends_co (data);
}


/**
   * Find and load all available backends.
   *
   * Backends will be searched for in the path given by the `FOLKS_BACKEND_DIR`
   * environment variable, if it's set. If it's not set, backends will be
   * searched for in a path set at compilation time.
   */
static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
	}
	_state_0:
	g_assert (g_module_supported ());
	data->path = g_strdup (g_getenv ("FOLKS_BACKEND_DIR"));
	if (data->path == NULL) {
		data->path = (data->_tmp0_ = g_strdup (BACKEND_DIR), _g_free0 (data->path), data->_tmp0_);
		g_debug ("Using built-in backend dir '%s' (override with environment " "variable FOLKS_BACKEND_DIR)", data->path);
	} else {
		g_debug ("Using environment variable FOLKS_BACKEND_DIR = '%s' to look " "for backends", data->path);
	}
	data->dir = g_file_new_for_path (data->path);
	if (data->dir != NULL) {
		data->_state_ = 1;
		folks_backend_store_is_dir (data->dir, folks_backend_store_load_backends_ready, data);
		return FALSE;
		_state_1:
		data->_tmp1_ = folks_backend_store_is_dir_finish (data->_res_);
	} else {
		data->_tmp1_ = FALSE;
	}
	g_assert (data->_tmp1_);
	data->_state_ = 2;
	folks_backend_store_load_modules_from_dir (data->self, data->dir, folks_backend_store_load_backends_ready, data);
	return FALSE;
	_state_2:
	folks_backend_store_load_modules_from_dir_finish (data->self, data->_res_);
	_g_object_unref0 (data->dir);
	_g_free0 (data->path);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
   * Add a new {@link Backend} to the BackendStore.
   *
   * @param backend the {@link Backend} to add
   */
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_debug ("backend-store.vala:105: New backend '%s' available", folks_backend_get_name (backend));
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->backend_hash, folks_backend_get_name (backend), backend);
	g_signal_emit_by_name (self, "backend-available", backend);
}


/**
   * Get a backend from the store by name.
   *
   * @param name the backend name to retrieve
   * @return the backend, or `null` if none could be found
   */
FolksBackend* folks_backend_store_get_backend_by_name (FolksBackendStore* self, const char* name) {
	FolksBackend* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = (FolksBackend*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->backend_hash, name);
	return result;
}


/**
   * List the currently loaded backends.
   *
   * @return a list of the backends currently in the BackendStore
   */
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self) {
	GeeCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = gee_map_get_values ((GeeMap*) self->priv->backend_hash);
	return result;
}


static void folks_backend_store_load_modules_from_dir_data_free (gpointer _data) {
	FolksBackendStoreLoadModulesFromDirData* data;
	data = _data;
	_g_object_unref0 (data->dir);
	g_object_unref (data->self);
	g_slice_free (FolksBackendStoreLoadModulesFromDirData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backend_store_load_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadModulesFromDirData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadModulesFromDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_load_modules_from_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_load_modules_from_dir_data_free);
	_data_->self = g_object_ref (self);
	_data_->dir = _g_object_ref0 (dir);
	folks_backend_store_load_modules_from_dir_co (_data_);
}


static void folks_backend_store_load_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreLoadModulesFromDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backend_store_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadModulesFromDirData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backend_store_load_modules_from_dir_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean folks_backend_store_load_modules_from_dir_co (FolksBackendStoreLoadModulesFromDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
	}
	_state_0:
	g_debug ("backend-store.vala:133: Searching for modules in folder '%s' ..", data->_tmp0_ = g_file_get_path (data->dir));
	_g_free0 (data->_tmp0_);
	data->attributes = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	{
		data->_state_ = 3;
		g_file_enumerate_children_async (data->dir, data->attributes, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, folks_backend_store_load_modules_from_dir_ready, data);
		return FALSE;
		_state_3:
		data->_tmp1_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		data->enumerator = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->enumerator), data->_tmp2_);
		data->_state_ = 4;
		g_file_enumerator_next_files_async (data->enumerator, G_MAXINT, G_PRIORITY_DEFAULT, NULL, folks_backend_store_load_modules_from_dir_ready, data);
		return FALSE;
		_state_4:
		data->_tmp3_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		data->infos = (data->_tmp4_ = data->_tmp3_, __g_list_free_g_object_unref0 (data->infos), data->_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_critical ("backend-store.vala:153: Error listing contents of folder '%s': %s", data->_tmp5_ = g_file_get_path (data->dir), data->_error_->message);
			_g_free0 (data->_tmp5_);
			_g_error_free0 (data->_error_);
			_g_object_unref0 (data->enumerator);
			__g_list_free_g_object_unref0 (data->infos);
			_g_free0 (data->attributes);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->_error_);
		}
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->enumerator);
		__g_list_free_g_object_unref0 (data->infos);
		_g_free0 (data->attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		data->info_collection = data->infos;
		for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
			data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
			{
				data->file_name = g_strdup (g_file_info_get_name (data->info));
				data->file_path = (data->_tmp7_ = g_build_filename (data->_tmp6_ = g_file_get_path (data->dir), data->file_name, NULL), _g_free0 (data->_tmp6_), data->_tmp7_);
				data->file = g_file_new_for_path (data->file_path);
				data->file_type = g_file_info_get_file_type (data->info);
				data->content_type = g_file_info_get_content_type (data->info);
				data->is_symlink = g_file_info_get_is_symlink (data->info);
				data->mime = g_content_type_get_mime_type (data->content_type);
				if (data->file_type == G_FILE_TYPE_DIRECTORY) {
					data->_state_ = 5;
					folks_backend_store_load_modules_from_dir (data->self, data->file, folks_backend_store_load_modules_from_dir_ready, data);
					return FALSE;
					_state_5:
					folks_backend_store_load_modules_from_dir_finish (data->self, data->_res_);
				} else {
					if (_vala_strcmp0 (data->mime, "application/x-sharedlib") == 0) {
						data->_tmp8_ = !data->is_symlink;
					} else {
						data->_tmp8_ = FALSE;
					}
					if (data->_tmp8_) {
						folks_backend_store_load_module_from_file (data->self, data->file_path);
					} else {
						if (data->mime == NULL) {
							g_warning ("MIME type could not be determined for file '%s'. " "Have you installed shared-mime-info?", data->file_path);
						}
					}
				}
				_g_free0 (data->mime);
				_g_object_unref0 (data->file);
				_g_free0 (data->file_path);
				_g_free0 (data->file_name);
				_g_object_unref0 (data->info);
			}
		}
	}
	g_debug ("backend-store.vala:188: Finished searching for modules in folder '%s'", data->_tmp9_ = g_file_get_path (data->dir));
	_g_free0 (data->_tmp9_);
	_g_object_unref0 (data->enumerator);
	__g_list_free_g_object_unref0 (data->infos);
	_g_free0 (data->attributes);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backend_store_load_module_from_file (FolksBackendStore* self, const char* file_path) {
	GModule* module;
	void* function = NULL;
	FolksBackendStoreModuleInitFunc module_init;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	module = g_module_open (file_path, G_MODULE_BIND_LOCAL);
	if (module == NULL) {
		g_warning ("backend-store.vala:197: Failed to load module from path '%s' : %s", file_path, g_module_error ());
		_g_module_close0 (module);
		return;
	}
	if (!g_module_symbol (module, "module_init", &function)) {
		g_warning ("backend-store.vala:207: Failed to find entry point function '%s' in '%" \
"s': %s", "module_init", file_path, g_module_error ());
		_g_module_close0 (module);
		return;
	}
	module_init = (FolksBackendStoreModuleInitFunc) function;
	g_assert (module_init != NULL);
	if (g_module_symbol (module, "module_finalize", &function)) {
		FolksBackendStoreModuleFinalizeFunc module_finalize;
		module_finalize = (FolksBackendStoreModuleFinalizeFunc) function;
		self->priv->finalize_funcs = g_list_prepend (self->priv->finalize_funcs, module_finalize);
	}
	g_module_make_resident (module);
	module_init (self);
	g_debug ("backend-store.vala:230: Loaded module source: '%s'", g_module_name (module));
	_g_module_close0 (module);
}


static void folks_backend_store_is_dir_data_free (gpointer _data) {
	FolksBackendStoreIsDirData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_slice_free (FolksBackendStoreIsDirData, data);
}


static void folks_backend_store_is_dir (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreIsDirData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreIsDirData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_backend_store_is_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_is_dir_data_free);
	_data_->file = _g_object_ref0 (file);
	folks_backend_store_is_dir_co (_data_);
}


static gboolean folks_backend_store_is_dir_finish (GAsyncResult* _res_) {
	gboolean result;
	FolksBackendStoreIsDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void folks_backend_store_is_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreIsDirData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backend_store_is_dir_co (data);
}


static gboolean folks_backend_store_is_dir_co (FolksBackendStoreIsDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
	}
	_state_0:
	{
		data->_state_ = 6;
		g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, folks_backend_store_is_dir_ready, data);
		return FALSE;
		_state_6:
		data->_tmp0_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		data->file_info = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->file_info), data->_tmp1_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			if (g_error_matches (data->_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				g_critical ("backend-store.vala:247: File or directory '%s' does not exist", data->_tmp2_ = g_file_get_path (data->file));
				_g_free0 (data->_tmp2_);
			} else {
				g_critical ("backend-store.vala:250: Failed to get content type for '%s'", data->_tmp3_ = g_file_get_path (data->file));
				_g_free0 (data->_tmp3_);
			}
			data->result = FALSE;
			_g_error_free0 (data->_error_);
			_g_object_unref0 (data->file_info);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->_error_);
		}
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = g_file_info_get_file_type (data->file_info) == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (data->file_info);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->file_info);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backend_store_class_init (FolksBackendStoreClass * klass) {
	folks_backend_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_backend_store_finalize;
	/**
	   * Emitted when a backend has been added to the BackendStore.
	   *
	   * This will not be emitted until after {@link BackendStore.load_backends}
	   * has been called.
	   *
	   * @param backend the new {@link Backend}
	   */
	g_signal_new ("backend_available", FOLKS_TYPE_BACKEND_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_BACKEND);
}


static void folks_backend_store_instance_init (FolksBackendStore * self) {
	self->priv = FOLKS_BACKEND_STORE_GET_PRIVATE (self);
	self->priv->finalize_funcs = NULL;
}


static void folks_backend_store_finalize (GObject* obj) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (obj);
	{
		{
			GList* func_collection;
			GList* func_it;
			func_collection = self->priv->finalize_funcs;
			for (func_it = func_collection; func_it != NULL; func_it = func_it->next) {
				FolksBackendStoreModuleFinalizeFunc func;
				func = func_it->data;
				{
					func (self);
				}
			}
		}
	}
	_g_object_unref0 (self->priv->backend_hash);
	_g_list_free0 (self->priv->finalize_funcs);
	G_OBJECT_CLASS (folks_backend_store_parent_class)->finalize (obj);
}


/**
 * Responsible for backend loading. Probes for shared library files in a
 * specific directory, looking for (and calling) a specific function (by name,
 * signature).
 */
GType folks_backend_store_get_type (void) {
	static volatile gsize folks_backend_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backend_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendStore), 0, (GInstanceInitFunc) folks_backend_store_instance_init, NULL };
		GType folks_backend_store_type_id;
		folks_backend_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackendStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backend_store_type_id__volatile, folks_backend_store_type_id);
	}
	return folks_backend_store_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




