#ifndef _E_MAIL_REMOTE_GLUE_H_
#define _E_MAIL_REMOTE_GLUE_H_

#include <glib/gmacros.h>
#include <glib-object.h>

#include "Evolution-DataServer-Mail.h"
#include "evolution-mail-sessionlistener.h"
#include "evolution-mail-storelistener.h"
#include "evolution-mail-folderlistener.h"
#include "e-mail-remote-glue-storeinfo.h"

G_BEGIN_DECLS

#define E_TYPE_MAIL_REMOTE_GLUE           (e_mail_remote_glue_get_type ())
#define E_MAIL_REMOTE_GLUE(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_MAIL_REMOTE_GLUE, \
									 EMailRemoteGlue))
#define E_MAIL_REMOTE_GLUE_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_MAIL_REMOTE_GLUE,  \
								      EMailRemoteGlueClass))
#define E_IS_MAIL_REMOTE_GLUE(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_MAIL_REMOTE_GLUE))
#define E_IS_MAIL_REMOTE_GLUE_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), E_TYPE_MAIL_REMOTE_GLUE))


typedef struct _EMailRemoteGlue EMailRemoteGlue;
typedef struct _EMailRemoteGluePrivate EMailRemoteGluePrivate;
typedef struct _EMailRemoteGlueClass EMailRemoteGlueClass;

struct _EMailRemoteGlue {
  GObject parent_instance;  

  /*< private >*/
  EMailRemoteGluePrivate *priv;
};

struct _EMailRemoteGlueClass {
  GObjectClass parent_class;

  /* Signals */

  void (* session_changed_added) (EMailRemoteGlue *emrg, GSList *added);
  void (* session_changed_removed) (EMailRemoteGlue *emrg, GSList *removed);
  void (* session_changed_changed) (EMailRemoteGlue *emrg, GSList *changed);
  void (* session_shutdown) (EMailRemoteGlue *emrg, void *data);
  void (* store_changed_added) (EMailRemoteGlue *emrg, GSList *added);
  void (* store_changed_removed) (EMailRemoteGlue *emrg, GSList *removed);
  void (* store_changed_changed) (EMailRemoteGlue *emrg, GSList *changed);
  void (* folder_changed_added) (EMailRemoteGlue *emrg, GSList *added);
  void (* folder_changed_removed) (EMailRemoteGlue *emrg, GSList *removed);
  void (* folder_changed_changed) (EMailRemoteGlue *emrg, GSList *changed);
};

G_END_DECLS

EMailRemoteGlue* e_mail_remote_glue_new (void);
gboolean e_mail_remote_glue_lookup_plugin_and_initialize (EMailRemoteGlue* emrg);
GSList* e_mail_remote_glue_get_stores (EMailRemoteGlue* emrg);
EvolutionMailSessionListener* e_mail_remote_glue_peek_session_listener (EMailRemoteGlue* emrg);
EvolutionMailStoreListener* e_mail_remote_glue_peek_store_listener (EMailRemoteGlue* emrg);
EvolutionMailFolderListener* e_mail_remote_glue_peek_folder_listener (EMailRemoteGlue* emrg);
#endif
