/* sunone-error-codes.h
 *
 * Copyright (C) 2002-2004 Sun Microsystems, Inc
 *
 * AUTHORS
 *     Jack Jia <jack.jia@sun.com>
 *     Harry Lu <harry.lu@sun.com>
 *     Alfred Peng <alfred.peng@sun.com>
 *     Rodrigo Moya <rodrigo@ximian.com>
 *
 */

#ifndef SUNONE_ERROR_CODES_H
#define SUNONE_ERROR_CODES_H

#include <libsoup/soup-status.h>

enum {
	SUNONE_ERROR_LOGOUT_SUCCESSFUL = 1000,              // -1
	SUNONE_ERROR_COMMAND_SUCCESSFUL,                    // 0
	SUNONE_ERROR_LOGIN_FAILED,                          // 1
	SUNONE_ERROR_LOGIN_OK_DEFAULT_CALENDAR_NOT_FOUND,   // 2
	SUNONE_ERROR_COMMAND_FAILED,                        // 3-24, 26-27, 36, 39, 41-42, 55, 56, 70-74
	SUNONE_ERROR_CALENDAR_ALREADY_EXISTS,               // 25	
	SUNONE_ERROR_ACCESS_DENIED,                         // 28, 44, 76
	SUNONE_ERROR_CALENDAR_DOES_NOT_EXIST,               // 29
	SUNONE_ERROR_ILLEGAL_CALID_NAME,                    // 30
	SUNONE_ERROR_CANNOT_MODIFY_LINKED_OBJECTS,          // 31-32
	SUNONE_ERROR_CANNOT_SEND_MAIL,                      // 33
	SUNONE_ERROR_CALENDAR_DISABLED,                     // 34
	SUNONE_ERROR_WRITE_IMPORT_FAILED,                   // 35
	SUNONE_ERROR_CAPI_NOT_SUPPORTED,                    // 37
	SUNONE_ERROR_CALID_NOT_SPECIFIED,                   // 38
	SUNONE_ERROR_STORE_FAILED_DOUBLE_BOOKED,            // 40
	SUNONE_ERROR_ATTENDEE_GROUP_EXPANSION_CLIPPED,      // 43
	SUNONE_ERROR_NOT_ALLOWED_TO_REQUEST_PUBLISH,        // 45
	SUNONE_ERROR_INSUFFICIENT_PARAMETERS,               // 46
	SUNONE_ERROR_MUSTBEOWNER_OPERATION,                 // 47
	SUNONE_ERROR_WCAP_NO_SUCH_FORMAT,                   // 58
	SUNONE_ERROR_COMPONENT_NOT_FOUND,                   // 59
	SUNONE_ERROR_BAD_ARGUMENTS,			    			// 60
	SUNONE_ERROR_GET_USERPREFS_FAILED,					// 61
	SUNONE_ERROR_WCAP_MODIFY_NO_EVENT,					// 62
	SUNONE_ERROR_WCAP_CREATE_EXISTS,					// 63
	SUNONE_ERROR_WCAP_MODIFY_CANT_MAKE_COPY,			// 64
	SUNONE_ERROR_STORE_FAILED_RECUR_SKIP,				// 65
	SUNONE_ERROR_STORE_FAILED_RECUR_SAMEDAY,			// 66
	SUNONE_ERROR_BAD_ORG_ARGUMENTS,						// 67
	SUNONE_ERROR_LDAP_ERROR,			 				// 69
	SUNONE_ERROR_ANONYMOUS_NOT_ALLOWED,					// 75
	SUNONE_ERROR_BAD_IMPORT_ARGUMENTS,				    // 77
	SUNONE_ERROR_READONLY_DATABASE,					    // 78
	SUNONE_ERROR_ATTENDEE_NOT_ALLOWED_TO_REQUEST_ON_MODIFY,		// 79
	SUNONE_ERROR_TRANSP_RESOURCE_NOT_ALLOWED,			// 80
	SUNONE_ERROR_RECURRING_COMP_NOT_FOUND,				// 81
	SUNONE_ERROR_NUMBER
};

#define SUNONE_ERROR_IS_SUCCESSFUL(errorcode) \
        (errorcode < 1000 ? SOUP_STATUS_IS_SUCCESSFUL(errorcode) : \
                            errorcode == SUNONE_ERROR_LOGOUT_SUCCESSFUL || \
                            errorcode == SUNONE_ERROR_COMMAND_SUCCESSFUL || \
                            errorcode == SUNONE_ERROR_LOGIN_OK_DEFAULT_CALENDAR_NOT_FOUND)

#endif
