// -*- c++ -*-
#ifndef _LIBCLUTTER_GTKMM_UTILITY_H
#define _LIBCLUTTER_GTKMM_UTILITY_H
/*
 * Copyright 2008-2009 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <cluttermm/texture.h>

namespace Clutter
{
namespace Gtk
{

void get_fg_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_bg_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_text_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_base_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_text_aa_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_light_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_mid_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
void get_dark_color(::Gtk::Widget& widget, ::Gtk::StateType state, Color& color);
Glib::RefPtr<Texture> create_texture_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
Glib::RefPtr<Texture> create_texture_from_stock(::Gtk::Widget& widget, const Glib::ustring& stock_id, ::Gtk::IconSize size);
Glib::RefPtr<Texture> create_texture_from_icon_name(::Gtk::Widget& widget, const Glib::ustring& icon_name, ::Gtk::IconSize size);
void set_texture_from_pixbuf(const Glib::RefPtr<Texture>& texture, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
void set_texture_from_stock(const Glib::RefPtr<Texture>& texture, ::Gtk::Widget& widget, const Glib::ustring& stock_id, ::Gtk::IconSize size);
void set_texture_from_icon_name(const Glib::RefPtr<Texture>& texture, ::Gtk::Widget& widget, const Glib::ustring& icon_name, ::Gtk::IconSize size);

} //namespace Gtk
} //namespace Clutter

#endif //_LIBCLUTTER_GTKMM_UTILITY_H

