/*
 * bonobo-property-editor-option.c:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdarg.h>
#include <bonobo.h>

#include "bonobo-property-editor.h"

static void
selection_done_cb (GtkMenuShell *menushell,
		   gpointer      user_data)
{
	BonoboPEditor *editor = BONOBO_PEDITOR (user_data);
	BonoboArg *arg;
	GtkWidget *a;
	GList *l;
	guint32 v = 0;

	l = menushell->children;

	a = gtk_menu_get_active (GTK_MENU (menushell));

	while (l && (l->data != a)) {
		++v;
		l = l->next;
	}

	if (!l)
		return;

	arg = bonobo_arg_new (TC_ulong);
	
	BONOBO_ARG_SET_GENERAL (arg, v, TC_ulong, CORBA_unsigned_long, NULL);
	
	bonobo_peditor_set_value (editor, arg, NULL);

	bonobo_arg_release (arg);
}

static void
toggled_cb (GtkRadioButton *rb,
	    gpointer        user_data) 
{
	BonoboPEditor *editor = BONOBO_PEDITOR (user_data);
	BonoboArg *arg;
	gboolean active;
	GSList *l;
	guint32 v = 0;

	l = rb->group;
	v = g_slist_length (l) - 1;

	while (l) {
		if (rb == l->data)
			break;
		v--;
		l = l->next;
	}
	
	if ((active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rb)))) {
		arg = bonobo_arg_new (TC_ulong);

		BONOBO_ARG_SET_GENERAL (arg, v, TC_ulong, CORBA_unsigned_long,
					NULL);
	
		bonobo_peditor_set_value (editor, arg, NULL);

		bonobo_arg_release (arg);
	}
}

static void
menu_set_value_cb (BonoboPEditor     *editor,
		   BonoboArg         *arg,
		   CORBA_Environment *ev)
{
	GtkWidget *om, *menu;
	guint32 v;

	if (!bonobo_arg_type_is_equal (arg->_type, TC_ulong, NULL))
		return;

	if (!(om = bonobo_peditor_get_widget (editor)))
		return;
	
	v = BONOBO_ARG_GET_GENERAL (arg, TC_ulong, CORBA_unsigned_long, NULL);

	menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (om));

	gtk_option_menu_set_history (GTK_OPTION_MENU (om), v);
}

static void
toggle_set_value_cb (BonoboPEditor     *editor,
		     BonoboArg         *arg,
		     CORBA_Environment *ev)
{
	GtkWidget *box, *rb;
	guint32 v, i = 0;
	GList *l;

	if (!bonobo_arg_type_is_equal (arg->_type, TC_ulong, NULL))
		return;

	if (!(box = bonobo_peditor_get_widget (editor)))
		return;

	v = BONOBO_ARG_GET_GENERAL (arg, TC_ulong, CORBA_unsigned_long, NULL);

	l = GTK_BOX (box)->children;

	while (l && (i++ != v) && (l = l->next));

	if (l) {
		rb = ((GtkBoxChild *)l->data)->widget;

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rb), TRUE);
	}
}

GtkObject *
bonobo_peditor_option_new (gint   mode, 
			   char **titles)
{
	GtkWidget *widget, *rb = NULL, *menu, *item;
	char *s;

	g_return_val_if_fail (titles != NULL, NULL);
	g_return_val_if_fail (titles [0] != NULL, NULL);

	if (mode == 1 || mode == 2) {

		if (mode == 1)
			widget = gtk_hbox_new (FALSE, 0);
		else
			widget = gtk_vbox_new (FALSE, 0);

		while ((s = *(titles++))) {
			rb = gtk_radio_button_new_with_label_from_widget 
				(rb ? GTK_RADIO_BUTTON (rb) : NULL, s);
			gtk_box_pack_start_defaults (GTK_BOX (widget), rb);
			gtk_widget_show (rb);
		}

	} else {

		menu = gtk_menu_new ();

		while ((s = *(titles++))) {
			item = gtk_menu_item_new_with_label (s);
			gtk_widget_show (item);
			gtk_menu_append (GTK_MENU (menu), item);
		}

		widget = gtk_option_menu_new ();
		gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);
		gtk_widget_show (widget);
	}

	return bonobo_peditor_option_construct (mode, widget);
}

GtkObject *
bonobo_peditor_option_construct (gint mode, GtkWidget *widget)
{
	GtkWidget *menu;
	BonoboPEditor *ed;
	GList *node;

	g_return_val_if_fail (widget != NULL, NULL);		

	if (mode == 1 || mode == 2) {
		g_return_val_if_fail (GTK_IS_BOX (widget), NULL);

		ed = bonobo_peditor_construct (widget, toggle_set_value_cb, 
					       TC_ulong);

		for (node = GTK_BOX (widget)->children; node; node = node->next)
			if (GTK_IS_RADIO_BUTTON (node->data))
				gtk_signal_connect (GTK_OBJECT (node->data), 
				        "toggled", (GtkSignalFunc) toggled_cb,
					ed);

	} else {
		g_return_val_if_fail (GTK_IS_OPTION_MENU (widget), NULL);

		ed = bonobo_peditor_construct (widget, menu_set_value_cb, 
					       TC_ulong);

		menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (widget));

		gtk_signal_connect (GTK_OBJECT (menu), "selection-done",
				    (GtkSignalFunc) selection_done_cb, ed); 

	}
	
	return GTK_OBJECT (ed);
}
