AC_DEFUN([BANSHEE_CHECK_LIBBANSHEE],
[
	AC_ISC_POSIX
	AC_PROG_CC

	AC_HEADER_STDC

	AM_PATH_GLIB_2_0

	LIBBANSHEE_LIBS=""
	LIBBANSHEE_CFLAGS=""

	GRAPHICS_SUBSYSTEM="Unknown"

	if test x$(pkg-config --variable=target gtk+-2.0) = xx11; then
		PKG_CHECK_MODULES(GDK_X11, gdk-x11-2.0 >= 2.8)
		SHAMROCK_CONCAT_MODULE(LIBBANSHEE, GDK_X11)
		GRAPHICS_SUBSYSTEM="X11"
	elif test x$(pkg-config --variable=target gtk+-2.0) = xquartz; then
		PKG_CHECK_MODULES(GDK_QUARTZ, gdk-quartz-2.0 >= 2.14)
		SHAMROCK_CONCAT_MODULE(LIBBANSHEE, GDK_QUARTZ)
		GRAPHICS_SUBSYSTEM="Quartz"
	fi

	AM_CONDITIONAL(HAVE_X11, test "x$GRAPHICS_SUBSYSTEM" = "xX11")
	AM_CONDITIONAL(HAVE_QUARTZ, test "x$GRAPHICS_SUBSYSTEM" = "xQuartz")

	AC_SUBST(GRAPHICS_SUBSYSTEM)
	AC_SUBST(LIBBANSHEE_CFLAGS)
	AC_SUBST(LIBBANSHEE_LIBS)
])

