/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-plugin-factory.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_PLUGIN_FACTORY_H_
#define _IANJUTA_PLUGIN_FACTORY_H_

#include <glib-object.h>
#include <libanjuta/anjuta-plugin.h>
#include <libanjuta/anjuta-shell.h>
#include <libanjuta/anjuta-plugin-handle.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_PLUGIN_FACTORY (ianjuta_plugin_factory_get_type ())
#define IANJUTA_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_PLUGIN_FACTORY, IAnjutaPluginFactory))
#define IANJUTA_IS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_PLUGIN_FACTORY))
#define IANJUTA_PLUGIN_FACTORY_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_PLUGIN_FACTORY, IAnjutaPluginFactoryIface))

#define IANJUTA_TYPE_PLUGIN_FACTORY_ERROR (ianjuta_plugin_factory_error_get_type())

#define IANJUTA_PLUGIN_FACTORY_ERROR ianjuta_plugin_factory_error_quark()

typedef struct _IAnjutaPluginFactory IAnjutaPluginFactory;
typedef struct _IAnjutaPluginFactoryIface IAnjutaPluginFactoryIface;

/**
 * IAnjutaPluginFactoryError:
 * @IANJUTA_PLUGIN_FACTORY_MISSING_LOCATION: Module file location is
 *	missing in .plugin file
 * @IANJUTA_PLUGIN_FACTORY_MISSING_TYPE: Plugin type (just after
 *	double colon following location) is missing in .plugin file
 * @IANJUTA_PLUGIN_FACTORY_MISSING_MODULE: Module file name not found,
 *	plugin module is probably not installed
 * @IANJUTA_PLUGIN_FACTORY_UNLOADABLE_MODULE: Module file cannot be
 *	loaded, not a shared library perhaps
 * @IANJUTA_PLUGIN_FACTORY_MISSING_FUNCTION: Module does not contain
 *	registration function, library is not an anjuta plugin or
 *	is not for the right version
 * @IANJUTA_PLUGIN_FACTORY_INVALID_TYPE: Module has not registered
 * 	plugin type, library is not an anjuta plugin or not for
 *	the right version
 * @IANJUTA_PLUGIN_FACTORY_UNKNOWN_ERROR: Another error
 	 *
 	 * These enumeration is used to specify errors.
 */
typedef enum {
	IANJUTA_PLUGIN_FACTORY_OK = 0,
	IANJUTA_PLUGIN_FACTORY_MISSING_LOCATION,
	IANJUTA_PLUGIN_FACTORY_MISSING_TYPE,
	IANJUTA_PLUGIN_FACTORY_MISSING_MODULE,
	IANJUTA_PLUGIN_FACTORY_INVALID_MODULE,
	IANJUTA_PLUGIN_FACTORY_MISSING_FUNCTION,
	IANJUTA_PLUGIN_FACTORY_INVALID_TYPE,
	IANJUTA_PLUGIN_FACTORY_UNKNOWN_ERROR,
} IAnjutaPluginFactoryError;


struct _IAnjutaPluginFactoryIface {
	GTypeInterface g_iface;
	

	AnjutaPlugin* (*new_plugin) (IAnjutaPluginFactory *obj, AnjutaPluginHandle* handle,  AnjutaShell *shell, GError **err);

};
GType ianjuta_plugin_factory_error_get_type (void);

GQuark ianjuta_plugin_factory_error_quark     (void);
GType  ianjuta_plugin_factory_get_type        (void);

AnjutaPlugin* ianjuta_plugin_factory_new_plugin (IAnjutaPluginFactory *obj, AnjutaPluginHandle* handle,  AnjutaShell *shell, GError **err);


G_END_DECLS

#endif
