/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor
 * @title: IAnjutaEditor
 * @short_description: Text editor interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor.h
 * 
 */

#include "ianjuta-editor.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_append:
 * @obj: Self
 * @text: Text to append.
 * @length: Length of @text to use.
 * @err: Error propagation and reporting
 *
 * Appends @length characters from @text buffer at the end of editor
 * buffer. If @length is -1, the whole @text is used.
 */
void
ianjuta_editor_append (IAnjutaEditor *obj, const gchar *text,   gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->append (obj, text, length, err);
}

/* Default implementation */
static void
ianjuta_editor_append_default (IAnjutaEditor *obj, const gchar *text,   gint length, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_erase:
 * @obj: Self
 * @position: Start position of chars to erase. Must be 0 or more.
 * @length: number of chars to erase. -1 means till the end of document.
 * @err: Error propagation and reporting
 *
 * Erases the @length number of chars starting from @position. If length
 * is 0, nothing happens.
 */
void
ianjuta_editor_erase (IAnjutaEditor *obj, gint position,   gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->erase (obj, position, length, err);
}

/* Default implementation */
static void
ianjuta_editor_erase_default (IAnjutaEditor *obj, gint position,   gint length, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_erase_all:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Empties the whole editor buffer. There will be zero characters.
 */
void
ianjuta_editor_erase_all (IAnjutaEditor *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->erase_all (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_erase_all_default (IAnjutaEditor *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_get_cell_iter:
 * @obj: Self
 * @position: Byte position where the iter will be set
 * @err: Error propagation and reporting
 *
 * Creates and returns an iter for editor cells. The iter is
 * placed at the unicode character position where the given byte
     * @position happens to fall (means given @position does not necessarily
 * is the current position of the iter). The returned iter
 * is cell (character) iter and not byte iter, so all iter operations
 * on it are character (not byte) iteration, including all position
     * and index references in the iter. However, the @position paramter
     * passed to this function is byte position (because all editor
 	 * Aoperations are based on byte positions). @position could happen
     * to be in the middle of a unicode character and that is a vaild
     * situation.
     *
     * The iter must be
     * unreferrenced by the caller when done. The iter navigates
     * (next/previous) in step of unicode characters (one unicode
 	 * character == one cell).
 * 
 * Retruns: a newly created iter of IAnjutaEditorCell placed at the
 * given position.
 */
IAnjutaIterable*
ianjuta_editor_get_cell_iter (IAnjutaEditor *obj, gint position, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_cell_iter (obj, position, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_editor_get_cell_iter_default (IAnjutaEditor *obj, gint position, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_get_current_column:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains number of the current column in the editor.
 *
 * Return value: Current column.
 */
gint
ianjuta_editor_get_column (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_column (obj, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_column_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_editor_get_current_word:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains the word on which carat is currently on.
 *
 * Return value: Current word.
 */
gchar*
ianjuta_editor_get_current_word (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_current_word (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_get_current_word_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_get_length:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get length of complete text in editor. This will be the total
 * number of characters in the file or buffer.
 *
 * Return value: Text length.
 */
gint
ianjuta_editor_get_length (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_length (obj, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_length_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
* ianjuta_editor_get_line_begin_position:
* @obj: Self
* @line: fixme
* @err: Error propagation and reporting.
*
* fixme
*
* Returns: fixme
*/
gint
ianjuta_editor_get_line_begin_position (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_begin_position (obj, line, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_line_begin_position_default (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
* ianjuta_editor_get_line_end_position:
* @obj: Self
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
gint
ianjuta_editor_get_line_end_position (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_end_position (obj, line, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_line_end_position_default (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_editor_line_from_position:
 * @obj: Self
 * @position: Position you want to know the line from
 * @err: Error propagation and reporting
 *
 * Get the line number in which @position locates.
 * Returns: Line which corresponds to @position
 *
 */
int
ianjuta_editor_get_line_from_position (IAnjutaEditor *obj, int position, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), 0);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_from_position (obj, position, err);
}

/* Default implementation */
static int
ianjuta_editor_get_line_from_position_default (IAnjutaEditor *obj, int position, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_editor_get_lineno:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains current line number on which carat is.
 *
 * Return value: Line number.
 */
gint
ianjuta_editor_get_lineno (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_lineno (obj, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_lineno_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_editor_get_overwrite:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains editor overwirte mode: TRUE = Override, FALSE = Insert.
 *
 * Return value: editor mode.
 */
gboolean
ianjuta_editor_get_overwrite (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), FALSE);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_overwrite (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_get_overwrite_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/*
 * ianjuta_editor_get_position:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get current caret position
 *
 * Returns: Current character position since the begining of file.
 */
gint
ianjuta_editor_get_position (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_position (obj, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_position_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/*
 * ianjuta_editor_get_position_iter:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get current caret position
 *
 * Returns: Iterator that points to the current position
 */
IAnjutaIterable*
ianjuta_editor_get_position_iter (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_position_iter (obj, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_editor_get_position_iter_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_get_tabsize:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Returns the tabsize (in spaces) currently used by the editor.
 *
 * Returns: tabsize in number of spaces
 */
gint
ianjuta_editor_get_tabsize (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_tabsize (obj, err);
}

/* Default implementation */
static gint
ianjuta_editor_get_tabsize_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_editor_get_text:
 * @obj: Self
 * @position: Begining position. Must be greater than or equal to 0.
 * @length: length of the text. -1 means till the end of document.
 * @err: Error propagation and reporting
 *
 * Gets @length text characters beginning from @position
 * (including char pointed by @position). If @length is less then
 * 0 or exceeds document length, text till the end of the document is
 * returned. @start must be 0 or greater then 0. If @start is beyond
 * document length, NULL is returned. If @length is 0, NULL is returned.
 * The characters returned are utf-8 encoded.
 *
 * Returns: A buffer of utf-8 characters.
 * The returned buffer must be freed when no longer required.
 */
gchar*
ianjuta_editor_get_text (IAnjutaEditor *obj, gint position,   gint length, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_text (obj, position, length, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_get_text_default (IAnjutaEditor *obj, gint position,   gint length, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_get_text_iter:
 * @obj: Self
 * @begin: Begining iterator
 * @end: End iterator
 * @err: Error propagation and reporting
 *
 * Gets text characters beginning from @begin
 * (including char pointed by @begin) and ending with @end
 * The characters returned are utf-8 encoded.
 *
 * Returns: A buffer of utf-8 characters.
 * The returned buffer must be freed when no longer required.
 */
gchar*
ianjuta_editor_get_text_iter (IAnjutaEditor *obj, IAnjutaIterable* begin,   IAnjutaIterable* end, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(begin), NULL);
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(end), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_text_iter (obj, begin, end, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_get_text_iter_default (IAnjutaEditor *obj, IAnjutaIterable* begin,   IAnjutaIterable* end, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_get_use_spaces:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Returns if the editor uses spaces for filling up tab characters.
 *
 * Returns: TRUE if yes, FALSE if no.
 */
gboolean
ianjuta_editor_get_use_spaces (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), FALSE);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_use_spaces (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_get_use_spaces_default (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_editor_goto_line:
 * @obj: Self
 * @lineno: line number where carat will be moved.
 * @err: Error propagation and reporting
 *
 * Carat is moved to the given @lineno line and text view is scrolled to
 * bring it in viewable area of the editor.
 */
void
ianjuta_editor_goto_line (IAnjutaEditor *obj, gint lineno, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->goto_line (obj, lineno, err);
}

/* Default implementation */
static void
ianjuta_editor_goto_line_default (IAnjutaEditor *obj, gint lineno, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_goto_position:
 * @obj: Self
 * @position: Character position where carat will be moved.
 * @err: Error propagation and reporting
 *
 * Carat is moved to the given @position and text view is scrolled to
 * bring @position in viewable area of the editor.
 */
void
ianjuta_editor_goto_position (IAnjutaEditor *obj, gint position, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->goto_position (obj, position, err);
}

/* Default implementation */
static void
ianjuta_editor_goto_position_default (IAnjutaEditor *obj, gint position, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_insert:
 * @obj: Self
 * @position: Character position in editor where insert will take place.
 * @text: Text to append.
 * @length: Length of @text to use.
 * @err: Error propagation and reporting
 *
 * Inserts @length characters from @text buffer at given @position of
 * editor buffer. If @length is -1, the whole @text is used.
 */
void
ianjuta_editor_insert (IAnjutaEditor *obj, int position,   const gchar *text,   gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->insert (obj, position, text, length, err);
}

/* Default implementation */
static void
ianjuta_editor_insert_default (IAnjutaEditor *obj, int position,   const gchar *text,   gint length, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_set_auto_indent:
 * @obj: Self
 * @auto_indent: TRUE to enable auto-indent, FALSE to disable
 *
 * Sets whether the editor should auto-indent itself. A plugin that does
 * custom auto-indent can set this to false and override the preferences
 * setting
 */
void
ianjuta_editor_set_auto_indent (IAnjutaEditor *obj, gboolean auto_indent, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->set_auto_indent (obj, auto_indent, err);
}

/* Default implementation */
static void
ianjuta_editor_set_auto_indent_default (IAnjutaEditor *obj, gboolean auto_indent, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_set_popup_menu:
 * @obj: Self
 * @menu: Popupmenu
 * @err: Error propagation and reporting
 *
 * Set Editor popup menu. This is the menu shown in the editor when one
 * right-clicks on it.
 *
 */
void
ianjuta_editor_set_popup_menu (IAnjutaEditor *obj, GtkWidget *menu, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	g_return_if_fail (GTK_IS_WIDGET(menu));
	IANJUTA_EDITOR_GET_IFACE (obj)->set_popup_menu (obj, menu, err);
}

/* Default implementation */
static void
ianjuta_editor_set_popup_menu_default (IAnjutaEditor *obj, GtkWidget *menu, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_set_tabsize:
 * @obj: Self
 * @tabsize: Tabsize in spaces
 * @err: Error propagation and reporting
 *
 * Sets the tabsize of the editor.
 */
void
ianjuta_editor_set_tabsize (IAnjutaEditor *obj, gint tabsize, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->set_tabsize (obj, tabsize, err);
}

/* Default implementation */
static void
ianjuta_editor_set_tabsize_default (IAnjutaEditor *obj, gint tabsize, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_set_use_space:
 * @obj: Self
 * @use_spaces: TRUE to use spaces, FALSE to use tab char directly.
 * @err: Error propagation and reporting
 *
 * Sets if the editor should use spaces for filling up tab characters.
 */
void
ianjuta_editor_set_use_spaces (IAnjutaEditor *obj, gboolean use_spaces, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->set_use_spaces (obj, use_spaces, err);
}

/* Default implementation */
static void
ianjuta_editor_set_use_spaces_default (IAnjutaEditor *obj, gboolean use_spaces, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_base_init (IAnjutaEditorIface* klass)
{
	static gboolean initialized = FALSE;

	klass->append = ianjuta_editor_append_default;
	klass->erase = ianjuta_editor_erase_default;
	klass->erase_all = ianjuta_editor_erase_all_default;
	klass->get_cell_iter = ianjuta_editor_get_cell_iter_default;
	klass->get_column = ianjuta_editor_get_column_default;
	klass->get_current_word = ianjuta_editor_get_current_word_default;
	klass->get_length = ianjuta_editor_get_length_default;
	klass->get_line_begin_position = ianjuta_editor_get_line_begin_position_default;
	klass->get_line_end_position = ianjuta_editor_get_line_end_position_default;
	klass->get_line_from_position = ianjuta_editor_get_line_from_position_default;
	klass->get_lineno = ianjuta_editor_get_lineno_default;
	klass->get_overwrite = ianjuta_editor_get_overwrite_default;
	klass->get_position = ianjuta_editor_get_position_default;
	klass->get_position_iter = ianjuta_editor_get_position_iter_default;
	klass->get_tabsize = ianjuta_editor_get_tabsize_default;
	klass->get_text = ianjuta_editor_get_text_default;
	klass->get_text_iter = ianjuta_editor_get_text_iter_default;
	klass->get_use_spaces = ianjuta_editor_get_use_spaces_default;
	klass->goto_line = ianjuta_editor_goto_line_default;
	klass->goto_position = ianjuta_editor_goto_position_default;
	klass->insert = ianjuta_editor_insert_default;
	klass->set_auto_indent = ianjuta_editor_set_auto_indent_default;
	klass->set_popup_menu = ianjuta_editor_set_popup_menu_default;
	klass->set_tabsize = ianjuta_editor_set_tabsize_default;
	klass->set_use_spaces = ianjuta_editor_set_use_spaces_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("changed",
			IANJUTA_TYPE_EDITOR,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorIface, changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT_BOOLEAN_INT_INT_STRING,
			G_TYPE_NONE,
			5,
			G_TYPE_INT,
			G_TYPE_BOOLEAN,
			G_TYPE_INT,
			G_TYPE_INT,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("char-added",
			IANJUTA_TYPE_EDITOR,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorIface, char_added),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT_CHAR,
			G_TYPE_NONE,
			2,
			G_TYPE_INT,
			G_TYPE_CHAR);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorIface),
			(GBaseInitFunc) ianjuta_editor_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditor", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_editor_attribute_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_EDITOR_TEXT, "IANJUTA_EDITOR_TEXT", "text" }, 
		{ IANJUTA_EDITOR_KEYWORD, "IANJUTA_EDITOR_KEYWORD", "keyword" }, 
		{ IANJUTA_EDITOR_COMMENT, "IANJUTA_EDITOR_COMMENT", "comment" }, 
		{ IANJUTA_EDITOR_STRING, "IANJUTA_EDITOR_STRING", "string" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaEditorAttribute", values);
	}

	return type;
}

GType
ianjuta_editor_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_EDITOR_DOESNT_EXIST, "IANJUTA_EDITOR_DOESNT_EXIST", "doesnt-exist" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaEditorError", values);
	}

	return type;
}
