/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2006 Juan Pablo Ugarte.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Juan Pablo Ugarte <juanpablougarte@gmail.com>
 */

#include <config.h>

#include <Python.h>
#include <pygobject.h>

#include <gladeui/glade.h>
#include <gladeui/glade-binding.h>

static PyObject *gladeui, *gladeui_dict, *GladeuiError;

extern PyTypeObject PyGladeWidgetAdaptor_Type;

static GHashTable *registered_classes = NULL;

static PyTypeObject *
glade_python_register_class (GType type)
{
	GType parent = g_type_parent (type);
	PyTypeObject *klass, *parent_class;
	
	if (parent == 0 || type == GLADE_TYPE_WIDGET_ADAPTOR)
		return &PyGladeWidgetAdaptor_Type;
	
	if (g_hash_table_lookup (registered_classes, GUINT_TO_POINTER (parent)) == NULL)
		parent_class = glade_python_register_class (parent);
	else
		parent_class = pygobject_lookup_class (parent);
	
	klass = pygobject_lookup_class (type);
	
	pygobject_register_class (gladeui_dict, g_type_name (type), type, klass,
				  Py_BuildValue("(O)", parent_class));
	pyg_set_object_has_new_constructor (type);

	g_hash_table_insert (registered_classes, GUINT_TO_POINTER (type), klass);
	
	return klass;
}

static PyObject *
glade_python_get_adaptor_for_type (PyObject *self, PyObject *args)
{
	GladeWidgetAdaptor *adaptor;
	PyObject *klass;
	gchar *name;

	if (PyArg_ParseTuple(args, "s", &name) &&
	    (adaptor = glade_widget_adaptor_get_by_name (name)))
	{
		GType type = G_TYPE_FROM_INSTANCE (adaptor);

		if ((klass = g_hash_table_lookup (registered_classes, GUINT_TO_POINTER (type))))
			return (PyObject *) klass;
		else
			return (PyObject *) glade_python_register_class (type);
	}

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef GladeuiMethods[] = {
	{"get_adaptor_for_type",  glade_python_get_adaptor_for_type, METH_VARARGS, "Get the corresponding GladeWidgetAdaptor. Use this function to create your own derived Adaptor."},
	{NULL, NULL, 0, NULL}
};

/* Bindings */
void
glade_python_binding_finalize (GladeBindingCtrl *ctrl)
{
	Py_Finalize ();
}

void 
glade_python_binding_library_load (const gchar *library)
{
	gchar *str = g_strdup_printf ("import %s;", library);
	PyRun_SimpleString (str);
	g_free (str);
}

/*
  Generated by pygtk-codegen-2.0 
  pygtk-codegen-2.0 -p glade_python_gwa -o glade-python-gwa.override glade-python-gwa.defs > glade-python-gwa.c
*/
void glade_python_gwa_register_classes (PyObject *d);

static void
glade_python_init (void)
{
	char *argv[2] = {"", NULL};

	/* Init interpreter */
	Py_Initialize ();
	PySys_SetArgv (1, argv);
}

static void
glade_python_init_pygtk_check (gint req_major, gint req_minor, gint req_micro)
{
	PyObject *gobject, *mdict, *version;
	int found_major, found_minor, found_micro;
	
	init_pygobject();
	
	gobject = PyImport_ImportModule("gobject");
	mdict = PyModule_GetDict(gobject);
        version = PyDict_GetItemString(mdict, "pygtk_version");
	if (!version)
	{
		PyErr_SetString(PyExc_ImportError, "PyGObject version too old");
		return;
	}
	if (!PyArg_ParseTuple(version, "iii", &found_major, &found_minor, &found_micro))
		return;
	if (req_major != found_major || req_minor >  found_minor ||
	    (req_minor == found_minor && req_micro > found_micro))
	{
		PyErr_Format(PyExc_ImportError, 
                     "PyGObject version mismatch, %d.%d.%d is required, "
                     "found %d.%d.%d.", req_major, req_minor, req_micro,
                     found_major, found_minor, found_micro);
		return;
	}
}

gboolean
glade_binding_init (GladeBindingCtrl *ctrl)
{
	gchar *command;
	
    	Py_SetProgramName (PACKAGE_NAME);
	
	/* Initialize the Python interpreter */
	glade_python_init ();
	
	/* Check and init pygobject >= 2.12.0 */
	PyErr_Clear ();	
	glade_python_init_pygtk_check (PYGTK_REQUIRED_MAJOR, PYGTK_REQUIRED_MINOR, PYGTK_REQUIRED_MICRO);
	if (PyErr_Occurred ())
	{
		PyObject *ptype, *pvalue, *ptraceback;
		PyErr_Fetch(&ptype, &pvalue, &ptraceback);
		g_warning ("Unable to load pygobject module >= %d.%d.%d, "
			   "please make sure it is in python's path (sys.path). "
			   "(use PYTHONPATH env variable to specify non default paths)\n%s",
			   PYGTK_REQUIRED_MAJOR, PYGTK_REQUIRED_MINOR, PYGTK_REQUIRED_MICRO,
			   PyString_AsString (pvalue));
		PyErr_Clear ();
		Py_Finalize ();
		return FALSE;
	}
	
	pyg_disable_warning_redirections ();
	
	/* Create glade object */
	gladeui = Py_InitModule ("glade", GladeuiMethods);
	GladeuiError = PyErr_NewException ("glade.error", NULL, NULL);
	Py_INCREF (GladeuiError);
	PyModule_AddObject (gladeui, "error", GladeuiError);

	/* Register GladeUI classes (GladeWidgetAdaptor) */
	gladeui_dict = PyModule_GetDict (gladeui);
	glade_python_gwa_register_classes (gladeui_dict);
	
	/* Create registered_classes hash table */
	registered_classes = g_hash_table_new (g_direct_hash, g_direct_equal);

	/* Insert GladeWidgetAdaptor class in the hash table */
	g_hash_table_insert (registered_classes,
			     GUINT_TO_POINTER (GLADE_TYPE_WIDGET_ADAPTOR),
			     &PyGladeWidgetAdaptor_Type);

	/* Import glade module and set path */
	command = g_strdup_printf ("import sys; import glade; sys.path+=['.', '%s'];\n",
				    glade_app_get_modules_dir ());
	PyRun_SimpleString (command);
	g_free (command);
	
	/* Setup ctrl members */
	ctrl->name = "python";
	ctrl->finalize = glade_python_binding_finalize;
	ctrl->library_load = glade_python_binding_library_load;
	
	return TRUE;
}
