/* sercomm.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _SERCOMM_H
#define _SERCOMM_H

typedef short (*BRL_SER_CALLBACK) (int Byte);

/* Internal */
void brl_ser_sig_alarm ( int sig );
int brl_ser_read_data (char *DataBuff, int MaxLen);

/* API */

int brl_ser_open_port (int Port);
int handy_set_comm_param(); /* for HandyTech devices */
int brl_ser_set_comm_param (long BaudRate, char Parity, short StopBits, char FlowCtrl);
int brl_ser_close_port ();

int brl_ser_start_timer (long Interval);
int brl_ser_stop_timer ();

int brl_ser_init_glib_poll ();
int brl_ser_exit_glib_poll ();

	
int brl_ser_send_data (char* Data, int DataSize, short Blocking);
void brl_ser_set_callback (BRL_SER_CALLBACK Callback);

#endif
