from ContainerTarget import ContainerTarget
from utils.datatypes import *

import gtk



#
# Class for aligning targets.
#
class TargetAlignment(ContainerTarget):

    def __init__(self, parent, display):

        self.__alignment = (0.0, 0.0)

        
        ContainerTarget.__init__(self, parent, display)
        self.__align = gtk.Alignment(0.5, 1, 0, 0)
        self.__align.show()
        self.add(self.__align)

        self._set_property_type("align-x", TYPE_FLOAT)
        self._set_property_type("align-y", TYPE_FLOAT)



    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.__align.add(self._get_child())
        self._init_children()



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "align-x"):
            ax, ay = self.__alignment
            self.__align.set(value, ay, 0, 0)
            self.__alignment = (value, ay)
                
        elif (key == "align-y"):
            ax, ay = self.__alignment
            self.__align.set(ax, value, 0, 0)
            self.__alignment = (ax, value)

        else:
            ContainerTarget.set_config(self, key, value)



    def get_target_at(self, px, py, path):

        x, y, w, h = self.get_geometry()
        cx, cy, cw, ch = self._get_child().get_geometry()
        ax, ay = self.__alignment
        offx = int((w - cw) * ax)
        offy = int((h - ch) * ay)

        ctargets = self._get_child().get_target_at(px - x - offx,
                                                   py - y - offy,
                                                   path)
        ret = [(self, path)] + ctargets

        return ret
