
/* GnomeMeeting -- A Video-Conferencing application
 * Copyright (C) 2000-2003 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * GnomeMeting is licensed under the GPL license and as a special exception,
 * you have permission to link or otherwise combine this program with the
 * programs OpenH323 and Pwlib, and distribute the combination, without
 * applying the requirements of the GNU GPL to the OpenH323 program, as long
 * as you do follow the requirements of the GNU GPL for all the rest of the
 * software thus combined.
 */


/*
 *                         chat_window.cpp  -  description
 *                         -------------------------------
 *   begin                : Wed Jan 23 2002
 *   copyright            : (C) 2000-2003 by Damien Sandras
 *   description          : This file contains functions to build the chat
 *                          window. It uses DTMF tones.
 *   Additional code      : Kenneth Christiansen  <kenneth@gnu.org>
 *
 */


#include "../config.h"

#include "chat_window.h"
#include "gnomemeeting.h"
#include "misc.h"
#include "menu.h"

#include "gtk-text-buffer-extentions.h"
#include "gtk_menu_extensions.h"

extern GtkWidget *gm;


static void chat_entry_activate (GtkEditable *w, gpointer data)
{
  GMH323EndPoint *endpoint = GnomeMeeting::Process ()->Endpoint ();
  PString s;
    
  if (endpoint) {
        
    PString local = endpoint->GetLocalUserName ();
    /* The local party name has to be converted to UTF-8, but not
       the text */
    gchar *utf8_local = NULL;

    s = PString (gtk_entry_get_text (GTK_ENTRY (w)));
    
    if (endpoint->GetCallingState () == GMH323EndPoint::Connected
	&& !s.IsEmpty ()) {
            
      /* If the GDK lock is taken, the connection will never get a
	 chance to be established if we lock its mutex */
      gdk_threads_leave ();
      H323Connection *connection = 
	endpoint->FindConnectionWithLock (endpoint->GetCurrentCallToken ());
      gdk_threads_enter ();

      if (connection != NULL)  {
                
	connection->SendUserInput ("MSG"+s);

	if (g_utf8_validate ((gchar *) (const unsigned char*) local, -1, NULL))
	  utf8_local = g_strdup ((char *) (const char *) (local));
	else
	  utf8_local = gnomemeeting_from_iso88591_to_utf8 (local);

	if (utf8_local)
	  gnomemeeting_text_chat_insert (utf8_local, s, 0);
	g_free (utf8_local);
                
	gtk_entry_set_text (GTK_ENTRY (w), "");

	connection->Unlock ();
      }
    }
  }
}


void gnomemeeting_text_chat_clear (GtkWidget *w, GmTextChat *chat)
{
  GmWindow *gw = NULL;
  GtkTextIter start_iter, end_iter;

  gw = GnomeMeeting::Process ()->GetMainWindow ();
  
  gtk_text_buffer_get_start_iter (chat->text_buffer, &start_iter);
  gtk_text_buffer_get_end_iter (chat->text_buffer, &end_iter);

  gtk_text_buffer_delete (chat->text_buffer, &start_iter, &end_iter);
  chat->buffer_is_empty = TRUE;

  gtk_menu_set_sensitive (gw->main_menu, "clear_text_chat", FALSE);
}


void 
gnomemeeting_text_chat_insert (PString local, PString str, int user)
{
  gchar *msg = NULL;
  GtkTextIter iter;
  GtkTextMark *mark;
  
  GmTextChat *chat = NULL;
  GmWindow *gw = NULL;

  gw = GnomeMeeting::Process ()->GetMainWindow ();
  chat = GnomeMeeting::Process ()->GetTextChat ();

  gtk_text_buffer_get_end_iter (chat->text_buffer, &iter);

  if (chat->buffer_is_empty)
  {
    msg = g_strdup_printf ("%s: ", (const char *) local);
    chat->buffer_is_empty = FALSE;
  }
  else
    msg = g_strdup_printf ("\n%s: ", (const char *) local);

  if (user == 1)
    gtk_text_buffer_insert_with_tags_by_name (chat->text_buffer, &iter, msg, 
					      -1, "primary-user", NULL);
  else
    gtk_text_buffer_insert_with_tags_by_name (chat->text_buffer, &iter, msg, 
					      -1, "secondary-user", NULL);
  
  g_free (msg);
  
  gtk_text_buffer_insert_with_addons (chat->text_buffer, &iter, 
					 (const char *) str);

  mark = gtk_text_buffer_get_mark (chat->text_buffer, "current-position");

  gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (chat->text_view), mark, 
				0.0, FALSE, 0,0);

  gtk_menu_set_sensitive (gw->main_menu, "clear_text_chat", TRUE);
}


GtkWidget *gnomemeeting_text_chat_new (GmTextChat *chat)
{
  GtkWidget *entry = NULL;
  GtkWidget *scr = NULL;
  GtkWidget *label = NULL;
  GtkWidget *table = NULL;
  GtkWidget *frame = NULL;
  GtkWidget *hbox = NULL;
  GtkWidget *chat_window = NULL;

  GtkTextIter  iter;
  GtkTextMark *mark = NULL;

  /* Get the structs from the application */
  chat_window = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (chat_window), GTK_SHADOW_NONE);
  table = gtk_table_new (1, 3, FALSE);
  
  gtk_container_set_border_width (GTK_CONTAINER (table), 0);
  gtk_container_add (GTK_CONTAINER (chat_window), table);

  scr = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scr),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_ALWAYS);

  chat->text_view = gtk_text_view_new ();
  gtk_text_view_set_editable (GTK_TEXT_VIEW (chat->text_view), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (chat->text_view),
			       GTK_WRAP_WORD);

  chat->text_buffer = 
    gtk_text_view_get_buffer (GTK_TEXT_VIEW (chat->text_view));

  gtk_text_buffer_get_end_iter (chat->text_buffer, &iter);
  gtk_text_view_set_cursor_visible  (GTK_TEXT_VIEW (chat->text_view), false);

  mark = gtk_text_buffer_create_mark (chat->text_buffer, 
				      "current-position", &iter, FALSE);

  gtk_text_buffer_create_tag (chat->text_buffer, "primary-user",
			      "foreground", "red", 
			      "weight", 900, NULL);

  gtk_text_buffer_create_tag (chat->text_buffer, "secondary-user",
			      "foreground", "#38b749", 
			      "weight", 900, NULL);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_container_add (GTK_CONTAINER (scr), chat->text_view);
  gtk_container_add (GTK_CONTAINER (frame), scr);
  
  gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (frame), 
		    0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    0, 0);

  label = gtk_label_new (_("Send Message:"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (label), 
		    0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL),
		    0, 0);

  entry = gtk_entry_new ();
  hbox = gtk_hbox_new (FALSE, 0);

  gtk_widget_set_size_request (GTK_WIDGET (entry), 245, -1);
  gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);

  gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (hbox), 
		    0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL),
		    0, 0);

  g_signal_connect (GTK_OBJECT (entry), "activate",
		    G_CALLBACK (chat_entry_activate), chat->text_view);

  chat->buffer_is_empty = TRUE;

  return chat_window;
}
