import polling
import glibtop

import time


class Network:

    def __init__(self):

        self.__time = 0
        self.__in = 0
        self.__out = 0


        self.__get_in_out = polling.wrap(self.__poll_in_out, 0.5)
        self.get_devices = polling.wrap(self.__poll_devices, 5)
        self.get_ipaddr = polling.wrap(self.__poll_ipaddr, 60)



    def get_bytes_in_out(self, dev): return self.__get_in_out(dev)[0:2]
    def get_pack_in_out(self, dev): return self.__get_in_out(dev)[2:4]
    def get_speed_in_out(self, dev): return self.__get_in_out(dev)[4:6]



    def __poll_devices(self):

        fd = open("/proc/net/dev", "r")
        data = fd.readlines()
        fd.close()

        devices = []
        for lines in data[2:]:
            l = lines.strip()
            l = l.replace(":", " ")
            fields = l.split()

            if (fields[0] == "lo"):
                continue
            else:
                device = fields[0]
                devices.append(device)

        return devices



    def __poll_ipaddr(self, dev):

        flags, mtu, subnet, address, pack_in, pack_out, pack_total, \
               bytes_in, bytes_out, bytes_total, err_in, err_out, err_total, \
               collisions = glibtop.get_netload(dev)

        a = address % 0x100; address /= 0x100
        b = address % 0x100; address /= 0x100
        c = address % 0x100; address /= 0x100
        d = address

        return str(a) + "." + str(b) + "." + str(c) + "." + str(d)




    def __poll_in_out(self, dev):

        t = time.time()
        interval = t - self.__time
        self.__time = t
        speed_in = 0
        speed_out = 0

        flags, mtu, subnet, address, pack_in, pack_out, pack_total, \
               bytes_in, bytes_out, bytes_total, err_in, err_out, err_total, \
               collisions = glibtop.get_netload(dev)

        if ((self.__in == 0) and (self.__out == 0)):
            self.__in, self.__out = bytes_in, bytes_out
        else:
            in_diff  = bytes_in  - self.__in
            out_diff = bytes_out - self.__out
            speed_in = int(in_diff / interval)
            speed_out = int(out_diff / interval)

            self.__in, self.__out = bytes_in, bytes_out
        
        return (bytes_in, bytes_out, pack_in, pack_out, speed_in, speed_out)
