import polling
import glibtop


#
# TODO: support SMP
#
class CPU:

    def __init__(self):

        # for remembering previous values
        self.__tT = 0.0
        self.__uT = 0.0
        self.__sT = 0.0
        self.__nT = 0.0
        self.__iT = 0.0


        self.__get_cpu = polling.wrap(self.__poll_cpu, 10)
        self.get_speed = polling.wrap(self.__poll_speed, 10)
        self.get_model = polling.wrap(self.__poll_model, 0)
        self.get_cache_size = polling.wrap(self.__poll_cache, 0)

        self.get_load = polling.wrap(self.__poll_load, 0.2)




    def __poll_model(self): return self.__get_cpu()[0]
    def __poll_speed(self): return self.__get_cpu()[1]
    def __poll_cache(self): return self.__get_cpu()[2]



    def __poll_cpu(self):

        import libdesklets as lib

        fd = open("/proc/cpuinfo", "r")
        lines = fd.readlines()
        fd.close()

        arch = lib.sys.get_arch()
        if (arch in ["i386", "i486", "i586", "i686"]):
            fields = lines[4].split()
            model_name = " ".join(fields[3:])
            fields = lines[6].split()
            cpu_mhz = fields[3]
            fields = lines[7].split()
            cpu_cache = " ".join(fields[3:5])

        elif (arch == "ppc"):
            fields = lines[0].split()
            model_name = fields[2]
            fields = lines[2].split()
            cpu_mhz = fields[2]
            fields = lines[10].split()
            cpu_cache = fields[3]

        else:
            # TODO: alpha, m68k, mips, ppc64, sparc
            pass

        return (model_name, cpu_mhz, cpu_cache)



    def __poll_load(self):

        total, user, nice, sys, idle, freq = glibtop.get_cpu()[:6]
        totaldiff = total - self.__tT
        load = int(freq * ((user + sys + nice) -
                           (self.__uT + self.__sT + self.__nT)) /
                   (totaldiff + 0.001) + 0.5)

        if (load > 100):
            load = 100

        self.__tT = total
        self.__uT = user
        self.__sT = sys
        self.__nT = nice
        self.__iT = idle

        return (total, load)
