// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_APPLICATION_H
#define _GTKMM_APPLICATION_H

#include <gtkmmconfig.h>


#include <glibmm.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <vector>

#include <giomm/application.h>
#include <gtkmm/actiongroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkApplication GtkApplication;
typedef struct _GtkApplicationClass GtkApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Application_Class; } // namespace Gtk
namespace Gtk
{

class Window;

/** TODO
 */

class Application
  : public Gio::Application
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GtkApplication BaseObjectType;
  typedef GtkApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GtkApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkApplication*       gobj()       { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkApplication* gobj() const { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkApplication* gobj_copy();

private:


protected:

  /** Creates a new Application instance.
   * This constructor calls g_type_init() for you.
   * You should call run() with your main() function's argc and argv parameters
   * to initialize gtkmm too.
   *
   * @param application_id A valid application id
   * @param flags The application flags
   */
  explicit Application(const Glib::ustring& application_id, Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);
  

  //This constructor does not correspond to anything in the C API.
  //We added it so we can choose to always initialize gtkmm as early as possible.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925
  /** Creates a new Application instance.
   * This constructor initializes gtkmm for you, so you should call run() 
   * without specifying the the argc and argv parameters again. 
   * 
   * @param argc The parameter received by your main() function.
   * @param argv The parameter received by your main() function.
   * @param application_id A valid application id
   * @param flags The application flags
   */
  explicit Application(int argc, char** argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);
  
public:

 
  static Glib::RefPtr<Application> create(const Glib::ustring& application_id, Gio::ApplicationFlags flags =  Gio::APPLICATION_FLAGS_NONE);

  
  static Glib::RefPtr<Application> create(int argc, char** argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags =  Gio::APPLICATION_FLAGS_NONE);


  /** Gets a list of the Gtk::Window<!-- -->s associated with @a application.
   * 
   * The list is sorted by most recently focused window, such that the first
   * element is the currently focused window.  (Useful for choosing a parent
   * for a transient window.)
   * 
   * The list that is returned should not be modified in any way. It will
   * only remain valid until the next focus change or window creation or
   * deletion.
   * 
   * @newin{3,0}
   * @return A List of Gtk::Window.
   */
  std::vector<Window*> get_windows();

 
  /** Gets a list of the Gtk::Window<!-- -->s associated with @a application.
   * 
   * The list is sorted by most recently focused window, such that the first
   * element is the currently focused window.  (Useful for choosing a parent
   * for a transient window.)
   * 
   * The list that is returned should not be modified in any way. It will
   * only remain valid until the next focus change or window creation or
   * deletion.
   * 
   * @newin{3,0}
   * @return A List of Gtk::Window.
   */
  std::vector<const Window*> get_windows() const;

  /** Adds a window to the Gtk::Application.
   * 
   * If all the windows managed by Gtk::Application are closed, the
   * Gtk::Application will call quit(), and quit
   * the application.
   * 
   * If your application uses only a single toplevel window, you can
   * use get_window(). If you are using a sub-class
   * of Gtk::Application you should call create_window()
   * to let the Gtk::Application instance create a Gtk::Window and add
   * it to the list of toplevels of the application. You should call
   * this function only to add Gtk::Window<!-- -->s that you created
   * directly using new Gtk::Window.
   * 
   * @newin{3,0}
   * @param window A toplevel window to add to the application.
   */
  void add_window(Window& window);
  

  /** Remove a window from @a application.
   * 
   * If @a window belongs to @a application then this call is equivalent to
   * setting the Gtk::Window:application property of @a window to
   * <tt>0</tt>.
   * 
   * The application may stop running as a result of a call to this
   * function.
   * 
   * @newin{3,0}
   * @param window A Gtk::Window.
   */
  void remove_window(Window& window);

  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{3,0}
   */
  int run(int argc, char** argv);
  
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @param window The window to show. This method will return when the window is hidden.
   * 
   * @newin{3,0}
   */
  int run(Window& window, int argc, char** argv);

  //TODO: If argc and argv are necessary at all, document the need to call that constructor first.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925#c4
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @param window The window to show. This method will return when the window is hidden.
   * 
   * @newin{3,0}
   */
  int run(Window& window);

  //TODO: If argc and argv are necessary at all, document the need to call that constructor first.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925#c4
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{3,0}
   */
  int run();
  
private:
  /** This is just a way to call Glib::init() (which calls g_type_init()) before
   * calling application_class_.init(), so that 
   * gtk_application_get_type() will always succeed.
   * See https://bugzilla.gnome.org/show_bug.cgi?id=639925
   */
  const Glib::Class& custom_class_init();
  
  void on_activate_showwindow();
  void on_window_hide(Window*);
  
  ///We show the window in the activate signal handler.
  Window* m_main_window;
  
  //We need these to call g_application_run(), 
  //even if we have already called gtk_init().
  int m_argc;
  char** m_argv;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Application
   */
  Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy = false);
}


#endif /* _GTKMM_APPLICATION_H */

