/* eds-backend.c generated by valac 0.13.4, the Vala compiler
 * generated from eds-backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libedataserver/e-account.h>
#include <libedataserver/e-source.h>
#include <gio/gio.h>
#include <libebook/e-book-client.h>
#include <folks/folks-eds.h>


#define FOLKS_BACKENDS_EDS_TYPE_BACKEND (folks_backends_eds_backend_get_type ())
#define FOLKS_BACKENDS_EDS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend))
#define FOLKS_BACKENDS_EDS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))
#define FOLKS_BACKENDS_EDS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))

typedef struct _FolksBackendsEdsBackend FolksBackendsEdsBackend;
typedef struct _FolksBackendsEdsBackendClass FolksBackendsEdsBackendClass;
typedef struct _FolksBackendsEdsBackendPrivate FolksBackendsEdsBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsEdsBackendPrepareData FolksBackendsEdsBackendPrepareData;
typedef struct _FolksBackendsEdsBackendUnprepareData FolksBackendsEdsBackendUnprepareData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FolksBackendsEdsBackend {
	FolksBackend parent_instance;
	FolksBackendsEdsBackendPrivate * priv;
};

struct _FolksBackendsEdsBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsEdsBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	ESourceList* _ab_sources;
};

struct _FolksBackendsEdsBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ESourceList* _tmp2_;
	ESourceList* _tmp3_;
	ESourceList* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_;
};

struct _FolksBackendsEdsBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeHashMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _persona_store_it;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	FolksPersonaStore* persona_store;
	FolksPersonaStore* _tmp12_;
	ESourceList* _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_;
	GError * _inner_error_;
};


static gpointer folks_backends_eds_backend_parent_class = NULL;

GType folks_backends_eds_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendPrivate))
enum  {
	FOLKS_BACKENDS_EDS_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_EDS_BACKEND_NAME,
	FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT
};
#define FOLKS_BACKENDS_EDS_BACKEND__use_address_books "FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS"
FolksBackendsEdsBackend* folks_backends_eds_backend_new (void);
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type);
static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_);
static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self);
static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self, ESourceList* list);
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed (ESourceList* _sender, gpointer self);
static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_);
static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store);
static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s);
static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store);
static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_eds_backend_finalize (GObject* obj);
static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * {@inheritDoc}
   */
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type) {
	FolksBackendsEdsBackend * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	self = (FolksBackendsEdsBackend*) folks_backend_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return self;
}


FolksBackendsEdsBackend* folks_backends_eds_backend_new (void) {
	return folks_backends_eds_backend_construct (FOLKS_BACKENDS_EDS_TYPE_BACKEND);
}


static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsEdsBackendPrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendPrepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsEdsBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_eds_backend_real_prepare_co (_data_);
}


static void folks_backends_eds_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed (ESourceList* _sender, gpointer self) {
	_folks_backends_eds_backend_ab_source_list_changed_cb (self, _sender);
}


static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp1_) {
				_folks_backends_eds_backend_create_avatars_cache_dir (_data_->self);
				_data_->_tmp2_ = NULL;
				e_book_client_get_sources (&_data_->_tmp2_, &_data_->_inner_error_);
				_g_object_unref0 (_data_->self->priv->_ab_sources);
				_data_->self->priv->_ab_sources = _data_->_tmp2_;
				if (_data_->_inner_error_ != NULL) {
					goto __finally0;
				}
				_data_->_tmp3_ = _data_->self->priv->_ab_sources;
				g_signal_connect_object (_data_->_tmp3_, "changed", (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed, _data_->self, 0);
				_data_->_tmp4_ = _data_->self->priv->_ab_sources;
				_folks_backends_eds_backend_ab_source_list_changed_cb (_data_->self, _data_->_tmp4_);
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
				_data_->self->priv->_is_quiescent = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
			}
		}
		__finally0:
		{
			_data_->_tmp5_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsEdsBackendUnprepareData, _data_);
}


static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendUnprepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsEdsBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_eds_backend_real_unprepare_co (_data_);
}


static void folks_backends_eds_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
			if (_data_->_tmp1_) {
				{
					_data_->_tmp2_ = _data_->self->priv->_persona_stores;
					_data_->_tmp3_ = gee_map_get_values ((GeeMap*) _data_->_tmp2_);
					_data_->_tmp4_ = _data_->_tmp3_;
					_data_->_tmp5_ = _data_->_tmp4_;
					_data_->_tmp6_ = NULL;
					_data_->_tmp6_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp5_);
					_data_->_tmp7_ = _data_->_tmp6_;
					_g_object_unref0 (_data_->_tmp5_);
					_data_->_persona_store_it = _data_->_tmp7_;
					while (TRUE) {
						_data_->_tmp8_ = _data_->_persona_store_it;
						_data_->_tmp9_ = FALSE;
						_data_->_tmp9_ = gee_iterator_next (_data_->_tmp8_);
						if (!_data_->_tmp9_) {
							break;
						}
						_data_->_tmp10_ = _data_->_persona_store_it;
						_data_->_tmp11_ = NULL;
						_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
						_data_->persona_store = (FolksPersonaStore*) _data_->_tmp11_;
						_data_->_tmp12_ = _data_->persona_store;
						_folks_backends_eds_backend_remove_address_book (_data_->self, _data_->_tmp12_);
						_g_object_unref0 (_data_->persona_store);
					}
					_g_object_unref0 (_data_->_persona_store_it);
				}
				_data_->_tmp13_ = _data_->self->priv->_ab_sources;
				_data_->_tmp14_ = 0U;
				g_signal_parse_name ("changed", e_source_list_get_type (), &_data_->_tmp14_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_data_->_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp14_, 0, NULL, (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed, _data_->self);
				_g_object_unref0 (_data_->self->priv->_ab_sources);
				_data_->self->priv->_ab_sources = NULL;
				_data_->self->priv->_is_quiescent = FALSE;
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
				_data_->self->priv->_is_prepared = FALSE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
			}
		}
		__finally1:
		{
			_data_->_tmp15_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* avatars_dir;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "folks", "avatars", NULL);
	avatars_dir = _tmp1_;
	g_mkdir_with_parents (avatars_dir, 0700);
	_g_free0 (avatars_dir);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self, ESourceList* list) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** use_addressbooks;
	gint use_addressbooks_length1;
	gint _use_addressbooks_size_;
	ESourceList* _tmp2_;
	GSList* _tmp3_ = NULL;
	GSList* groups;
	GeeHashMap* _tmp4_;
	GeeHashMap* new_sources;
	GSList* _tmp5_;
	GeeLinkedList* _tmp19_;
	GeeLinkedList* removed_sources;
	GeeLinkedList* _tmp35_;
	GeeLinkedList* added_sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list != NULL);
	_tmp1_ = _folks_backends_eds_backend_get_addressbooks_from_env (self, &_tmp0_);
	use_addressbooks = _tmp1_;
	use_addressbooks_length1 = _tmp0_;
	_use_addressbooks_size_ = use_addressbooks_length1;
	_tmp2_ = self->priv->_ab_sources;
	_tmp3_ = e_source_list_peek_groups (_tmp2_);
	groups = _tmp3_;
	g_debug ("eds-backend.vala:159: Address book source list changed.");
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, e_source_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	new_sources = _tmp4_;
	_tmp5_ = groups;
	{
		GSList* g_collection = NULL;
		GSList* g_it = NULL;
		g_collection = _tmp5_;
		for (g_it = g_collection; g_it != NULL; g_it = g_it->next) {
			ESourceGroup* g = NULL;
			g = (ESourceGroup*) g_it->data;
			{
				ESourceGroup* _tmp6_;
				GSList* _tmp7_ = NULL;
				_tmp6_ = g;
				_tmp7_ = e_source_group_peek_sources (_tmp6_);
				{
					GSList* s_collection = NULL;
					GSList* s_it = NULL;
					s_collection = _tmp7_;
					for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
						ESource* _tmp8_;
						ESource* s = NULL;
						_tmp8_ = _g_object_ref0 ((ESource*) s_it->data);
						s = _tmp8_;
						{
							gboolean _tmp9_ = FALSE;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gboolean _tmp14_;
							GeeHashMap* _tmp15_;
							ESource* _tmp16_;
							const gchar* _tmp17_ = NULL;
							ESource* _tmp18_;
							_tmp10_ = use_addressbooks;
							_tmp10__length1 = use_addressbooks_length1;
							if (_tmp10__length1 > 0) {
								ESource* _tmp11_;
								const gchar* _tmp12_ = NULL;
								gchar** _tmp13_;
								gint _tmp13__length1;
								_tmp11_ = s;
								_tmp12_ = e_source_peek_name (_tmp11_);
								_tmp13_ = use_addressbooks;
								_tmp13__length1 = use_addressbooks_length1;
								_tmp9_ = !_vala_string_array_contains (_tmp13_, _tmp13__length1, _tmp12_);
							} else {
								_tmp9_ = FALSE;
							}
							_tmp14_ = _tmp9_;
							if (_tmp14_) {
								_g_object_unref0 (s);
								continue;
							}
							_tmp15_ = new_sources;
							_tmp16_ = s;
							_tmp17_ = e_source_peek_relative_uri (_tmp16_);
							_tmp18_ = s;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp18_);
							_g_object_unref0 (s);
						}
					}
				}
			}
		}
	}
	_tmp19_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	removed_sources = _tmp19_;
	{
		GeeHashMap* _tmp20_;
		GeeSet* _tmp21_;
		GeeSet* _tmp22_;
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _tmp25_;
		GeeIterator* _source_uri_it;
		_tmp20_ = self->priv->_persona_stores;
		_tmp21_ = gee_map_get_keys ((GeeMap*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_source_uri_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			gboolean _tmp27_ = FALSE;
			GeeIterator* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* source_uri;
			GeeHashMap* _tmp30_;
			const gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			_tmp26_ = _source_uri_it;
			_tmp27_ = gee_iterator_next (_tmp26_);
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _source_uri_it;
			_tmp29_ = gee_iterator_get (_tmp28_);
			source_uri = (gchar*) _tmp29_;
			_tmp30_ = new_sources;
			_tmp31_ = source_uri;
			_tmp32_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp30_, _tmp31_);
			if (!_tmp32_) {
				GeeLinkedList* _tmp33_;
				const gchar* _tmp34_;
				_tmp33_ = removed_sources;
				_tmp34_ = source_uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
			}
			_g_free0 (source_uri);
		}
		_g_object_unref0 (_source_uri_it);
	}
	_tmp35_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	added_sources = _tmp35_;
	{
		GeeHashMap* _tmp36_;
		GeeSet* _tmp37_;
		GeeSet* _tmp38_;
		GeeSet* _tmp39_;
		GeeIterator* _tmp40_ = NULL;
		GeeIterator* _tmp41_;
		GeeIterator* _source_uri_it;
		_tmp36_ = new_sources;
		_tmp37_ = gee_map_get_keys ((GeeMap*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_iterable_iterator ((GeeIterable*) _tmp39_);
		_tmp41_ = _tmp40_;
		_g_object_unref0 (_tmp39_);
		_source_uri_it = _tmp41_;
		while (TRUE) {
			GeeIterator* _tmp42_;
			gboolean _tmp43_ = FALSE;
			GeeIterator* _tmp44_;
			gpointer _tmp45_ = NULL;
			gchar* source_uri;
			GeeHashMap* _tmp46_;
			const gchar* _tmp47_;
			gboolean _tmp48_ = FALSE;
			_tmp42_ = _source_uri_it;
			_tmp43_ = gee_iterator_next (_tmp42_);
			if (!_tmp43_) {
				break;
			}
			_tmp44_ = _source_uri_it;
			_tmp45_ = gee_iterator_get (_tmp44_);
			source_uri = (gchar*) _tmp45_;
			_tmp46_ = self->priv->_persona_stores;
			_tmp47_ = source_uri;
			_tmp48_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp46_, _tmp47_);
			if (!_tmp48_) {
				GeeLinkedList* _tmp49_;
				const gchar* _tmp50_;
				_tmp49_ = added_sources;
				_tmp50_ = source_uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
			}
			_g_free0 (source_uri);
		}
		_g_object_unref0 (_source_uri_it);
	}
	{
		GeeLinkedList* _tmp51_;
		GeeLinkedList* _tmp52_;
		GeeLinkedList* _source_uri_list;
		GeeLinkedList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _source_uri_size;
		gint _source_uri_index;
		_tmp51_ = removed_sources;
		_tmp52_ = _g_object_ref0 (_tmp51_);
		_source_uri_list = _tmp52_;
		_tmp53_ = _source_uri_list;
		_tmp54_ = gee_collection_get_size ((GeeCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_source_uri_size = _tmp55_;
		_source_uri_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			GeeLinkedList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_ = NULL;
			gchar* source_uri;
			GeeHashMap* _tmp62_;
			const gchar* _tmp63_;
			gpointer _tmp64_ = NULL;
			FolksPersonaStore* _tmp65_;
			_tmp56_ = _source_uri_index;
			_source_uri_index = _tmp56_ + 1;
			_tmp57_ = _source_uri_index;
			_tmp58_ = _source_uri_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _source_uri_list;
			_tmp60_ = _source_uri_index;
			_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp59_, _tmp60_);
			source_uri = (gchar*) _tmp61_;
			_tmp62_ = self->priv->_persona_stores;
			_tmp63_ = source_uri;
			_tmp64_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp62_, _tmp63_);
			_tmp65_ = (FolksPersonaStore*) _tmp64_;
			_folks_backends_eds_backend_remove_address_book (self, _tmp65_);
			_g_object_unref0 (_tmp65_);
			_g_free0 (source_uri);
		}
		_g_object_unref0 (_source_uri_list);
	}
	{
		GeeLinkedList* _tmp66_;
		GeeLinkedList* _tmp67_;
		GeeLinkedList* _source_uri_list;
		GeeLinkedList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _source_uri_size;
		gint _source_uri_index;
		_tmp66_ = added_sources;
		_tmp67_ = _g_object_ref0 (_tmp66_);
		_source_uri_list = _tmp67_;
		_tmp68_ = _source_uri_list;
		_tmp69_ = gee_collection_get_size ((GeeCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_source_uri_size = _tmp70_;
		_source_uri_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			GeeLinkedList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_ = NULL;
			gchar* source_uri;
			GeeHashMap* _tmp77_;
			const gchar* _tmp78_;
			gpointer _tmp79_ = NULL;
			ESource* _tmp80_;
			_tmp71_ = _source_uri_index;
			_source_uri_index = _tmp71_ + 1;
			_tmp72_ = _source_uri_index;
			_tmp73_ = _source_uri_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _source_uri_list;
			_tmp75_ = _source_uri_index;
			_tmp76_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, _tmp75_);
			source_uri = (gchar*) _tmp76_;
			_tmp77_ = new_sources;
			_tmp78_ = source_uri;
			_tmp79_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp77_, _tmp78_);
			_tmp80_ = (ESource*) _tmp79_;
			_folks_backends_eds_backend_add_address_book (self, _tmp80_);
			_g_object_unref0 (_tmp80_);
			_g_free0 (source_uri);
		}
		_g_object_unref0 (_source_uri_list);
	}
	_g_object_unref0 (added_sources);
	_g_object_unref0 (removed_sources);
	_g_object_unref0 (new_sources);
	use_addressbooks = (_vala_array_free (use_addressbooks, use_addressbooks_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Add a new addressbook connected to a Persona Store.
   */
static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_eds_backend_store_removed_cb (self, _sender);
}


static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s) {
	ESource* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* relative_uri;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	ESource* _tmp7_;
	EdsfPersonaStore* _tmp8_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp9_;
	GeeHashMap* _tmp10_;
	EdsfPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	EdsfPersonaStore* _tmp14_;
	EdsfPersonaStore* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = e_source_peek_relative_uri (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	relative_uri = _tmp2_;
	_tmp3_ = self->priv->_persona_stores;
	_tmp4_ = relative_uri;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
	if (_tmp5_) {
		_g_free0 (relative_uri);
		return;
	}
	_tmp6_ = relative_uri;
	g_debug ("eds-backend.vala:227: Adding address book '%s'.", _tmp6_);
	_tmp7_ = s;
	_tmp8_ = edsf_persona_store_new (_tmp7_);
	store = _tmp8_;
	_tmp9_ = store;
	g_signal_connect_object ((FolksPersonaStore*) _tmp9_, "removed", (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp10_ = self->priv->_persona_stores;
	_tmp11_ = store;
	_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp13_, (FolksPersonaStore*) _tmp14_);
	g_object_notify ((GObject*) self, "persona-stores");
	_tmp15_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp15_);
	_g_object_unref0 (store);
	_g_free0 (relative_uri);
}


static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersonaStore* _tmp3_;
	GeeHashMap* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FolksPersonaStore* _tmp8_;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("eds-backend.vala:241: Removing address book '%s'.", _tmp2_);
	_tmp3_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp3_);
	_tmp4_ = self->priv->_persona_stores;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp7_, NULL);
	g_object_notify ((GObject*) self, "persona-stores");
	_tmp8_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self);
}


static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_eds_backend_remove_address_book (self, _tmp0_);
}


static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** addressbooks;
	gint addressbooks_length1;
	gint _addressbooks_size_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* ab_list;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	addressbooks = _tmp0_;
	addressbooks_length1 = 0;
	_addressbooks_size_ = addressbooks_length1;
	_tmp1_ = g_getenv (FOLKS_BACKENDS_EDS_BACKEND__use_address_books);
	_tmp2_ = g_strdup (_tmp1_);
	ab_list = _tmp2_;
	_tmp4_ = ab_list;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = ab_list;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp7_ = ab_list;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 0);
		addressbooks = (_vala_array_free (addressbooks, addressbooks_length1, (GDestroyNotify) g_free), NULL);
		addressbooks = _tmp9_;
		addressbooks_length1 = _vala_array_length (_tmp8_);
		_addressbooks_size_ = addressbooks_length1;
	}
	_tmp10_ = addressbooks;
	_tmp10__length1 = addressbooks_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_free0 (ab_list);
	return result;
}


static const gchar* folks_backends_eds_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsEdsBackend* self;
	self = (FolksBackendsEdsBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_eds_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsEdsBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_eds_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_eds_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static void folks_backends_eds_backend_class_init (FolksBackendsEdsBackendClass * klass) {
	folks_backends_eds_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsEdsBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_eds_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_eds_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_eds_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_eds_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_eds_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_eds_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_eds_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_eds_backend_real_get_is_quiescent;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_eds_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_eds_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED, "is-prepared");
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT, "is-quiescent");
}


static void folks_backends_eds_backend_instance_init (FolksBackendsEdsBackend * self) {
	self->priv = FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_eds_backend_finalize (GObject* obj) {
	FolksBackendsEdsBackend * self;
	self = FOLKS_BACKENDS_EDS_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	_g_object_unref0 (self->priv->_ab_sources);
	G_OBJECT_CLASS (folks_backends_eds_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to EDS and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_eds_backend_get_type (void) {
	static volatile gsize folks_backends_eds_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_eds_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsEdsBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_eds_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsEdsBackend), 0, (GInstanceInitFunc) folks_backends_eds_backend_instance_init, NULL };
		GType folks_backends_eds_backend_type_id;
		folks_backends_eds_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsEdsBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_eds_backend_type_id__volatile, folks_backends_eds_backend_type_id);
	}
	return folks_backends_eds_backend_type_id__volatile;
}


static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsEdsBackend * self;
	self = FOLKS_BACKENDS_EDS_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_EDS_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



