/* dconf-update.c generated by valac 0.11.2.22-6303f, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <gvdb-builder.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GHashTable* read_directory (const gchar* dirname, GError** error);
void maybe_update_from_directory (const gchar* dirname, GError** error);
void update_all (const gchar* dirname, GError** error);
void do_update (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent;
	gint end;
	gchar* _tmp3_ = NULL;
	gchar* parent_name;
	gconstpointer _tmp4_ = NULL;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	parent = NULL;
	end = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar _tmp1_;
				gchar _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = string_get (name, (glong) i);
				if (!(_tmp1_ != '\0')) {
					break;
				}
				_tmp2_ = string_get (name, (glong) (i - 1));
				if (_tmp2_ == '/') {
					end = i;
				}
			}
		}
	}
	_tmp3_ = g_strndup (name, (gsize) end);
	parent_name = _tmp3_;
	_tmp4_ = g_hash_table_lookup (table, parent_name);
	parent = (GvdbItem*) _tmp4_;
	if (parent == NULL) {
		GvdbItem* _tmp5_ = NULL;
		GvdbItem* _tmp6_ = NULL;
		_tmp5_ = gvdb_hash_table_insert (table, parent_name);
		parent = _tmp5_;
		_tmp6_ = get_parent (table, parent_name);
		gvdb_item_set_parent (parent, _tmp6_);
	}
	result = parent;
	_g_free0 (parent_name);
	return result;
}


GHashTable* read_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* table;
	const gchar* name;
	GDir* _tmp1_ = NULL;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	name = NULL;
	gvdb_hash_table_insert (table, "/");
	_tmp1_ = g_dir_open (dirname, (guint) 0, &_inner_error_);
	dir = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	while (TRUE) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* filename;
		GKeyFile* _tmp4_ = NULL;
		GKeyFile* kf;
		gsize _tmp5_;
		gchar** _tmp6_ = NULL;
		_tmp2_ = g_dir_read_name (dir);
		name = _tmp2_;
		if (!(name != NULL)) {
			break;
		}
		_tmp3_ = g_build_filename (dirname, name, NULL);
		filename = _tmp3_;
		_tmp4_ = g_key_file_new ();
		kf = _tmp4_;
		g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "%s: %s\n", filename, e->message);
			_g_error_free0 (e);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			continue;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			_g_hash_table_unref0 (table);
			return NULL;
		}
		_tmp6_ = g_key_file_get_groups (kf, &_tmp5_);
		{
			gchar** group_collection;
			int group_collection_length1;
			int group_it;
			group_collection = _tmp6_;
			group_collection_length1 = _tmp5_;
			for (group_it = 0; group_it < _tmp5_; group_it = group_it + 1) {
				gchar* _tmp7_;
				gchar* group;
				_tmp7_ = g_strdup (group_collection[group_it]);
				group = _tmp7_;
				{
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_;
					gsize _tmp13_;
					gchar** _tmp14_ = NULL;
					gint _tmp15__length1;
					gint __tmp15__size_;
					gchar** _tmp16_;
					gchar** _tmp15_;
					_tmp10_ = g_str_has_prefix (group, "/");
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gboolean _tmp11_;
						_tmp11_ = g_str_has_suffix (group, "/");
						_tmp9_ = _tmp11_;
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = strstr (group, "//");
						_tmp8_ = _tmp12_ != NULL;
					}
					if (_tmp8_) {
						fprintf (stderr, "%s: ignoring invalid group name: %s\n", filename, group);
						_g_free0 (group);
						continue;
					}
					_tmp14_ = g_key_file_get_keys (kf, group, &_tmp13_, &_inner_error_);
					_tmp16_ = _tmp14_;
					_tmp15__length1 = _tmp13_;
					__tmp15__size_ = _tmp15__length1;
					_tmp15_ = _tmp16_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (kf);
						_g_free0 (filename);
						_g_dir_close0 (dir);
						_g_hash_table_unref0 (table);
						return NULL;
					}
					{
						gchar** key_collection;
						int key_collection_length1;
						int key_it;
						key_collection = _tmp15_;
						key_collection_length1 = _tmp15__length1;
						for (key_it = 0; key_it < _tmp15__length1; key_it = key_it + 1) {
							gchar* _tmp17_;
							gchar* key;
							_tmp17_ = g_strdup (key_collection[key_it]);
							key = _tmp17_;
							{
								const gchar* _tmp18_ = NULL;
								gchar* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								gchar* path;
								gconstpointer _tmp22_ = NULL;
								gchar* _tmp23_ = NULL;
								gchar* text;
								GVariant* _tmp24_ = NULL;
								GVariant* value;
								GvdbItem* _tmp25_ = NULL;
								GvdbItem* item;
								GvdbItem* _tmp26_ = NULL;
								_tmp18_ = strstr (key, "/");
								if (_tmp18_ != NULL) {
									fprintf (stderr, "%s: [%s]: ignoring invalid key name: %s\n", filename, group, key);
									_g_free0 (key);
									continue;
								}
								_tmp19_ = g_strconcat ("/", group, NULL);
								_tmp20_ = g_strconcat (_tmp19_, "/", NULL);
								path = (_tmp21_ = g_strconcat (_tmp20_, key, NULL), _g_free0 (_tmp20_), _g_free0 (_tmp19_), _tmp21_);
								_tmp22_ = g_hash_table_lookup (table, path);
								if (((GvdbItem*) _tmp22_) != NULL) {
									fprintf (stderr, "%s: [%s]: %s: ignoring duplicate definition of key %s\n", filename, group, key, path);
									_g_free0 (path);
									_g_free0 (key);
									continue;
								}
								_tmp23_ = g_key_file_get_value (kf, group, key, &_inner_error_);
								text = _tmp23_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_tmp24_ = g_variant_parse (NULL, text, NULL, NULL, &_inner_error_);
								value = _tmp24_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
										goto __catch2_g_variant_parse_error;
									}
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp25_ = gvdb_hash_table_insert (table, path);
								item = _tmp25_;
								_tmp26_ = get_parent (table, path);
								gvdb_item_set_parent (item, _tmp26_);
								gvdb_item_set_value (item, value);
								_g_variant_unref0 (value);
								goto __finally2;
								__catch2_g_variant_parse_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									fprintf (stderr, "%s: [%s]: %s: skipping invalid value: %s (%s)\n", filename, group, key, text, e->message);
									_g_error_free0 (e);
								}
								__finally2:
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_g_free0 (text);
								_g_free0 (path);
								_g_free0 (key);
							}
						}
						key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_key_file_free0 (kf);
		_g_free0 (filename);
	}
	result = table;
	_g_dir_close0 (dir);
	return result;
}


void maybe_update_from_directory (const gchar* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	struct stat _tmp1_ = {0};
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp2_ = stat (dirname, &_tmp1_);
	dir_buf = _tmp1_;
	if (_tmp2_ == 0) {
		gboolean _tmp3_;
		_tmp3_ = S_ISDIR (dir_buf.st_mode);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		struct stat file_buf = {0};
		glong _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* filename;
		gboolean _tmp6_ = FALSE;
		struct stat _tmp7_ = {0};
		gint _tmp8_;
		GHashTable* _tmp9_ = NULL;
		GHashTable* table;
		gint _tmp10_;
		gint fd;
		gboolean _tmp11_ = FALSE;
		GDBusConnection* _tmp14_ = NULL;
		GDBusConnection* system_bus;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GVariantBuilder* _tmp18_ = NULL;
		GVariantBuilder* _tmp19_;
		GVariant* _tmp20_ = NULL;
		GVariant* _tmp21_;
		_tmp4_ = strlen (dirname);
		_tmp5_ = g_strndup (dirname, (gsize) (_tmp4_ - 2));
		filename = _tmp5_;
		_tmp8_ = stat (filename, &_tmp7_);
		file_buf = _tmp7_;
		if (_tmp8_ == 0) {
			_tmp6_ = file_buf.st_mtime > dir_buf.st_mtime;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_g_free0 (filename);
			return;
		}
		_tmp9_ = read_directory (dirname, &_inner_error_);
		table = _tmp9_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		_tmp10_ = open (filename, O_WRONLY, (mode_t) 0);
		fd = _tmp10_;
		if (fd < 0) {
			_tmp11_ = errno != ENOENT;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint saved_error;
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			saved_error = errno;
			_tmp12_ = g_strerror (saved_error);
			_tmp13_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Can not open '%s' for replacement: %s", filename, _tmp12_);
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		gvdb_table_write_contents (table, filename, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __finally3;
		}
		if (fd >= 0) {
			write (fd, "\0\0\0\0\0\0\0\0", (gsize) 8);
		}
		__finally3:
		if (fd >= 0) {
			close (fd);
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_tmp14_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
		system_bus = _tmp14_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp15_ = g_path_get_basename (filename);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat ("/", _tmp16_, NULL);
		_tmp18_ = g_variant_builder_new (G_VARIANT_TYPE_STRING_ARRAY);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_variant_new ("(tsas)", (guint64) 0, "/", _tmp19_, NULL);
		_tmp21_ = g_variant_ref_sink (_tmp20_);
		g_dbus_connection_emit_signal (system_bus, NULL, _tmp17_, "ca.desrt.dconf.Writer", "Notify", _tmp21_, &_inner_error_);
		_g_variant_unref0 (_tmp21_);
		_g_variant_builder_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp16_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (system_bus);
			goto __catch4_g_error;
		}
		g_dbus_connection_flush_sync (system_bus, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (system_bus);
			goto __catch4_g_error;
		}
		_g_object_unref0 (system_bus);
		goto __finally4;
		__catch4_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname, GError** error) {
	const gchar* name;
	GDir* _tmp0_ = NULL;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	name = NULL;
	_tmp0_ = g_dir_open (dirname, (guint) 0, &_inner_error_);
	dir = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = g_dir_read_name (dir);
		name = _tmp1_;
		if (!(name != NULL)) {
			break;
		}
		_tmp2_ = g_str_has_suffix (name, ".d");
		if (_tmp2_) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = g_build_filename (dirname, name, NULL);
			_tmp4_ = _tmp3_;
			maybe_update_from_directory (_tmp4_, &_inner_error_);
			_g_free0 (_tmp4_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				fprintf (stderr, "%s\n", e->message);
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_dir_close0 (dir);
				return;
			}
		}
	}
	_g_dir_close0 (dir);
}


void do_update (void) {
	GError * _inner_error_ = NULL;
	update_all ("/etc/dconf/db", &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "fatal: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



