/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventKey_get_type (GdkEventKey * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_type (obj_g));
}

GdkWindow * GdkEventKey_get_window (GdkEventKey * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventKey_getWindow (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventKey_get_window (obj_g));
}

gboolean GdkEventKey_get_send_event (GdkEventKey * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventKey_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventKey_get_send_event (obj_g));
}

time_t GdkEventKey_get_time (GdkEventKey * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint)GdkEventKey_get_time (obj_g);
}

guint32 GdkEventKey_get_state (GdkEventKey * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getState (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_state (obj_g));
}

guint32 GdkEventKey_get_keyval (GdkEventKey * cptr) 
{
    return cptr->keyval;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getKeyval
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getKeyval (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_keyval (obj_g));
}

gint32 GdkEventKey_get_length (GdkEventKey * cptr) 
{
    return cptr->length;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getLength
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getLength (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_length (obj_g));
}

gchar * GdkEventKey_get_string (GdkEventKey * cptr) 
{
    return cptr->string;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getString
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_EventKey_getString (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    gchar *result_g = GdkEventKey_get_string ((GdkEventKey*)getPointerFromHandle(env, obj));
    if (result_g) 
    	return (*env)->NewStringUTF(env, result_g);
    else
    	return (*env)->NewStringUTF(env, "");
}

gint32 GdkEventKey_get_hardware_keycode (GdkEventKey * cptr) 
{
    return cptr->hardware_keycode;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getHardwareKeycode
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getHardwareKeycode (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_hardware_keycode (obj_g));
}

gint32 GdkEventKey_get_group (GdkEventKey * cptr) 
{
    return cptr->group;
}

/*
 * Class:     org.gnu.gdk.EventKey
 * Method:    getGroup
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventKey_getGroup (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventKey *obj_g = (GdkEventKey *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventKey_get_group (obj_g));
}


#ifdef __cplusplus
}

#endif
