/* mini-graph.c generated by valac 0.14.0, the Vala compiler
 * generated from mini-graph.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define BOXES_TYPE_MINI_GRAPH (boxes_mini_graph_get_type ())
#define BOXES_MINI_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MINI_GRAPH, BoxesMiniGraph))
#define BOXES_MINI_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MINI_GRAPH, BoxesMiniGraphClass))
#define BOXES_IS_MINI_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MINI_GRAPH))
#define BOXES_IS_MINI_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MINI_GRAPH))
#define BOXES_MINI_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MINI_GRAPH, BoxesMiniGraphClass))

typedef struct _BoxesMiniGraph BoxesMiniGraph;
typedef struct _BoxesMiniGraphClass BoxesMiniGraphClass;
typedef struct _BoxesMiniGraphPrivate BoxesMiniGraphPrivate;

struct _BoxesMiniGraph {
	GtkDrawingArea parent_instance;
	BoxesMiniGraphPrivate * priv;
};

struct _BoxesMiniGraphClass {
	GtkDrawingAreaClass parent_class;
};

struct _BoxesMiniGraphPrivate {
	gdouble* _points;
	gint _points_length1;
	gint __points_size_;
	gint _npoints;
	gdouble _ymax;
	gboolean ymax_set;
};


static gpointer boxes_mini_graph_parent_class = NULL;

GType boxes_mini_graph_get_type (void) G_GNUC_CONST;
#define BOXES_MINI_GRAPH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_MINI_GRAPH, BoxesMiniGraphPrivate))
enum  {
	BOXES_MINI_GRAPH_DUMMY_PROPERTY,
	BOXES_MINI_GRAPH_NPOINTS
};
BoxesMiniGraph* boxes_mini_graph_new (gdouble* points, int points_length1, gint npoints);
BoxesMiniGraph* boxes_mini_graph_construct (GType object_type, gdouble* points, int points_length1, gint npoints);
void boxes_mini_graph_set_points (BoxesMiniGraph* self, gdouble* value, int value_length1);
void boxes_mini_graph_set_npoints (BoxesMiniGraph* self, gint value);
BoxesMiniGraph* boxes_mini_graph_new_with_ymax (gdouble* points, int points_length1, gdouble ymax, gint npoints);
BoxesMiniGraph* boxes_mini_graph_construct_with_ymax (GType object_type, gdouble* points, int points_length1, gdouble ymax, gint npoints);
static void boxes_mini_graph_set_ymax (BoxesMiniGraph* self, gdouble value);
static gdouble boxes_mini_graph_max (BoxesMiniGraph* self);
gdouble* boxes_mini_graph_get_points (BoxesMiniGraph* self, int* result_length1);
static gboolean boxes_mini_graph_real_draw (GtkWidget* base, cairo_t* cr);
void boxes_get_boxes_bg_color (GdkRGBA* result);
gint boxes_mini_graph_get_npoints (BoxesMiniGraph* self);
static gdouble boxes_mini_graph_get_ymax (BoxesMiniGraph* self);
static gdouble* _vala_array_dup3 (gdouble* self, int length);
static void boxes_mini_graph_finalize (GObject* obj);
static void _vala_boxes_mini_graph_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_mini_graph_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


BoxesMiniGraph* boxes_mini_graph_construct (GType object_type, gdouble* points, int points_length1, gint npoints) {
	BoxesMiniGraph * self = NULL;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	self = (BoxesMiniGraph*) g_object_new (object_type, NULL);
	_tmp0_ = points;
	_tmp0__length1 = points_length1;
	boxes_mini_graph_set_points (self, _tmp0_, _tmp0__length1);
	_tmp1_ = npoints;
	boxes_mini_graph_set_npoints (self, _tmp1_);
	return self;
}


BoxesMiniGraph* boxes_mini_graph_new (gdouble* points, int points_length1, gint npoints) {
	return boxes_mini_graph_construct (BOXES_TYPE_MINI_GRAPH, points, points_length1, npoints);
}


BoxesMiniGraph* boxes_mini_graph_construct_with_ymax (GType object_type, gdouble* points, int points_length1, gdouble ymax, gint npoints) {
	BoxesMiniGraph * self = NULL;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble _tmp1_;
	gint _tmp2_;
	self = (BoxesMiniGraph*) g_object_new (object_type, NULL);
	_tmp0_ = points;
	_tmp0__length1 = points_length1;
	boxes_mini_graph_set_points (self, _tmp0_, _tmp0__length1);
	_tmp1_ = ymax;
	boxes_mini_graph_set_ymax (self, _tmp1_);
	_tmp2_ = npoints;
	boxes_mini_graph_set_npoints (self, _tmp2_);
	return self;
}


BoxesMiniGraph* boxes_mini_graph_new_with_ymax (gdouble* points, int points_length1, gdouble ymax, gint npoints) {
	return boxes_mini_graph_construct_with_ymax (BOXES_TYPE_MINI_GRAPH, points, points_length1, ymax, npoints);
}


static gdouble boxes_mini_graph_max (BoxesMiniGraph* self) {
	gdouble result = 0.0;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	gdouble _tmp4_;
	gdouble max;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = boxes_mini_graph_get_points (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (_tmp1__length1 == 0) {
		result = 1.0;
		return result;
	}
	_tmp2_ = boxes_mini_graph_get_points (self, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = _tmp3_[0];
	max = _tmp4_;
	_tmp5_ = boxes_mini_graph_get_points (self, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	{
		gdouble* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp6_;
		p_collection_length1 = _tmp6__length1;
		for (p_it = 0; p_it < _tmp6__length1; p_it = p_it + 1) {
			gdouble p = 0.0;
			p = p_collection[p_it];
			{
				gdouble _tmp7_;
				gdouble _tmp8_;
				_tmp7_ = p;
				_tmp8_ = max;
				if (_tmp7_ > _tmp8_) {
					gdouble _tmp9_;
					_tmp9_ = p;
					max = _tmp9_;
				}
			}
		}
	}
	result = max;
	return result;
}


static gboolean boxes_mini_graph_real_draw (GtkWidget* base, cairo_t* cr) {
	BoxesMiniGraph * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint width;
	gint _tmp1_ = 0;
	gint height;
	cairo_t* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	cairo_t* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	GtkStyle* _tmp9_ = NULL;
	GdkColor* _tmp10_;
	gint _tmp10__length1;
	GtkStateType _tmp11_ = 0;
	GdkColor _tmp12_;
	cairo_t* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	gint _tmp19_;
	gint nstep;
	gdouble _tmp20_ = 0.0;
	gboolean _tmp21_;
	gdouble _tmp25_;
	gdouble ymax;
	gint _tmp26_;
	gint _tmp27_;
	gdouble dx;
	gint _tmp28_;
	gdouble _tmp29_;
	gdouble dy;
	gdouble x;
	gdouble* _tmp30_;
	gint _tmp30__length1;
	gdouble* _tmp31_;
	gint _tmp31__length1;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	GtkStyle* _tmp46_ = NULL;
	GdkColor* _tmp47_;
	gint _tmp47__length1;
	GtkStateType _tmp48_ = 0;
	GdkColor _tmp49_;
	gdouble* _tmp50_;
	gint _tmp50__length1;
	gdouble* _tmp51_;
	gint _tmp51__length1;
	cairo_t* _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	gint _tmp67_;
	cairo_t* _tmp68_;
	gint _tmp69_;
	cairo_t* _tmp70_;
	self = (BoxesMiniGraph*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp1_;
	_tmp2_ = cr;
	boxes_get_boxes_bg_color (&_tmp3_);
	gdk_cairo_set_source_rgba (_tmp2_, &_tmp3_);
	_tmp4_ = cr;
	_tmp5_ = width;
	_tmp6_ = height;
	cairo_rectangle (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp6_);
	_tmp7_ = cr;
	cairo_fill (_tmp7_);
	_tmp8_ = cr;
	_tmp9_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp10_ = _tmp9_->fg;
	_tmp10__length1 = -1;
	_tmp11_ = gtk_widget_get_state ((GtkWidget*) self);
	_tmp12_ = _tmp10_[_tmp11_];
	gdk_cairo_set_source_color (_tmp8_, &_tmp12_);
	_tmp13_ = cr;
	cairo_set_line_width (_tmp13_, 1.5);
	_tmp15_ = self->priv->_npoints;
	if (_tmp15_ == (-1)) {
		gdouble* _tmp16_;
		gint _tmp16__length1;
		gdouble* _tmp17_;
		gint _tmp17__length1;
		_tmp16_ = boxes_mini_graph_get_points (self, &_tmp16__length1);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp16__length1;
		_tmp14_ = _tmp17__length1;
	} else {
		gint _tmp18_;
		_tmp18_ = self->priv->_npoints;
		_tmp14_ = _tmp18_;
	}
	_tmp19_ = _tmp14_;
	nstep = _tmp19_ - 1;
	_tmp21_ = self->priv->ymax_set;
	if (_tmp21_) {
		gdouble _tmp22_;
		gdouble _tmp23_;
		_tmp22_ = boxes_mini_graph_get_ymax (self);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_;
	} else {
		gdouble _tmp24_ = 0.0;
		_tmp24_ = boxes_mini_graph_max (self);
		_tmp20_ = _tmp24_;
	}
	_tmp25_ = _tmp20_;
	ymax = _tmp25_;
	_tmp26_ = width;
	_tmp27_ = nstep;
	dx = ((gdouble) _tmp26_) / _tmp27_;
	_tmp28_ = height;
	_tmp29_ = ymax;
	dy = ((gdouble) _tmp28_) / _tmp29_;
	x = 0.0;
	_tmp30_ = boxes_mini_graph_get_points (self, &_tmp30__length1);
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _tmp30__length1;
	{
		gdouble* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp31_;
		p_collection_length1 = _tmp31__length1;
		for (p_it = 0; p_it < _tmp31__length1; p_it = p_it + 1) {
			gdouble p = 0.0;
			p = p_collection[p_it];
			{
				gint _tmp32_;
				gdouble _tmp33_;
				gdouble _tmp34_;
				gdouble y;
				gdouble _tmp35_;
				gdouble _tmp42_;
				gdouble _tmp43_;
				_tmp32_ = height;
				_tmp33_ = p;
				_tmp34_ = dy;
				y = _tmp32_ - (_tmp33_ * _tmp34_);
				_tmp35_ = x;
				if (_tmp35_ == 0.0) {
					cairo_t* _tmp36_;
					gdouble _tmp37_;
					gdouble _tmp38_;
					_tmp36_ = cr;
					_tmp37_ = x;
					_tmp38_ = y;
					cairo_move_to (_tmp36_, _tmp37_, _tmp38_);
				} else {
					cairo_t* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					_tmp39_ = cr;
					_tmp40_ = x;
					_tmp41_ = y;
					cairo_line_to (_tmp39_, _tmp40_, _tmp41_);
				}
				_tmp42_ = x;
				_tmp43_ = dx;
				x = _tmp42_ + _tmp43_;
			}
		}
	}
	_tmp44_ = cr;
	cairo_stroke (_tmp44_);
	_tmp45_ = cr;
	_tmp46_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp47_ = _tmp46_->light;
	_tmp47__length1 = -1;
	_tmp48_ = gtk_widget_get_state ((GtkWidget*) self);
	_tmp49_ = _tmp47_[_tmp48_];
	gdk_cairo_set_source_color (_tmp45_, &_tmp49_);
	x = 0.0;
	_tmp50_ = boxes_mini_graph_get_points (self, &_tmp50__length1);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = _tmp50__length1;
	{
		gdouble* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp51_;
		p_collection_length1 = _tmp51__length1;
		for (p_it = 0; p_it < _tmp51__length1; p_it = p_it + 1) {
			gdouble p = 0.0;
			p = p_collection[p_it];
			{
				gint _tmp52_;
				gdouble _tmp53_;
				gdouble _tmp54_;
				gdouble y;
				gdouble _tmp55_;
				gdouble _tmp62_;
				gdouble _tmp63_;
				_tmp52_ = height;
				_tmp53_ = p;
				_tmp54_ = dy;
				y = _tmp52_ - (_tmp53_ * _tmp54_);
				_tmp55_ = x;
				if (_tmp55_ == 0.0) {
					cairo_t* _tmp56_;
					gdouble _tmp57_;
					gdouble _tmp58_;
					_tmp56_ = cr;
					_tmp57_ = x;
					_tmp58_ = y;
					cairo_move_to (_tmp56_, _tmp57_, _tmp58_);
				} else {
					cairo_t* _tmp59_;
					gdouble _tmp60_;
					gdouble _tmp61_;
					_tmp59_ = cr;
					_tmp60_ = x;
					_tmp61_ = y;
					cairo_line_to (_tmp59_, _tmp60_, _tmp61_);
				}
				_tmp62_ = x;
				_tmp63_ = dx;
				x = _tmp62_ + _tmp63_;
			}
		}
	}
	_tmp64_ = cr;
	_tmp65_ = x;
	_tmp66_ = dx;
	_tmp67_ = height;
	cairo_line_to (_tmp64_, _tmp65_ - _tmp66_, (gdouble) _tmp67_);
	_tmp68_ = cr;
	_tmp69_ = height;
	cairo_line_to (_tmp68_, (gdouble) 0, (gdouble) _tmp69_);
	_tmp70_ = cr;
	cairo_fill (_tmp70_);
	result = TRUE;
	return result;
}


gdouble* boxes_mini_graph_get_points (BoxesMiniGraph* self, int* result_length1) {
	gdouble* result;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_points;
	_tmp0__length1 = self->priv->_points_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gdouble* _vala_array_dup3 (gdouble* self, int length) {
	return g_memdup (self, length * sizeof (gdouble));
}


void boxes_mini_graph_set_points (BoxesMiniGraph* self, gdouble* value, int value_length1) {
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_points = (g_free (self->priv->_points), NULL);
	self->priv->_points = _tmp1_;
	self->priv->_points_length1 = _tmp1__length1;
	self->priv->__points_size_ = self->priv->_points_length1;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


gint boxes_mini_graph_get_npoints (BoxesMiniGraph* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_npoints;
	result = _tmp0_;
	return result;
}


void boxes_mini_graph_set_npoints (BoxesMiniGraph* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_npoints = _tmp0_;
	g_object_notify ((GObject *) self, "npoints");
}


static gdouble boxes_mini_graph_get_ymax (BoxesMiniGraph* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_ymax;
	result = _tmp0_;
	return result;
}


static void boxes_mini_graph_set_ymax (BoxesMiniGraph* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ymax = _tmp0_;
	self->priv->ymax_set = TRUE;
}


static void boxes_mini_graph_class_init (BoxesMiniGraphClass * klass) {
	boxes_mini_graph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesMiniGraphPrivate));
	GTK_WIDGET_CLASS (klass)->draw = boxes_mini_graph_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_mini_graph_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_mini_graph_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_mini_graph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MINI_GRAPH_NPOINTS, g_param_spec_int ("npoints", "npoints", "npoints", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void boxes_mini_graph_instance_init (BoxesMiniGraph * self) {
	self->priv = BOXES_MINI_GRAPH_GET_PRIVATE (self);
	self->priv->_npoints = -1;
	self->priv->ymax_set = FALSE;
}


static void boxes_mini_graph_finalize (GObject* obj) {
	BoxesMiniGraph * self;
	self = BOXES_MINI_GRAPH (obj);
	self->priv->_points = (g_free (self->priv->_points), NULL);
	G_OBJECT_CLASS (boxes_mini_graph_parent_class)->finalize (obj);
}


GType boxes_mini_graph_get_type (void) {
	static volatile gsize boxes_mini_graph_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_mini_graph_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesMiniGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_mini_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesMiniGraph), 0, (GInstanceInitFunc) boxes_mini_graph_instance_init, NULL };
		GType boxes_mini_graph_type_id;
		boxes_mini_graph_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "BoxesMiniGraph", &g_define_type_info, 0);
		g_once_init_leave (&boxes_mini_graph_type_id__volatile, boxes_mini_graph_type_id);
	}
	return boxes_mini_graph_type_id__volatile;
}


static void _vala_boxes_mini_graph_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesMiniGraph * self;
	self = BOXES_MINI_GRAPH (object);
	switch (property_id) {
		case BOXES_MINI_GRAPH_NPOINTS:
		g_value_set_int (value, boxes_mini_graph_get_npoints (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_boxes_mini_graph_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesMiniGraph * self;
	self = BOXES_MINI_GRAPH (object);
	switch (property_id) {
		case BOXES_MINI_GRAPH_NPOINTS:
		boxes_mini_graph_set_npoints (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



