/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.ILabelRefCounter;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.mindmap.filtering.FilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.Messages;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;

public class LabelFilterSection
extends FilterSection
implements ICoreEventListener {
    private ICoreEventRegister register;
    private ILabelRefCounter counter;
    private int sectionStyle = -1;

    public LabelFilterSection() {
        this.setTitle(Messages.LabelFilterSection_title);
    }

    public LabelFilterSection(int noItemPolicy) {
        super(noItemPolicy);
        this.setTitle(Messages.LabelFilterSection_title);
    }

    protected PropertyFilter findFilter(IGraphicalViewer viewer) {
        FilterService filterService = (FilterService)viewer.getService(FilterService.class);
        if (filterService != null) {
            return filterService.getLabelFilter();
        }
        return null;
    }

    protected Object[] getAllPropertyFilters(IGraphicalViewer viewer) {
        ILabelRefCounter counter = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            counter = (ILabelRefCounter)sheet.getAdapter(ILabelRefCounter.class);
        }
        this.setLabelRefCounter(counter);
        if (counter != null) {
            return counter.getCountedRefs().toArray();
        }
        return new Object[0];
    }

    private void setLabelRefCounter(ILabelRefCounter counter) {
        if (counter == this.counter) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.counter = counter;
        if (counter != null) {
            this.register = new CoreEventRegister((Object)counter, (ICoreEventListener)this);
            this.register.register("resourceRefs");
        }
    }

    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        super.handleDispose();
    }

    protected String getMessage() {
        return Messages.LabelFilterSection_message;
    }

    protected void createMessagePart(Composite parent, WidgetFactory factory, String message, boolean html) {
        super.createMessagePart(parent, factory, message, true);
    }

    public void handleCoreEvent(CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                LabelFilterSection.this.refresh();
            }
        });
    }

    protected int getSectionStyle() {
        if (this.sectionStyle > 0) {
            return this.sectionStyle;
        }
        return super.getSectionStyle();
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }
}

