/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tools;

import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.SimpleRectangleFigure;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tools.DummyMoveTool;

public class GalleryMoveTool
extends DummyMoveTool {
    public static final String PARAM_INSERT_TARGET = "insertTarget";
    public static final String PARAM_INSERT_POSITION = "insertPosition";
    private static final int DELTA = 5;
    private Layer layer;
    private SimpleRectangleFigure cover;
    private IFigure placeholder;
    private boolean horizontalLayout;
    private IPart relativePart;
    private boolean beforeOrAfter;
    private ResourceManager resources;

    @Override
    protected void start() {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), this.getTargetViewer().getControl());
        super.start();
        this.horizontalLayout = this.getTargetViewer().getProperties().getBoolean("org.xmind.ui.gallery.horizontalLayout", false);
        Layer contentCover = this.getContentCover();
        this.cover = new SimpleRectangleFigure(contentCover.getBounds().getShrinked(2, 2));
        this.cover.setBackgroundColor(ColorConstants.gray);
        this.cover.setSubAlpha(51);
        contentCover.add((IFigure)this.cover);
    }

    private Layer getContentCover() {
        FramePart framePart = this.getFramePart();
        FrameFigure frameFigure = framePart.getFigure();
        return frameFigure.getContentCover();
    }

    protected FramePart getFramePart() {
        return (FramePart)this.getSource();
    }

    @Override
    protected void end() {
        this.horizontalLayout = false;
        this.getContentCover().remove((IFigure)this.cover);
        this.cover = null;
        this.layer.remove(this.placeholder);
        this.placeholder = null;
        super.end();
    }

    private RectangleFigure createPlaceholder() {
        RectangleFigure placeholder = new RectangleFigure();
        placeholder.setFill(true);
        placeholder.setForegroundColor((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#a3a3a3")));
        placeholder.setBackgroundColor((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#a3a3a3")));
        placeholder.setLineWidth(4);
        return placeholder;
    }

    @Override
    protected IFigure createDummy() {
        IGraphicalViewer viewer = this.getTargetViewer();
        this.layer = viewer.getLayer(GEF.LAYER_PRESENTATION);
        if (this.layer != null) {
            FrameFigure dummyFrameFigure = new FrameFigure(){

                public void paint(Graphics graphics) {
                    graphics.setAlpha(76);
                    super.paint(graphics);
                }
            };
            this.decorate(dummyFrameFigure);
            dummyFrameFigure.setBounds(this.getFramePart().getFigure().getBounds());
            this.layer.add((IFigure)dummyFrameFigure);
            this.placeholder = this.createPlaceholder();
            this.layer.add(this.placeholder);
            return dummyFrameFigure;
        }
        return null;
    }

    private void decorate(FrameFigure dummyFrameFigure) {
        boolean useCustomDecorator;
        Object model = this.getFramePart().getModel();
        IGraphicalViewer viewer = this.getTargetViewer();
        Properties properties = viewer.getProperties();
        IBaseLabelProvider labelProvider = (IBaseLabelProvider)viewer.getAdapter(IBaseLabelProvider.class);
        boolean hideTitle = properties.getBoolean("org.xmind.ui.gallery.hideTitle", false);
        dummyFrameFigure.setHideTitle(hideTitle);
        boolean flat = properties.getBoolean("org.xmind.ui.gallery.flatFrames", false);
        dummyFrameFigure.setFlat(flat);
        dummyFrameFigure.setContentSize((Dimension)properties.get("org.xmind.ui.gallery.frameContentSize"));
        int titlePlacement = properties.getInteger("org.xmind.ui.gallery.titlePlacement", GalleryViewer.TITLE_TOP.intValue());
        dummyFrameFigure.setTitlePlacement(titlePlacement);
        if (!hideTitle) {
            this.decorateTitle(dummyFrameFigure.getTitle(), model, labelProvider);
        }
        if ((useCustomDecorator = properties.getBoolean("org.xmind.ui.gallery.customDecorateContentPane", false)) && labelProvider instanceof ILabelDecorator) {
            IDecorationContext context = viewer instanceof IDecorationContext ? (IDecorationContext)viewer : null;
            ((ILabelDecorator)labelProvider).decorateFigure((IFigure)dummyFrameFigure.getContentPane(), model, context);
        }
        ShadowedLayer layer = dummyFrameFigure.getContentPane();
        layer.setBorderWidth(properties.getInteger("org.xmind.ui.gallery.contentPaneBorderWidth", 1));
        Object color = properties.get("org.xmind.ui.gallery.contentPaneBorderColor");
        if (color != null && color instanceof Color) {
            layer.setBorderAlpha(255);
            layer.setBorderColor((Color)color);
        }
        layer.setLayoutManager(this.getFramePart().getFigure().getContentPane().getLayoutManager());
        Image image = this.getImage(model, labelProvider);
        SizeableImageFigure imageFigure = new SizeableImageFigure();
        this.decorateImage(imageFigure, image, properties);
        dummyFrameFigure.getContentPane().add((IFigure)imageFigure);
    }

    private Image getImage(Object element, IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getImage(element);
        }
        return null;
    }

    protected void decorateImage(SizeableImageFigure imageFigure, Image image, Properties properties) {
        imageFigure.setImage(image);
        boolean stretched = properties.getBoolean("stretched", false);
        boolean constained = properties.getBoolean("constrained", false);
        imageFigure.setConstrained(constained);
        imageFigure.setStretched(stretched);
        Insets margins = (Insets)properties.get("org.xmind.ui.gallery.contentPaneMargins");
        imageFigure.setMargins(margins);
    }

    private String getText(Object element, IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText(element);
        }
        return null;
    }

    protected void decorateTitle(ITextFigure titleFigure, Object model, IBaseLabelProvider labelProvider) {
        String text = this.getText(model, labelProvider);
        if (text == null) {
            text = "";
        }
        titleFigure.setText(text);
        if (labelProvider instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            titleFigure.setFont(fontProvider.getFont(model));
        }
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            titleFigure.setForegroundColor(colorProvider.getForeground(model));
            titleFigure.setBackgroundColor(colorProvider.getBackground(model));
        }
    }

    @Override
    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        IGraphicalViewer viewer = this.getTargetViewer();
        MouseEvent swtEvent = me.getCurrentSWTEvent();
        IPart framePart = viewer.findPart(swtEvent.x, swtEvent.y);
        if (framePart instanceof FramePart) {
            this.relativePart = framePart;
            FrameFigure frameFigure = ((FramePart)framePart).getFigure();
            Rectangle bounds = frameFigure.getBounds();
            int lineWidth = 2;
            if (this.horizontalLayout) {
                Rectangle leftRect = bounds.getResized(-bounds.width / 2, 0);
                if (leftRect.contains(currentPos)) {
                    this.placeholder.setBounds(new Rectangle(bounds.x - 1, bounds.y - 5, lineWidth, bounds.height + 10));
                    this.beforeOrAfter = true;
                } else {
                    this.placeholder.setBounds(new Rectangle(bounds.x + bounds.width + 2, bounds.y - 5, lineWidth, bounds.height + 10));
                    this.beforeOrAfter = false;
                }
            } else {
                Rectangle upRect = bounds.getResized(0, -bounds.height / 2);
                if (upRect.contains(currentPos)) {
                    this.placeholder.setBounds(new Rectangle(bounds.x - 5, bounds.y - 1, bounds.width + 10, lineWidth));
                    this.beforeOrAfter = true;
                } else {
                    this.placeholder.setBounds(new Rectangle(bounds.x - 5, bounds.y + bounds.height + 2, bounds.width + 10, lineWidth));
                    this.beforeOrAfter = false;
                }
            }
        }
    }

    @Override
    protected Request createRequest() {
        Request request = new Request("move to");
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (IPart p : this.getSelectedParts((IViewer)this.getTargetViewer())) {
            if (!p.hasRole("movable role")) continue;
            parts.add(p);
        }
        request.setTargets(parts);
        request.setPrimaryTarget((IPart)this.getSource());
        request.setParameter("position", (Object)this.getCursorPosition());
        request.setParameter("parent", (Object)this.getFramePart().getParent());
        request.setParameter(PARAM_INSERT_TARGET, (Object)this.relativePart);
        request.setParameter(PARAM_INSERT_POSITION, (Object)this.beforeOrAfter);
        return request;
    }
}

