/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.Request;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

public class SheetMultiBranchColorsStylePropertySectionPart
extends StyledPropertySectionPart {
    private static String[] names = new String[]{PropertyMessages.MultiLineColors_CommandTextName1, PropertyMessages.MultiLineColors_CommandTextName2, PropertyMessages.MultiLineColors_CommandTextName3, PropertyMessages.MultiLineColors_CommandTextName4, PropertyMessages.MultiLineColors_CommandTextName5, PropertyMessages.MultiLineColors_CommandTextName6};
    private static String[] commandTexts = new String[]{"#017c98 #00b2a1 #ffdd00 #fc8f00 #ff1500 #00b04c", "#009978 #e2e500 #009bb6 #99b800 #d10e00 #8c4400", "#488dfd #8d8a6b #7a6c6b #b0ad9b #7781d8 #fbc01e", "#e90e18 #f4bfa4 #ffb800 #ff6f00 #fd62b1 #ac0708", "#bbdefb #64b5f6 #2196f3 #0e82f4 #1976d2 #0d47a1", "#abd69b #bbdb73 #8eac6b #45774f #003e2d #1a2b2b"};
    private ResourceManager resourceManager;
    private List<MultiLineColorModel> models = new ArrayList<MultiLineColorModel>();
    private Button multiLineColorsCheck;
    private MComboViewer multiLineColorsSelectionViewer;

    public SheetMultiBranchColorsStylePropertySectionPart() {
        int i = 0;
        while (i < names.length) {
            this.models.add(new MultiLineColorModel(names[i], commandTexts[i]));
            ++i;
        }
    }

    @Override
    protected void createContent(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite multiLineColors = new Composite(parent, 0);
        multiLineColors.setLayout((Layout)this.createLayout(parent));
        this.multiLineColorsCheck = new Button(multiLineColors, 32);
        this.multiLineColorsCheck.setText(PropertyMessages.SheetMultiBranchColorsStylePropertySectionPart_multiBranchColor_text);
        this.multiLineColorsCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ToggleMultiColorCount");
                SheetMultiBranchColorsStylePropertySectionPart.this.multiLineColorsSelectionViewer.setEnabled(!SheetMultiBranchColorsStylePropertySectionPart.this.multiLineColorsSelectionViewer.isEnabled());
                if (SheetMultiBranchColorsStylePropertySectionPart.this.multiLineColorsSelectionViewer.isEnabled()) {
                    MultiLineColorModel model = (MultiLineColorModel)((StructuredSelection)SheetMultiBranchColorsStylePropertySectionPart.this.multiLineColorsSelectionViewer.getSelection()).getFirstElement();
                    if (model == null) {
                        model = (MultiLineColorModel)SheetMultiBranchColorsStylePropertySectionPart.this.models.get(0);
                    }
                    SheetMultiBranchColorsStylePropertySectionPart.this.changeRainbowColor(model.getCommandText());
                    SheetMultiBranchColorsStylePropertySectionPart.this.multiLineColorsSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)model));
                } else {
                    SheetMultiBranchColorsStylePropertySectionPart.this.changeRainbowColor(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.multiLineColorsSelectionViewer = new MComboViewer(multiLineColors, 1);
        this.multiLineColorsSelectionViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.multiLineColorsSelectionViewer.getControl().setToolTipText(PropertyMessages.MultiLineColors_text);
        this.multiLineColorsSelectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.multiLineColorsSelectionViewer.setLabelProvider((IBaseLabelProvider)new MultiLineColorLabelDescriptor());
        this.multiLineColorsSelectionViewer.setInput(this.models);
        this.multiLineColorsSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)new MultiLineColorChangeListener());
        this.multiLineColorsSelectionViewer.setEnabled(false);
    }

    @Override
    protected GridLayout createLayout(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 3;
        layout.marginHeight = 1;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        return layout;
    }

    @Override
    protected void doRefresh() {
        if (this.multiLineColorsCheck != null && !this.multiLineColorsCheck.isDisposed()) {
            String value = this.getStyleValue("multi-line-colors", null);
            boolean isSelected = value != null && !"none".equals(value);
            this.multiLineColorsCheck.setSelection(isSelected);
            this.multiLineColorsSelectionViewer.setEnabled(isSelected);
            this.multiLineColorsSelectionViewer.getControl().setVisible(isSelected);
            if (isSelected && value != null && this.multiLineColorsSelectionViewer != null && !this.multiLineColorsSelectionViewer.getControl().isDisposed()) {
                for (MultiLineColorModel model : this.models) {
                    if (!value.equals(model.getCommandText())) continue;
                    this.multiLineColorsSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)model));
                    break;
                }
            }
        }
    }

    private void changeRainbowColor(String multiLineColorsCommandText) {
        Request request = this.createStyleRequest(CommandMessages.Command_ToggleMultiLineColors);
        if (multiLineColorsCommandText != null) {
            this.addStyle(request, "multi-line-colors", multiLineColorsCommandText);
        } else {
            this.addStyle(request, "multi-line-colors", "none");
        }
        this.sendRequest(request);
    }

    public void dispose() {
        this.models = null;
        this.multiLineColorsCheck = null;
        this.multiLineColorsSelectionViewer = null;
    }

    public void setFocus() {
        this.multiLineColorsCheck.setFocus();
    }

    private class MultiLineColorChangeListener
    implements ISelectionChangedListener {
        private MultiLineColorChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (SheetMultiBranchColorsStylePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof MultiLineColorModel) {
                SheetMultiBranchColorsStylePropertySectionPart.this.changeRainbowColor(((MultiLineColorModel)o).getCommandText());
            }
        }
    }

    private class MultiLineColorLabelDescriptor
    extends ImageCachedLabelProvider {
        private static final int CELL_WIDTH = 15;
        private static final int CELL_HEIGHT = 15;
        private final RGB BACKGROUND = new RGB(182, 182, 182);

        private MultiLineColorLabelDescriptor() {
        }

        protected Image createImage(Object element) {
            if (element instanceof MultiLineColorModel) {
                List<RGB> rgbs = ((MultiLineColorModel)element).getRgbs();
                int imageWidth = (int)((double)(rgbs.size() * 15) * 1.1);
                int imageHeight = 15;
                Image image = new Image((Device)Display.getDefault(), imageWidth, imageHeight);
                GC gc = new GC((Drawable)image);
                gc.setAdvanced(true);
                gc.setAntialias(1);
                gc.setBackground(SheetMultiBranchColorsStylePropertySectionPart.this.resourceManager.createColor(this.BACKGROUND));
                gc.fillRectangle(0, 0, imageWidth, imageHeight);
                int x = 0;
                int y = 0;
                int i = 0;
                while (i < rgbs.size()) {
                    x = (int)(1.1 * (double)i * 15.0);
                    Color background = SheetMultiBranchColorsStylePropertySectionPart.this.resourceManager.createColor(rgbs.get(i));
                    gc.setBackground(background);
                    gc.fillRectangle(x, y, 15, 15);
                    ++i;
                }
                gc.dispose();
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof MultiLineColorModel) {
                return ((MultiLineColorModel)element).getName();
            }
            return null;
        }
    }

    private class MultiLineColorModel
    implements Comparable<MultiLineColorModel> {
        private List<RGB> rgbs;
        private String name;
        private String commandText = "";

        public MultiLineColorModel(String name, String commandText) {
            this.name = name;
            this.commandText = commandText;
        }

        public List<RGB> getRgbs() {
            if (this.commandText != null) {
                if (this.rgbs == null) {
                    String[] strs;
                    this.rgbs = new ArrayList<RGB>();
                    String[] stringArray = strs = this.commandText.split(" +");
                    int n = strs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        int rgbValue = Integer.parseInt(str.substring(1), 16);
                        this.rgbs.add(new RGB(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF));
                        ++n2;
                    }
                }
                return this.rgbs;
            }
            return Collections.emptyList();
        }

        public String getCommandText() {
            return this.commandText;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(MultiLineColorModel model) {
            if (this.commandText != null) {
                return this.commandText.compareTo(model.getCommandText());
            }
            return -1;
        }
    }
}

