/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.xmind.core.ILegend;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IDecorator;
import org.xmind.gef.acc.IAccessible;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.ui.internal.decorators.SheetDecorator;
import org.xmind.ui.internal.figures.SheetFigure;
import org.xmind.ui.internal.graphicalpolicies.SheetGraphicalPolicy;
import org.xmind.ui.internal.layouts.SheetLayout;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.LegendPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.RelationshipPart;
import org.xmind.ui.internal.mindmap.SheetAccessible;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.util.MindMapUtils;

public class SheetPart
extends MindMapPartBase
implements ISheetPart,
ControlListener {
    private IBranchPart centralBranch = null;
    private List<IBranchPart> floatingBranches = null;
    private List<IRelationshipPart> relationships = null;
    private ILegendPart legend = null;
    private final ChildSorter sorter = new ChildSorter((IPart)this);

    public SheetPart() {
        this.setDecorator((IDecorator)SheetDecorator.getInstance());
        this.setGraphicalPolicy((IGraphicalPolicy)SheetGraphicalPolicy.getInstance());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISheet.class)) {
            return this.getSheet();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public ISheet getSheet() {
        return ((IMindMap)super.getModel()).getSheet();
    }

    @Override
    public ITopic getRootTopic() {
        return this.getSheet().getRootTopic();
    }

    @Override
    public ITopic getCentralTopic() {
        return ((IMindMap)super.getModel()).getCentralTopic();
    }

    protected void register() {
        this.registerModel(this.getSheet());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getSheet());
    }

    @Override
    public IBranchPart getCentralBranch() {
        return this.centralBranch;
    }

    public void setCentralBranch(IBranchPart branch) {
        this.centralBranch = branch;
    }

    @Override
    public List<IBranchPart> getFloatingBranches() {
        if (this.floatingBranches == null) {
            this.floatingBranches = new ArrayList<IBranchPart>();
        }
        return this.floatingBranches;
    }

    public void addFloatingBranch(IBranchPart branch) {
        this.getFloatingBranches().add(branch);
        this.sorter.sort(this.getFloatingBranches());
    }

    public void removeFloatingBranch(IBranchPart branch) {
        this.getFloatingBranches().remove(branch);
    }

    @Override
    public List<IRelationshipPart> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new ArrayList<IRelationshipPart>();
        }
        return this.relationships;
    }

    public void addRelationship(IRelationshipPart relationship) {
        this.getRelationships().add(relationship);
        this.sorter.sort(this.getRelationships());
    }

    public void removeRelationship(IConnectionPart relationship) {
        this.getRelationships().remove(relationship);
    }

    @Override
    public ILegendPart getLegend() {
        return this.legend;
    }

    public void setLegend(ILegendPart legend) {
        this.legend = legend;
    }

    protected IFigure createFigure() {
        return new SheetFigure();
    }

    protected LayoutManager createLayoutManager() {
        return new SheetLayout(this);
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
        ILegend legend = this.getSheet().getLegend();
        if (legend.isVisible()) {
            list.add(new ViewerModel(LegendPart.class, legend));
        }
        ITopic rootTopic = this.getCentralTopic();
        list.add(new ViewerModel(BranchPart.class, rootTopic));
        for (ITopic floatingTopic : rootTopic.getChildren("detached")) {
            list.add(new ViewerModel(BranchPart.class, floatingTopic));
        }
        for (IRelationship rel : this.getSheet().getRelationships()) {
            if (!this.isRelationshipVisible(rel, rootTopic)) continue;
            ViewerModel m = new ViewerModel(RelationshipPart.class, rel);
            list.add(m);
        }
        return list.toArray();
    }

    private boolean isRelationshipVisible(IRelationship r, ITopic rootTopic) {
        IRelationshipEnd end1 = r.getEnd1();
        if (end1 instanceof ITopic && !this.isTopicVisible((ITopic)end1, rootTopic)) {
            return false;
        }
        IRelationshipEnd end2 = r.getEnd2();
        return !(end2 instanceof ITopic) || this.isTopicVisible((ITopic)end2, rootTopic);
    }

    private boolean isTopicVisible(ITopic t, ITopic rootTopic) {
        if (t.equals(rootTopic)) {
            return true;
        }
        if (this.isOverMaxLevel(t, rootTopic)) {
            return false;
        }
        ITopic parent = t.getParent();
        if (parent == null || parent.equals(rootTopic)) {
            return true;
        }
        String topicType = t.getType();
        if (!("attached".equals(topicType) || "summary".equals(topicType) || "callout".equals(topicType))) {
            return false;
        }
        return this.isTopicVisible(parent, rootTopic);
    }

    private boolean isOverMaxLevel(ITopic t, ITopic rootTopic) {
        int maxLevel = this.getSite().getViewer().getProperties().getInteger("maxTopicLevel", -1);
        if (maxLevel < 0) {
            return false;
        }
        int level = MindMapUtils.getLevel(t, rootTopic);
        return level < 0 || level > maxLevel;
    }

    protected void reorderChild(IPart child, int index) {
        super.reorderChild(child, index);
        if (this.getFloatingBranches().contains(child)) {
            this.sorter.sort(this.getFloatingBranches());
        } else if (this.getRelationships().contains(child)) {
            this.sorter.sort(this.getRelationships());
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("creatable role", "org.xmind.ui.editPolicy.sheetCreatable");
        reqHandler.installEditPolicy("scalable role", "org.xmind.ui.editPolicy.sheetScalable");
        reqHandler.installEditPolicy("editable role", "org.xmind.ui.editPolicy.editable");
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.modifiable");
        reqHandler.installEditPolicy("drop target role", "org.xmind.ui.editPolicy.dropTarget");
        reqHandler.installEditPolicy("map", "org.xmind.ui.editPolicy.map");
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("relationshipAdd");
        register.register("relationshipRemove");
        register.register("style");
        register.register("themeId");
        register.register("sheetSettings");
        ITopic rootTopic = this.getCentralTopic();
        register.setNextSourceFrom((Object)rootTopic);
        register.register("topicAdd");
        register.register("topicRemove");
        ILegend legend = this.getSheet().getLegend();
        register.setNextSourceFrom((Object)legend);
        register.register("visibility");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
            if ("detached".equals(event.getData())) {
                this.refresh();
            }
        } else if ("style".equals(type)) {
            this.update();
            this.updateCentralBranchStyle();
            this.refreshLegend();
        } else if ("relationshipAdd".equals(type) || "relationshipRemove".equals(type)) {
            this.refresh();
        } else if ("visibility".equals(type)) {
            this.refresh();
        } else if ("sheetSettings".equals(type)) {
            this.refresh();
        } else if ("themeId".equals(type)) {
            this.refreshTheme();
        } else {
            super.handleCoreEvent(event);
        }
    }

    private void updateCentralBranchStyle() {
        IBranchPart b = this.getCentralBranch();
        if (b instanceof BranchPart) {
            ((BranchPart)b).refreshStyles();
        }
    }

    private void refreshLegend() {
        if (this.getLegend() != null) {
            this.getLegend().refresh();
        }
    }

    public void refreshTheme() {
        this.refresh();
        if (this.centralBranch != null && this.centralBranch instanceof BranchPart) {
            ((BranchPart)this.centralBranch).refreshStyles();
        }
        for (IBranchPart floatingBranch : this.getFloatingBranches()) {
            if (!(floatingBranch instanceof BranchPart)) continue;
            ((BranchPart)floatingBranch).refreshStyles();
        }
        for (IRelationshipPart r : this.getRelationships()) {
            r.refresh();
        }
        if (this.legend != null) {
            this.legend.refresh();
        }
    }

    @Override
    protected boolean isFigureAnimatable() {
        return true;
    }

    public IPart findAt(Point position) {
        IPart ret;
        IPart focused = this.getSite().getViewer().getFocusedPart();
        if (focused instanceof IGraphicalEditPart && focused.getParent() == this && (ret = ((IGraphicalEditPart)focused).findAt(position)) != null) {
            return ret;
        }
        ret = super.findAt(position);
        if (ret == this) {
            return null;
        }
        return ret;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.setAccessible((IAccessible)new SheetAccessible(this));
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        this.getSite().getViewer().getControl().addControlListener((ControlListener)this);
    }

    @Override
    protected void onDeactivated() {
        this.getSite().getViewer().getControl().removeControlListener((ControlListener)this);
        super.onDeactivated();
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.getFigure().revalidate();
    }
}

