/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.IBoundary;
import org.xmind.core.ITopic;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.SourceCommand;

public class AddBoundaryCommand
extends SourceCommand {
    private ISourceProvider parentProvider;

    public AddBoundaryCommand(IBoundary boundary, ITopic parent) {
        super((Object)boundary);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
    }

    public AddBoundaryCommand(ISourceProvider boundaryProvider, ITopic parent) {
        super(boundaryProvider);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
    }

    public AddBoundaryCommand(ISourceProvider boundaryProvider, ISourceProvider parentProvider) {
        super(boundaryProvider);
        Assert.isNotNull((Object)parentProvider);
        this.parentProvider = parentProvider;
    }

    public void redo() {
        Object p = this.parentProvider.getSource();
        if (p instanceof ITopic) {
            ITopic parent = (ITopic)p;
            for (Object source : this.getSources()) {
                if (!(source instanceof IBoundary)) continue;
                parent.addBoundary((IBoundary)source);
            }
        }
        super.redo();
    }

    public void undo() {
        Object p = this.parentProvider.getSource();
        if (p instanceof ITopic) {
            ITopic parent = (ITopic)p;
            List sources = this.getSources();
            int i = sources.size() - 1;
            while (i >= 0) {
                Object source = sources.get(i);
                if (source instanceof IBoundary) {
                    parent.removeBoundary((IBoundary)source);
                }
                --i;
            }
        }
        super.undo();
    }
}

