/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionData;
import org.xmind.core.internal.security.ISecurityProvider;
import org.xmind.core.internal.security.NullSecurityProvider;

public class Crypto {
    private static ISecurityProvider provider = null;

    public static void setProvider(ISecurityProvider provider) {
        if (Crypto.provider != null) {
            return;
        }
        Crypto.provider = provider;
    }

    public static ISecurityProvider getProvider() {
        if (provider == null) {
            provider = NullSecurityProvider.getInstance();
        }
        return provider;
    }

    public static OutputStream creatOutputStream(OutputStream output, boolean encrypt, IEncryptionData encData, String password) throws CoreException {
        return Crypto.getProvider().createPasswordProtectedOutputStream(output, encrypt, encData, password);
    }

    public static InputStream createInputStream(InputStream input, boolean encrypt, IEncryptionData encData, String password) throws CoreException {
        return Crypto.getProvider().createPasswordProtectedInputStream(input, encrypt, encData, password);
    }

    public static void initEncryptionData(IEncryptionData encData) {
        Crypto.getProvider().initializeEncryptionData(encData);
    }
}

