/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.structures.Cell2;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Item2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column2
extends BranchStructureData {
    private Chart2 ownedChart;
    private List<Cell2> cells = new ArrayList<Cell2>();
    private int prefCellWidth = -1;
    private Integer left = null;
    private Integer width = null;

    public Column2(IBranchPart head, Chart2 ownedChart) {
        super(head);
        Assert.isNotNull((Object)head);
        Assert.isNotNull((Object)((Object)ownedChart));
        this.ownedChart = ownedChart;
    }

    public Chart2 getOwnedChart() {
        return this.ownedChart;
    }

    public IBranchPart getHead() {
        return this.getBranch();
    }

    void addCell(Cell2 cell) {
        this.cells.add(cell);
    }

    void removeCell(Cell2 cell) {
        this.cells.remove((Object)cell);
    }

    public List<Cell2> getCells() {
        return this.cells;
    }

    public int getPrefCellWidth() {
        if (this.prefCellWidth < 0) {
            this.prefCellWidth = this.calcPrefCellWidth();
        }
        return this.prefCellWidth;
    }

    private int calcPrefCellWidth() {
        int w = 0;
        for (Cell2 cell : this.cells) {
            w = Math.max(w, cell.getPrefContentSize().width);
        }
        return w;
    }

    public int getPrefWidth() {
        return Math.max(this.getHead().getTopicPart().getFigure().getPreferredSize().width, this.getPrefCellWidth());
    }

    public Cell2 findCellByRow(Row2 row) {
        for (Cell2 cell : this.cells) {
            if (cell.getOwnedRow() != row) continue;
            return cell;
        }
        return null;
    }

    public Cell2 findCellByItem(IBranchPart itemBranch) {
        for (Cell2 cell : this.cells) {
            if (cell.findItem(itemBranch) == null) continue;
            return cell;
        }
        return null;
    }

    public Item2 findItem(IBranchPart itemBranch) {
        for (Cell2 cell : this.cells) {
            Item2 item = cell.findItem(itemBranch);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Cell2 getPreviousCell(Cell2 cell) {
        int index = this.getCellIndex(cell);
        if (index > 0) {
            return this.cells.get(index - 1);
        }
        return null;
    }

    public Cell2 getNextCell(Cell2 cell) {
        int index = this.getCellIndex(cell);
        if (index < this.cells.size() - 1) {
            return this.cells.get(index + 1);
        }
        return null;
    }

    public int getCellIndex(Cell2 cell) {
        return this.cells.indexOf((Object)cell);
    }

    public int getLeft() {
        this.ensurePosition();
        return this.left;
    }

    public int getWidth() {
        this.ensurePosition();
        return this.width;
    }

    public int getRight() {
        return this.getLeft() + this.getWidth();
    }

    private void ensurePosition() {
        int w;
        int x;
        if (this.left != null && this.width != null) {
            return;
        }
        int lineWidth = this.getOwnedChart().getLineWidth();
        int index = this.getOwnedChart().getColumnIndex(this);
        IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getOwnedChart().getTitle(), (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        if (index == 0) {
            x = this.getOwnedChart().getTitle().getFigure().getBounds().x + lineWidth + this.getOwnedChart().getRowHeadWidth() + this.getOwnedChart().getMajorSpacing();
        } else {
            Column2 prev = this.getOwnedChart().getColumn(index - 1);
            x = prev.getRight();
        }
        if (ins != null && ins.getIndex() == index) {
            x += ins.getSize().width + this.getOwnedChart().getMinorSpacing() + lineWidth;
        }
        this.left = x;
        int numCols = this.getOwnedChart().getNumColumns();
        if (index == numCols - 1) {
            int right = this.getOwnedChart().getTitle().getFigure().getBounds().right();
            if (ins != null && ins.getIndex() == numCols) {
                right -= ins.getSize().width + this.getOwnedChart().getMinorSpacing() + lineWidth;
            }
            w = right - lineWidth - this.left;
        } else {
            int headWidth = this.getBranch().getTopicPart().getFigure().getBounds().width;
            w = Math.max(headWidth, this.getPrefCellWidth()) + this.getOwnedChart().getMinorSpacing();
        }
        this.width = w;
    }

    public Cell2 findCell(Point point) {
        if (this.getLeft() < point.x && this.getLeft() + this.getWidth() > point.x) {
            for (Cell2 cell : this.cells) {
                Row2 row = cell.getOwnedRow();
                if (row.getTop() >= point.y || row.getTop() + row.getHeight() <= point.y) continue;
                return cell;
            }
        }
        return null;
    }

    public int getMajorSpacing() {
        return super.getMajorSpacing();
    }

    public int getMinorSpacing() {
        return super.getMinorSpacing();
    }

    public String toString() {
        return this.getHead().toString();
    }
}

