/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class EditCommentsAction
extends Action
implements ISelectionAction {
    private IGraphicalViewer viewer;

    public EditCommentsAction(IGraphicalViewer viewer) {
        this.viewer = viewer;
        this.setId("org.xmind.ui.editComments");
        this.setText(MindMapMessages.EditComments_text);
        this.setImageDescriptor(MindMapUI.getImages().get("menu_modify_comment.png", true));
    }

    public void run() {
        if (this.viewer == null) {
            return;
        }
        ITopicPart topicPart = this.getSelectionTopicPart(this.viewer);
        if (topicPart == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        CommentsPopup popup = new CommentsPopup(window, topicPart, false);
        popup.open();
    }

    private ITopicPart getSelectionTopicPart(IGraphicalViewer viewer) {
        IStructuredSelection ss;
        Object o;
        IPart part;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && (part = viewer.findPart(o = (ss = (IStructuredSelection)selection).getFirstElement())) instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic((ISelection)selection));
    }
}

