/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;

public abstract class RichTextActionBarContributor
implements IRichTextActionBarContributor {
    private IRichTextEditViewer viewer;
    private Map<String, IRichTextAction> richTextActions = new HashMap<String, IRichTextAction>();

    public IRichTextEditViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void dispose() {
        for (IRichTextAction action : this.richTextActions.values()) {
            action.dispose();
        }
        this.richTextActions.clear();
        this.viewer = null;
    }

    @Override
    public void fillMenu(IMenuManager menu) {
    }

    @Override
    public void fillToolBar(IToolBarManager toolbar) {
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
    }

    @Override
    public void init(IRichTextEditViewer viewer) {
        this.viewer = viewer;
        this.makeActions(viewer);
    }

    protected abstract void makeActions(IRichTextEditViewer var1);

    protected void addRichTextAction(IRichTextAction action) {
        if (action != null && action.getId() != null) {
            this.richTextActions.put(action.getId(), action);
        }
    }

    public IRichTextAction getRichTextAction(String id) {
        return this.richTextActions.get(id);
    }

    @Override
    public void selectionChanged(ISelection selection, boolean enabled) {
        for (IRichTextAction action : this.richTextActions.values()) {
            action.selectionChanged(this.viewer, selection);
            action.setEnabled(enabled);
        }
    }
}

