/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.views.ThemeLabelProvider;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class ThemesViewer
extends GalleryViewer {
    private IStyle defaultTheme = null;
    private Image defaultImage = null;

    public ThemesViewer(Composite parent) {
        this.init();
        this.createControl(parent);
        Display display = parent.getDisplay();
        this.getControl().setBackground(display.getSystemColor(25));
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ThemesViewer.this.defaultImage != null) {
                    ThemesViewer.this.defaultImage.dispose();
                    ThemesViewer.this.defaultImage = null;
                }
            }
        });
    }

    protected void init() {
        this.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installTool("edit tool", (ITool)new ThemeNameEditTool());
        this.setEditDomain(editDomain);
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(0, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(128, 64));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
    }

    protected boolean isTitleEditable(IPart p) {
        Object model = p.getModel();
        if (!(model instanceof IStyle)) {
            return false;
        }
        IStyle theme = (IStyle)model;
        return theme.getOwnedStyleSheet() == MindMapUI.getResourceManager().getUserThemeSheet();
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection, true);
    }

    public IStyle getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(IStyle defaultTheme) {
        IStyle oldTheme = this.defaultTheme;
        this.defaultTheme = defaultTheme;
        this.updateThemePart(oldTheme);
        this.updateThemePart(defaultTheme);
    }

    private void updateThemePart(IStyle theme) {
        this.update(new Object[]{theme});
    }

    public void startEditing(IStyle theme) {
        EditDomain domain = this.getEditDomain();
        ITool tool = domain.getDefaultTool();
        ((GallerySelectTool)tool).getStatus().setStatus(1, true);
        domain.handleRequest("edit", (IViewer)this);
    }

    private static class ThemeNameEditTool
    extends GalleryEditTool {
        private ThemeNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserThemeSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(130);
        }
    }
}

