/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGGroup
extends SVGShape {
    private List<SVGShape> children;

    SVGGroup() {
        this.children = new ArrayList<SVGShape>();
    }

    public SVGGroup(List<SVGShape> children) {
        this.children = children;
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseGroup(implemention, parent);
    }

    private void parseGroup(Element implemention, SVGShape parent) {
        NodeList list = implemention.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            SVGShape shape;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (shape = SVGGroup.parseShape((Element)node, this)) != null) {
                this.children.add(shape);
            }
            ++i;
        }
    }

    @Override
    void paintImage(Graphics graphics, Display device) {
        boolean statePushed = super.prePaint(graphics);
        for (SVGShape shape : this.children) {
            shape.paintImage(graphics, device);
        }
        super.postPaint(graphics, statePushed);
    }

    @Override
    Path generatePath(Display device) {
        return null;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return null;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        super.setResourceManager(resourceManager);
        for (SVGShape shape : this.children) {
            shape.setResourceManager(resourceManager);
        }
    }

    @Override
    protected SVGShape clone() {
        SVGGroup group = new SVGGroup();
        group.setInfo(this.getInfo().clone());
        group.children = new ArrayList<SVGShape>();
        for (SVGShape shape : this.children) {
            group.children.add(shape.clone());
        }
        return group;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVGGroup) {
            SVGGroup group = (SVGGroup)obj;
            if (this.children.size() == group.children.size()) {
                int i = 0;
                while (i < this.children.size()) {
                    if (!this.children.get(i).equals(group.children.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        for (SVGShape shape : this.children) {
            result = result * 31 + shape.hashCode();
        }
        return result;
    }

    public String toString() {
        String str = "SVGGroup( children Size: ";
        str = String.valueOf(str) + this.children.size();
        str = String.valueOf(str) + this.getInfo().toString();
        str = String.valueOf(str) + " )";
        return str;
    }
}

