/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.xmind.gef.IViewer;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.DraggingTool;

public class BrowsingTool
extends DraggingTool {
    private static final Point SCROLL_POSITION = new Point();
    private Point startScrollPosition = null;
    private boolean hidePopupMenu = false;

    protected void start() {
        this.startScrollPosition = new Point(this.getTargetViewer().getScrollPosition());
    }

    protected void end() {
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.HAND;
    }

    public void mouseDrag(MouseDragEvent me, IViewer viewer) {
        super.mouseDrag(me, viewer);
        if (!me.leftOrRight && !this.hidePopupMenu) {
            this.hidePopupMenu = true;
        }
    }

    public void mouseUp(MouseEvent me, IViewer viewer) {
        Menu menu;
        Control control;
        super.mouseUp(me, viewer);
        if (this.hidePopupMenu && (control = viewer.getControl()) != null && !control.isDisposed() && (menu = control.getMenu()) != null && !menu.isDisposed()) {
            menu.setVisible(false);
        }
        this.hidePopupMenu = false;
    }

    protected void onDragging(Point cursorPosition, MouseDragEvent me) {
        if (this.startScrollPosition != null) {
            SCROLL_POSITION.setLocation(this.startScrollPosition);
            SCROLL_POSITION.translate(me.getSWTDisplacement().negate());
            this.getTargetViewer().scrollTo(SCROLL_POSITION);
        }
    }
}

