/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.gantt2.gefext.IPathShape;
import org.xmind.ui.gantt2.gefext.PathDescriptor;

public class PathShape
extends Shape
implements IPathShape {
    private static final Rectangle OLD_BOUNDS = new Rectangle();
    private static final float[] BOUNDS_ARRAY = new float[4];
    private static final Rectangle NEW_BOUNDS = new Rectangle();
    protected static final PathDescriptor DEFAULT_PATH_DATA = new PathDescriptor().moveTo(0.0, 0.0).lineTo(0.0, 0.0);
    private PathDescriptor outlinePath = null;
    private PathDescriptor fillPath = null;
    private int tolerance = 0;
    private boolean fill = true;
    private boolean outline = true;
    private Rectangle pathBounds = null;

    public PathDescriptor getFillPath() {
        return this.fillPath == null ? DEFAULT_PATH_DATA : this.fillPath;
    }

    public PathDescriptor getOutlinePath() {
        return this.outlinePath == null ? DEFAULT_PATH_DATA : this.outlinePath;
    }

    public void setFillPath(PathDescriptor path) {
        if (path == this.fillPath || path != null && path.equals(this.fillPath)) {
            return;
        }
        PathDescriptor oldPath = this.getFillPath();
        this.fillPath = path;
        this.invalidatePathBounds();
        this.revalidate();
        this.firePropertyChange("fill path", oldPath, this.getFillPath());
    }

    private void invalidatePathBounds() {
        this.pathBounds = null;
    }

    public void setOutlinePath(PathDescriptor path) {
        if (path == this.outlinePath || path != null && path.equals(this.outlinePath)) {
            return;
        }
        PathDescriptor oldPath = this.getOutlinePath();
        this.outlinePath = path;
        this.invalidatePathBounds();
        this.revalidate();
        this.firePropertyChange("outline path", oldPath, this.getOutlinePath());
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    protected Path createPath(PathDescriptor descriptor) {
        Path path = new Path((Device)Display.getCurrent());
        if (descriptor == null) {
            descriptor = DEFAULT_PATH_DATA;
        }
        descriptor.applyTo(path);
        return path;
    }

    protected void layout() {
        Rectangle oldBounds = OLD_BOUNDS;
        oldBounds.setBounds(this.getBounds());
        Rectangle newBounds = NEW_BOUNDS;
        newBounds.setBounds(this.getPathBounds());
        for (Object child : this.getChildren()) {
            newBounds = newBounds.union(((IFigure)child).getBounds());
        }
        boolean translate = oldBounds.x != newBounds.x || oldBounds.y != newBounds.y;
        this.setBounds(newBounds);
        super.layout();
        if (translate) {
            this.invalidate();
        }
        this.repaint();
    }

    private Rectangle getPathBounds() {
        if (this.pathBounds == null) {
            this.pathBounds = this.calculatePathBounds();
        }
        return this.pathBounds;
    }

    protected Rectangle calculatePathBounds() {
        Path path = this.createPath(!this.outline ? this.getFillPath() : this.getOutlinePath());
        try {
            path.getBounds(BOUNDS_ARRAY);
            if (Util.isWindows()) {
                float[] autoScaleDown = DPIUtil.autoScaleDown((float[])BOUNDS_ARRAY);
                PathShape.BOUNDS_ARRAY[0] = autoScaleDown[0];
                PathShape.BOUNDS_ARRAY[1] = autoScaleDown[1];
                PathShape.BOUNDS_ARRAY[2] = autoScaleDown[2];
                PathShape.BOUNDS_ARRAY[3] = autoScaleDown[3];
            }
        }
        finally {
            path.dispose();
        }
        float x = BOUNDS_ARRAY[0];
        float y = BOUNDS_ARRAY[1];
        float width = BOUNDS_ARRAY[2];
        float height = BOUNDS_ARRAY[3];
        if (this.outline) {
            float lw = this.getLineWidthFloat();
            x -= lw;
            y -= lw;
            width += lw + lw;
            height += lw + lw;
        }
        Rectangle r = new Rectangle();
        r.x = (int)Math.floor(x);
        r.y = (int)Math.floor(y);
        r.width = (int)Math.ceil(width);
        r.height = (int)Math.ceil(height);
        return r;
    }

    public void setLineWidth(int w) {
        float oldWidth = this.getLineWidthFloat();
        super.setLineWidth(w);
        float newWidth = this.getLineWidthFloat();
        if (newWidth != oldWidth) {
            this.invalidatePathBounds();
            this.revalidate();
        }
    }

    public void setLineWidthFloat(float value) {
        float oldWidth = this.getLineWidthFloat();
        super.setLineWidthFloat(value);
        float newWidth = this.getLineWidthFloat();
        if (newWidth != oldWidth) {
            this.invalidatePathBounds();
            this.revalidate();
        }
    }

    protected void fillShape(Graphics graphics) {
        Path path = this.createPath(this.getFillPath());
        try {
            graphics.fillPath(path);
        }
        finally {
            path.dispose();
        }
    }

    protected void outlineShape(Graphics graphics) {
        Path path = this.createPath(this.getOutlinePath());
        try {
            graphics.drawPath(path);
        }
        finally {
            path.dispose();
        }
    }

    public boolean containsPoint(int x, int y) {
        if (!this.fill && !this.outline) {
            return false;
        }
        if (!this.outline && !super.containsPoint(x, y)) {
            return false;
        }
        GC gc = GraphicsUtils.getAdvanced().getGC();
        if (this.fill) {
            gc.setFillRule(this.getCheckFillRule());
            Path path = this.createPath(this.getFillPath());
            try {
                if (path.contains((float)x, (float)y, gc, false)) {
                    return true;
                }
            }
            finally {
                path.dispose();
            }
        }
        LineAttributes la = this.getLineAttributes();
        LineAttributes la2 = new LineAttributes(la.width, la.cap, la.join, la.style, la.dash, la.dashOffset, la.miterLimit);
        la2.width += (float)this.getTolerance();
        gc.setLineAttributes(la2);
        Path path = this.createPath(this.getOutlinePath());
        try {
            boolean bl = path.contains((float)x, (float)y, gc, true);
            return bl;
        }
        finally {
            path.dispose();
        }
    }

    protected int getCheckFillRule() {
        return 2;
    }

    public void setFill(boolean b) {
        boolean oldValue = this.fill;
        this.fill = b;
        super.setFill(b);
        if (oldValue != this.fill) {
            this.invalidatePathBounds();
            this.revalidate();
        }
    }

    public void setOutline(boolean b) {
        boolean oldValue = this.outline;
        this.outline = b;
        super.setOutline(b);
        if (oldValue != this.outline) {
            this.invalidatePathBounds();
            this.revalidate();
        }
    }
}

