/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt2.gefext.GraphicalRootEditPart;
import org.xmind.ui.gantt2.viewer.IHasOffset;

public class TimelineRootPart
extends GraphicalRootEditPart {
    private static final Rectangle AREA = new Rectangle();
    private static final Rectangle RECT = new Rectangle();

    protected Viewport createViewport() {
        Viewport viewport = new Viewport(true);
        viewport.setContentsTracksHeight(true);
        viewport.setContentsTracksWidth(true);
        return viewport;
    }

    protected void addLayers(LayeredPane layeredPane) {
        Layer contentsLayer = new Layer();
        contentsLayer.setLayoutManager((LayoutManager)new StackLayout());
        layeredPane.add((IFigure)contentsLayer, GEF.LAYER_CONTENTS);
        Layer majorTitleLayer = new Layer();
        majorTitleLayer.setLayoutManager((LayoutManager)new TicksLayout());
        layeredPane.add((IFigure)majorTitleLayer, (Object)"org.xmind.ui.gantt.layer.majorTitle");
    }

    protected void onActivated() {
        super.onActivated();
    }

    public static class TicksLayout
    extends AbstractLayout {
        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            if (wHint > -1) {
                wHint = Math.max(0, wHint - container.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - container.getInsets().getHeight());
            }
            Dimension d = new Dimension();
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (!this.isObservingVisibility() || child.isVisible()) {
                    d.union(child.getPreferredSize(wHint, hHint));
                }
                ++i;
            }
            d.expand(container.getInsets().getWidth(), container.getInsets().getHeight());
            d.union(this.getBorderPreferredSize(container));
            return d;
        }

        public void layout(IFigure container) {
            List children = container.getChildren();
            Rectangle clientArea = container.getClientArea(AREA);
            int x = clientArea.x;
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                Dimension childSize = child.getPreferredSize();
                int offset = ((IHasOffset)child).getOffset();
                Rectangle r = RECT;
                r.setLocation(x + offset, clientArea.y);
                r.setSize(childSize.width, clientArea.height);
                child.setBounds(r);
                ++i;
            }
        }
    }
}

