/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.xmind.cathy.internal.AbstractCheckFilesProcess;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.jobs.OpenXMindCommandFileJob;
import org.xmind.core.IWorkbook;
import org.xmind.core.command.Command;
import org.xmind.core.command.CommandJob;
import org.xmind.core.command.ICommand;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.editor.ClonedWorkbookRef;
import org.xmind.ui.internal.imports.freemind.FreeMindImporter;
import org.xmind.ui.internal.imports.mm.MindManagerImporter;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.PrefUtils;

public class OpenFilesProcess
extends AbstractCheckFilesProcess {
    private List<String> filesToOpen;
    private boolean markersImported = false;
    private List<String> commandFilesToOpen = new ArrayList<String>(1);

    public OpenFilesProcess(IWorkbench workbench) {
        super(workbench);
        this.filesToOpen = new ArrayList<String>();
    }

    public OpenFilesProcess(IWorkbench workbench, Collection<String> files) {
        super(workbench);
        this.filesToOpen = new ArrayList<String>(files);
    }

    public void doCheckAndOpenFiles() {
        this.filterFilesToOpen(this.filesToOpen);
        if (!this.filesToOpen.isEmpty()) {
            this.addEditors();
            this.openEditors(true);
        }
        this.onFilsOpened();
    }

    protected void onFilsOpened() {
        if (this.markersImported) {
            this.showMarkersPrefPage();
        }
        if (!this.commandFilesToOpen.isEmpty()) {
            this.openXMindCommandFiles();
        }
    }

    protected void filterFilesToOpen(List<String> filesToOpen) {
    }

    protected void addEditors() {
        for (final String fileName : this.filesToOpen) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)WorkbenchMessages.CheckOpenFilesJob_FailsToOpen_message, (Object)fileName)){

                public void run() throws Exception {
                    IEditorInput input = OpenFilesProcess.this.createEditorInput(fileName);
                    if (input != null) {
                        OpenFilesProcess.this.addEditorToOpen(input);
                    }
                }
            });
        }
    }

    protected IEditorInput createEditorInput(String fileName) throws Exception {
        Command command = Command.parseURI((String)fileName);
        if (command != null) {
            new CommandJob((ICommand)command, null).schedule();
            return null;
        }
        String path = fileName;
        String extension = FileUtils.getExtension((String)path);
        if (".xmind-command".equalsIgnoreCase(extension)) {
            return this.openXMindCommandFile(path);
        }
        if (".xmt".equalsIgnoreCase(extension)) {
            return this.newFromTemplate(path, fileName);
        }
        if (".mmap".equalsIgnoreCase(extension)) {
            return this.importMindManagerFile(path, fileName);
        }
        if (".mm".equalsIgnoreCase(extension)) {
            return this.importFreeMindFile(path, fileName);
        }
        if (".xmp".equalsIgnoreCase(extension)) {
            return this.importMarkers(path);
        }
        return MindMapUI.getEditorInputFactory().createEditorInputForFile(new File(path));
    }

    protected IEditorInput newFromTemplate(String path, String fileName) throws Exception {
        IWorkbookRef ref = ClonedWorkbookRef.createFromSourceWorkbookURI((URI)new File(path).toURI(), (String)fileName);
        return MindMapUI.getEditorInputFactory().createEditorInput(ref);
    }

    protected IEditorInput importMindManagerFile(String path, String fileName) throws Exception {
        MindManagerImporter importer = new MindManagerImporter(path);
        importer.build();
        IWorkbook workbook = importer.getTargetWorkbook();
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput importFreeMindFile(String path, String fileName) throws Exception {
        FreeMindImporter importer = new FreeMindImporter(path);
        importer.build();
        IWorkbook workbook = importer.getTargetWorkbook();
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput importMarkers(String path) throws Exception {
        MarkerImpExpUtils.importMarkerPackage((String)path);
        this.markersImported = true;
        return null;
    }

    private void showMarkersPrefPage() {
        Display display = this.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PrefUtils.openPrefDialog(null, (String)"org.xmind.ui.MarkersPrefPage");
            }
        });
    }

    private IEditorInput openXMindCommandFile(String path) {
        this.commandFilesToOpen.add(path);
        return null;
    }

    private void openXMindCommandFiles() {
        for (String path : this.commandFilesToOpen) {
            new OpenXMindCommandFileJob(path).schedule(500L);
        }
    }
}

