/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.JSONStore;
import org.xmind.core.net.internal.Activator;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.internal.IRequestStatusChangeListener;

public class XMindNetRequest {
    public static final int HTTP_PREPARING = 0;
    public static final int HTTP_CONNECTING = 1;
    public static final int HTTP_SENDING = 2;
    public static final int HTTP_WAITING = 3;
    public static final int HTTP_RECEIVING = 4;
    public static final int HTTP_ERROR = 999;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    private static final boolean DEBUG_ALL = Activator.isDebugging("/debug/http/requests");
    private static final boolean DEBUG_TO_STDOUT = DEBUG_ALL || Activator.isDebugging("/debug/requests/stdout");
    private static final boolean DEBUG_ASSC = Activator.isDebugging("/debug/requests/assc");
    private static final String DEFAULT_DOMAIN = "www.xmind.net";
    private static final String HEAD = "HEAD";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static Set<String> WRITABLE_METHODS = new HashSet<String>(Arrays.asList("POST", "PUT"));
    private boolean https;
    private String method = null;
    private String uri = null;
    private String domain = "www.xmind.net";
    private String path = null;
    private List<NamedValue> requestHeaders = new ArrayList<NamedValue>();
    private List<NamedValue> params = new ArrayList<NamedValue>();
    private boolean multipart = false;
    private File targetFile = null;
    private int statusCode = 0;
    private String responseText = null;
    private IDataStore data = null;
    private List<NamedValue> responseHeaders = new ArrayList<NamedValue>();
    private boolean aborted = false;
    private Throwable error = null;
    private List<IRequestStatusChangeListener> statusChangeListeners = new ArrayList<IRequestStatusChangeListener>();
    private boolean debugging = DEBUG_ALL || System.getProperty("org.xmind.debug.httprequests") != null;
    private long totalBytes = 0L;
    private long transferedBytes = 0L;
    private Thread runningThread = null;

    public XMindNetRequest() {
        this(false);
    }

    public XMindNetRequest(boolean useHTTPS) {
        this.https = useHTTPS;
    }

    public XMindNetRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    public XMindNetRequest path(String path, Object ... values) {
        this.path = EncodingUtils.format(path, values);
        return this;
    }

    protected XMindNetRequest domain(String domain) {
        this.domain = domain;
        return this;
    }

    public XMindNetRequest useHTTPS() {
        this.https = true;
        return this;
    }

    public XMindNetRequest multipart() {
        this.multipart = true;
        return this;
    }

    public XMindNetRequest setAuthToken(String authToken) {
        return this.addHeader("AuthToken", authToken);
    }

    public XMindNetRequest addHeader(String name, String value) {
        this.requestHeaders.add(new NamedValue(name, value));
        return this;
    }

    public XMindNetRequest addParameter(String name, Object value) {
        this.params.add(new NamedValue(name, value));
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        StringBuffer uriBuilder = new StringBuffer(50);
        if (this.uri != null) {
            uriBuilder.append(this.uri);
        } else if (this.path != null) {
            String domain;
            String string = domain = this.domain == null ? DEFAULT_DOMAIN : this.domain;
            if (this.https) {
                uriBuilder.append("https://");
            } else {
                uriBuilder.append("http://");
            }
            uriBuilder.append(domain);
            uriBuilder.append(this.path);
        } else {
            return null;
        }
        if (!WRITABLE_METHODS.contains(this.method) && !this.params.isEmpty()) {
            int i = uriBuilder.indexOf("?");
            if (i >= 0) {
                if (i < uriBuilder.length() - 1) {
                    uriBuilder.append('&');
                }
            } else {
                uriBuilder.append('?');
            }
            uriBuilder.append(XMindNetRequest.toQueryString(this.params));
        }
        return uriBuilder.toString();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTransferedBytes() {
        return this.transferedBytes;
    }

    public XMindNetRequest setTargetFile(File file) {
        this.targetFile = file;
        return this;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void abort() {
        this.aborted = true;
        Thread theThread = this.runningThread;
        if (theThread != null) {
            theThread.interrupt();
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public XMindNetRequest head() {
        this.method = HEAD;
        return this.execute();
    }

    public XMindNetRequest get() {
        this.method = GET;
        return this.execute();
    }

    public XMindNetRequest put() {
        this.method = PUT;
        return this.execute();
    }

    public XMindNetRequest delete() {
        this.method = DELETE;
        return this.execute();
    }

    public XMindNetRequest post() {
        this.method = POST;
        return this.execute();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public IDataStore getData() {
        return this.data;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public List<String> getAllResponseHeaders() {
        ArrayList<String> keys = new ArrayList<String>(this.responseHeaders.size());
        for (NamedValue header : this.responseHeaders) {
            keys.add(header.name);
        }
        return keys;
    }

    public String getResponseHeader(String name) {
        if (name != null) {
            for (NamedValue header : this.responseHeaders) {
                if (!name.equalsIgnoreCase(header.name)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    protected synchronized XMindNetRequest execute() {
        this.runningThread = Thread.currentThread();
        try {
            if (this.isAborted()) {
                XMindNetRequest xMindNetRequest = this;
                return xMindNetRequest;
            }
            if (this.method == null) {
                throw new IllegalStateException("Invalid HTTP Request: no method specified");
            }
            final String uri = this.getURI();
            if (uri == null) {
                throw new IllegalStateException("Invalid HTTP Request: no URI/path specified");
            }
            final RequestWriter writer = this.createRequestWriter();
            if (this.isAborted()) {
                XMindNetRequest xMindNetRequest = this;
                return xMindNetRequest;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    XMindNetRequest.this.executeInDaemonThread(uri, writer);
                }
            }, "XMindNetRequestConnection:" + uri);
            thread.setDaemon(true);
            thread.setPriority(3);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            XMindNetRequest xMindNetRequest = this;
            return xMindNetRequest;
        }
        finally {
            this.runningThread = null;
        }
    }

    private void executeInDaemonThread(String uri, RequestWriter writer) {
        block6: {
            this.error = null;
            try {
                if (this.isAborted()) {
                    return;
                }
                this.debug("HTTP Request: (Prepared) %s %s\r\n%s", this.method, uri, this.requestHeaders);
                this.send(uri, writer);
                if (this.isAborted()) {
                    return;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.debug("HTTP Request: (Aborted) %s %s", this.method, uri);
                if (!this.isAborted()) {
                    this.abort();
                }
            }
            catch (Throwable e) {
                if (this.isAborted()) break block6;
                this.error = e;
                this.debug("HTTP Request: (Error: %s) %s %s", e, this.method, uri);
            }
        }
    }

    protected void send(String uri, RequestWriter writer) throws IOException {
        HttpURLConnection connection;
        this.data = null;
        this.responseText = null;
        this.responseHeaders.clear();
        this.setStatusCode(1);
        this.debug("HTTP Request: (Connecting...) %s %s", this.method, uri);
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        URL url = new URL(uri);
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        Proxy proxy = this.getProxy(uri);
        if (proxy != null) {
            this.debug("HTTP Request: (Applying proxy %s) %s %s", proxy, this.method, uri);
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        if (DEBUG_ASSC) {
            XMindNetRequest.assc(connection);
            if (this.isAborted()) {
                throw new OperationCanceledException();
            }
        }
        this.setStatusCode(2);
        this.debug("HTTP Request: (Sending data...) %s %s", this.method, uri);
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        try {
            try {
                block27: {
                    do {
                        connection.setInstanceFollowRedirects(false);
                        connection.setDoOutput(writer != null);
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        connection.setRequestMethod(this.method);
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        if (writer != null) {
                            writer.init(this.params);
                        }
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        this.writeHeaders(uri, connection, writer);
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        if (writer != null) {
                            this.writeBody(uri, connection, writer);
                        }
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        this.setStatusCode(3);
                        this.debug("HTTP Request: (Waiting...) %s %s", this.method, uri);
                        if (this.isAborted()) {
                            throw new OperationCanceledException();
                        }
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 301 && responseCode != 302) break block27;
                        String newLocation = connection.getHeaderField("Location");
                        connection = proxy != null ? (HttpURLConnection)new URL(newLocation).openConnection(proxy) : (HttpURLConnection)new URL(newLocation).openConnection();
                    } while (!this.isAborted());
                    throw new OperationCanceledException();
                }
                this.readResponse(uri, connection, connection.getInputStream(), connection.getResponseCode());
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
            }
            catch (IOException iOException) {
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                this.readResponse(uri, connection, connection.getErrorStream(), connection.getResponseCode());
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected Proxy getProxy(String uri) {
        return null;
    }

    public Throwable getError() {
        return this.error;
    }

    private RequestWriter createRequestWriter() {
        if (WRITABLE_METHODS.contains(this.method)) {
            if (this.multipart) {
                return new MultipartWriter();
            }
            return new FormSubmitter();
        }
        return null;
    }

    protected void writeHeaders(String uri, URLConnection connection, RequestWriter writer) {
        ArrayList<NamedValue> writtenHeaders = new ArrayList<NamedValue>();
        Object accept = null;
        for (NamedValue header : this.requestHeaders) {
            this.writeHeader(connection, header.name, header.getValue(), writtenHeaders);
            if (!"Accept".equalsIgnoreCase(header.name)) continue;
            accept = header.value;
        }
        if (accept == null || "".equals(accept)) {
            this.writeHeader(connection, "Accept", "application/json", writtenHeaders);
        }
        this.writeHeader(connection, "X-Client-ID", this.getClientId(), writtenHeaders);
        if (writer != null) {
            this.writeHeader(connection, "Content-Type", writer.getContentType(), writtenHeaders);
            this.writeHeader(connection, "Content-Length", String.valueOf(writer.getContentLength()), writtenHeaders);
        }
        this.debug("HTTP Request: (Headers written) %s %s\r\n%s", this.method, uri, writtenHeaders);
    }

    private String getClientId() {
        return "xmind_v3.4.1";
    }

    protected void writeHeader(URLConnection connection, String key, String value, List<NamedValue> headers) {
        connection.setRequestProperty(key, value);
        headers.add(new NamedValue(key, value));
    }

    private void writeBody(String uri, URLConnection connection, RequestWriter writer) throws IOException {
        OutputStream writeStream = connection.getOutputStream();
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        BufferedOutputStream bufferedWriteStream = new BufferedOutputStream(writeStream);
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        writer.write(bufferedWriteStream);
        if (this.isAborted()) {
            throw new OperationCanceledException();
        }
        bufferedWriteStream.flush();
        writeStream.flush();
    }

    protected static String toQueryString(List<NamedValue> parameters) {
        StringBuffer buffer = new StringBuffer(parameters.size() * 15);
        int i = 0;
        while (i < parameters.size()) {
            NamedValue param = parameters.get(i);
            if (i > 0) {
                buffer.append('&');
            }
            buffer.append(param.getEncodedName());
            buffer.append('=');
            buffer.append(param.getEncodedValue());
            ++i;
        }
        return buffer.toString();
    }

    protected void readResponse(String uri, URLConnection connection, InputStream readStream, int responseCode) throws IOException {
        block18: {
            this.responseText = null;
            this.data = null;
            this.responseHeaders.clear();
            if (responseCode < 0) {
                responseCode = 999;
            }
            try {
                this.readResponseHeaders(connection);
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                if (responseCode == 999) {
                    this.setStatusCode(responseCode);
                    this.debug("HTTP Response: (Unknown error) %s %s", this.method, uri);
                    break block18;
                }
                this.totalBytes = 0L;
                this.transferedBytes = 0L;
                String length = this.getResponseHeader("Content-Length");
                if (length != null) {
                    try {
                        this.totalBytes = Long.parseLong(length, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                if (this.totalBytes == 0L) {
                    this.totalBytes = readStream.available();
                }
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                this.setStatusCode(4);
                this.debug("HTTP Request: (Receiving data, total %s bytes...) [%s] %s %s", this.totalBytes, responseCode, this.method, uri);
                if (this.isAborted()) {
                    throw new OperationCanceledException();
                }
                if (this.targetFile != null && responseCode >= 200 && responseCode < 300) {
                    this.saveTargetFile(readStream);
                    this.setStatusCode(responseCode);
                    this.debug("HTTP Request: (Response) [%s] %s %s\r\n%s\r\nSaved to '%s' (%s bytes).", this.getStatusCode(), this.method, uri, this.responseHeaders, this.targetFile.getAbsolutePath(), this.targetFile.length());
                } else {
                    int wrappedResponseCode = this.readResponseData(readStream);
                    if (wrappedResponseCode >= 100) {
                        this.setStatusCode(wrappedResponseCode);
                    } else {
                        this.setStatusCode(responseCode);
                    }
                    this.debug("HTTP Request: (Response) [%s] %s %s\r\n%s\r\n%s", responseCode, this.method, uri, this.responseHeaders, this.responseText);
                }
            }
            finally {
                if (this.statusCode < 100 && responseCode >= 100) {
                    this.setStatusCode(responseCode);
                }
            }
        }
    }

    private int readResponseData(InputStream readStream) throws IOException {
        String respType;
        this.responseText = this.readResponseText(readStream);
        if (!"".equals(this.responseText) && (respType = this.getResponseHeader("Content-Type")) != null && respType.indexOf("application/json") >= 0) {
            try {
                this.data = new JSONStore(new JSONObject(this.responseText));
                if (this.data.has("_code")) {
                    return this.data.getInt("_code");
                }
            }
            catch (JSONException e) {
                this.error = e;
            }
        }
        return 0;
    }

    private String readResponseText(InputStream readStream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(Math.max((int)this.totalBytes, 1024));
        this.transfer(readStream, bytes);
        return bytes.toString("utf-8");
    }

    private void saveTargetFile(InputStream readStream) throws IOException {
        File file = this.targetFile;
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (FileOutputStream fileWriteStream = new FileOutputStream(file);){
            this.transfer(readStream, fileWriteStream);
        }
    }

    protected void transfer(InputStream readStream, OutputStream writeStream) throws IOException {
        this.transfer(readStream, writeStream, 1024);
    }

    protected void transfer(InputStream readStream, OutputStream writeStream, int bufSize) throws IOException {
        int bytes;
        if (bufSize <= 0) {
            bufSize = 1024;
        }
        byte[] buffer = new byte[bufSize];
        while ((bytes = readStream.read(buffer)) >= 0) {
            writeStream.write(buffer, 0, bytes);
            this.transferedBytes += (long)bytes;
            if (this.isAborted()) {
                throw new OperationCanceledException();
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
    }

    private void readResponseHeaders(URLConnection connection) {
        String key;
        connection.getHeaderField(0);
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            String value = connection.getHeaderField(i);
            this.responseHeaders.add(new NamedValue(key, value));
            ++i;
        }
    }

    public XMindNetRequest debug() {
        this.debugging = true;
        return this;
    }

    public void addStatusChangeListener(IRequestStatusChangeListener listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeStatusChangeListener(IRequestStatusChangeListener listener) {
        this.statusChangeListeners.remove(listener);
    }

    protected void setStatusCode(int newStatus) {
        if (newStatus == this.statusCode) {
            return;
        }
        int oldStatus = this.statusCode;
        this.statusCode = newStatus;
        this.fireStatusChanged(oldStatus);
    }

    protected void fireStatusChanged(int oldStatus) {
        int newStatus = this.statusCode;
        IRequestStatusChangeListener[] listeners = this.statusChangeListeners.toArray(new IRequestStatusChangeListener[this.statusChangeListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].requestStatusChanged(this, oldStatus, newStatus);
            }
            catch (Throwable e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.core.net", "Error occurred when notifying request status change.", e));
            }
            ++i;
        }
    }

    protected void debug(String format, Object ... values) {
        if (!this.debugging) {
            return;
        }
        if (DEBUG_TO_STDOUT) {
            System.out.println(String.format(format, values));
        } else {
            Activator.log(String.format(format, values));
        }
    }

    private static void assc(HttpURLConnection connection) {
        try {
            TrustModifier.relaxHostChecking(connection);
        }
        catch (Exception e) {
            if (DEBUG_TO_STDOUT) {
                e.printStackTrace();
                System.err.println("Failed to relax host checking.");
            }
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.core.net", "Failed to relax host checking.", (Throwable)e));
        }
    }

    protected static class FormSubmitter
    extends RequestWriter {
        private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
        private byte[] formData = null;

        protected FormSubmitter() {
        }

        private byte[] getFormData() {
            if (this.formData != null) {
                return this.formData;
            }
            this.formData = EncodingUtils.toAsciiBytes(XMindNetRequest.toQueryString(this.getParameters()));
            return this.formData;
        }

        @Override
        public String getContentType() {
            return FORM_CONTENT_TYPE;
        }

        @Override
        public long getContentLength() {
            return this.getFormData().length;
        }

        @Override
        public void write(OutputStream stream) throws IOException {
            stream.write(this.getFormData());
        }
    }

    protected static class MultipartWriter
    extends RequestWriter {
        private static final String MULTIPART_CONTENT_TYPE = "multipart/form-data; boundary=";
        private static final byte[] BOUNDARY_CHARS = EncodingUtils.toAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        private static final byte[] CRLF = EncodingUtils.toAsciiBytes("\r\n");
        private static final byte[] QUOTE = EncodingUtils.toAsciiBytes("\"");
        private static final byte[] EXTRA = EncodingUtils.toAsciiBytes("--");
        private static final byte[] CONTENT_DISPOSITION = EncodingUtils.toAsciiBytes("Content-Disposition: form-data; name=");
        private static final byte[] CONTENT_TYPE = EncodingUtils.toAsciiBytes("Content-Type: ");
        private static final byte[] CHARSET = EncodingUtils.toAsciiBytes("; charset=utf-8");
        private static final byte[] CONTENT_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("Content-Transfer-Encoding: ");
        private static final byte[] FILE_NAME = EncodingUtils.toAsciiBytes("; filename=");
        private static final byte[] FILE_CONTENT_TYPE = EncodingUtils.toAsciiBytes("application/octet-stream");
        private static final byte[] TEXT_CONTENT_TYPE = EncodingUtils.toAsciiBytes("text/plain");
        private static final byte[] FILE_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("binary");
        private static final byte[] TEXT_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("8bit");
        private byte[] boundary = null;

        protected MultipartWriter() {
        }

        private byte[] getBoundary() {
            if (this.boundary != null) {
                return this.boundary;
            }
            Random rand = new Random();
            byte[] bytes = new byte[rand.nextInt(11) + 30];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = BOUNDARY_CHARS[rand.nextInt(BOUNDARY_CHARS.length)];
                ++i;
            }
            this.boundary = bytes;
            return this.boundary;
        }

        @Override
        public String getContentType() {
            StringBuffer typeBuffer = new StringBuffer(MULTIPART_CONTENT_TYPE);
            typeBuffer.append(EncodingUtils.toAsciiString(this.getBoundary()));
            return typeBuffer.toString();
        }

        @Override
        public long getContentLength() {
            if (this.getParameters().isEmpty()) {
                return 0L;
            }
            long length = 0L;
            for (NamedValue part : this.getParameters()) {
                length += (long)EXTRA.length;
                length += (long)this.getBoundary().length;
                length += (long)CRLF.length;
                length += (long)CONTENT_DISPOSITION.length;
                length += (long)QUOTE.length;
                length += (long)EncodingUtils.toAsciiBytes(part.getEncodedName()).length;
                length += (long)QUOTE.length;
                length += (long)CRLF.length;
                if (part.value instanceof File) {
                    length += (long)FILE_NAME.length;
                    length += (long)QUOTE.length;
                    length += (long)EncodingUtils.toAsciiBytes(part.getEncodedName()).length;
                    length += (long)QUOTE.length;
                }
                length += (long)CONTENT_TYPE.length;
                length += (long)MultipartWriter.getContentType(part.value).length;
                length += (long)CHARSET.length;
                length += (long)CRLF.length;
                length += (long)CONTENT_TRANSFER_ENCODING.length;
                length += (long)MultipartWriter.getTransferEncoding(part.value).length;
                length += (long)CRLF.length;
                length += (long)CRLF.length;
                length += MultipartWriter.getPartDataLength(part);
                length += (long)CRLF.length;
            }
            length += (long)EXTRA.length;
            length += (long)this.getBoundary().length;
            length += (long)EXTRA.length;
            return length += (long)CRLF.length;
        }

        @Override
        public void write(OutputStream stream) throws IOException {
            if (this.getParameters().isEmpty()) {
                return;
            }
            for (NamedValue part : this.getParameters()) {
                stream.write(EXTRA);
                stream.write(this.getBoundary());
                stream.write(CRLF);
                stream.write(CONTENT_DISPOSITION);
                stream.write(QUOTE);
                stream.write(EncodingUtils.toAsciiBytes(part.getEncodedName()));
                stream.write(QUOTE);
                if (part.value instanceof File) {
                    stream.write(FILE_NAME);
                    stream.write(QUOTE);
                    stream.write(EncodingUtils.toAsciiBytes(((File)part.value).getName()));
                    stream.write(QUOTE);
                }
                stream.write(CRLF);
                stream.write(CONTENT_TYPE);
                stream.write(MultipartWriter.getContentType(part.value));
                stream.write(CHARSET);
                stream.write(CRLF);
                stream.write(CONTENT_TRANSFER_ENCODING);
                stream.write(MultipartWriter.getTransferEncoding(part.value));
                stream.write(CRLF);
                stream.write(CRLF);
                MultipartWriter.writePartData(stream, part);
                stream.write(CRLF);
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }
            stream.write(EXTRA);
            stream.write(this.getBoundary());
            stream.write(EXTRA);
            stream.write(CRLF);
        }

        private static byte[] getContentType(Object value) {
            if (value instanceof File) {
                return FILE_CONTENT_TYPE;
            }
            return TEXT_CONTENT_TYPE;
        }

        private static byte[] getTransferEncoding(Object value) {
            if (value instanceof File) {
                return FILE_TRANSFER_ENCODING;
            }
            return TEXT_TRANSFER_ENCODING;
        }

        private static long getPartDataLength(NamedValue part) {
            if (part.value instanceof File) {
                return (int)((File)part.value).length();
            }
            return EncodingUtils.toAsciiBytes(part.getValue()).length;
        }

        private static void writePartData(OutputStream stream, NamedValue part) throws IOException {
            if (part.value instanceof File) {
                MultipartWriter.writeFromFile(stream, (File)part.value);
            } else {
                MultipartWriter.writeFromText(stream, part.getValue());
            }
        }

        private static void writeFromFile(OutputStream writeStream, File file) throws IOException {
            try (FileInputStream readStream = new FileInputStream(file);){
                int bytes;
                byte[] buffer = new byte[4096];
                while ((bytes = readStream.read(buffer)) >= 0) {
                    writeStream.write(buffer, 0, bytes);
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
            }
        }

        private static void writeFromText(OutputStream writeStream, String encodedText) throws IOException {
            writeStream.write(encodedText.getBytes("UTF-8"));
        }
    }

    protected static class NamedValue {
        public String name;
        public Object value;
        private String encodedName = null;
        private String encodedValue = null;

        public NamedValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value == null ? "" : this.value.toString();
        }

        public String getEncodedName() {
            if (this.encodedName == null) {
                this.encodedName = EncodingUtils.urlEncode(this.name);
            }
            return this.encodedName;
        }

        public String getEncodedValue() {
            if (this.encodedValue == null) {
                this.encodedValue = EncodingUtils.urlEncode(this.value);
            }
            return this.encodedValue;
        }

        public String toString() {
            return String.format("%s: %s", this.name, this.value);
        }
    }

    protected static abstract class RequestWriter {
        private List<NamedValue> parameters;

        protected RequestWriter() {
        }

        public void init(List<NamedValue> parameters) {
            this.parameters = parameters;
        }

        protected List<NamedValue> getParameters() {
            return this.parameters;
        }

        public abstract String getContentType();

        public abstract long getContentLength();

        public abstract void write(OutputStream var1) throws IOException;
    }

    private static class TrustModifier {
        private static final TrustingHostnameVerifier TRUSTING_HOSTNAME_VERIFIER = new TrustingHostnameVerifier();
        private static SSLSocketFactory factory;

        private TrustModifier() {
        }

        public static void relaxHostChecking(HttpURLConnection conn) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
                SSLSocketFactory factory = TrustModifier.prepFactory(httpsConnection);
                httpsConnection.setSSLSocketFactory(factory);
                httpsConnection.setHostnameVerifier(TRUSTING_HOSTNAME_VERIFIER);
            }
        }

        static synchronized SSLSocketFactory prepFactory(HttpsURLConnection httpsConnection) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
            if (factory == null) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new AlwaysTrustManager()}, null);
                factory = ctx.getSocketFactory();
            }
            return factory;
        }

        private static class AlwaysTrustManager
        implements X509TrustManager {
            private AlwaysTrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }

        private static final class TrustingHostnameVerifier
        implements HostnameVerifier {
            private TrustingHostnameVerifier() {
            }

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }
    }
}

