/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.ui.editor.IEditorHistory;

public class RecentFilesContentProvider
extends EventManager
implements IStructuredContentProvider,
IEditorHistory.IEditorHistoryListener,
IPropertyChangeListener {
    private static final int DEFAULT_ITEM_COUNT = 20;
    private IEditorHistory history = null;
    private IPreferenceStore preferenceStore = null;

    public void dispose() {
        this.clearListeners();
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.preferenceStore = null;
        }
        if (this.history != null) {
            this.history.removeEditorHistoryListener((IEditorHistory.IEditorHistoryListener)this);
            this.history = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != this.history) {
            if (this.history != null) {
                this.history.removeEditorHistoryListener((IEditorHistory.IEditorHistoryListener)this);
            }
            IEditorHistory iEditorHistory = this.history = newInput instanceof IEditorHistory ? (IEditorHistory)newInput : null;
            if (this.history != null) {
                this.history.addEditorHistoryListener((IEditorHistory.IEditorHistoryListener)this);
            }
            if (this.history != null) {
                if (this.preferenceStore == null) {
                    this.preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
                    this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
                }
            } else if (this.preferenceStore != null) {
                this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
                this.preferenceStore = null;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.history) {
            return new Object[0];
        }
        return this.getRecentInput();
    }

    public URI[] getRecentInput() {
        if (this.history == null) {
            return new URI[0];
        }
        int itemsToShow = this.getItemCount();
        if (itemsToShow <= 0) {
            return new URI[0];
        }
        URI[] uncheckedURIs = this.history.getAllInputURIs();
        ArrayList<URI> recentInputURIs = new ArrayList<URI>();
        int count = 0;
        URI[] uRIArray = uncheckedURIs;
        int n = uncheckedURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (!recentInputURIs.contains(uri)) {
                recentInputURIs.add(uri);
                ++count;
            } else {
                this.history.remove(uri);
            }
            if (count == itemsToShow) break;
            ++n2;
        }
        return recentInputURIs.toArray(new URI[recentInputURIs.size()]);
    }

    private int getItemCount() {
        if (this.preferenceStore == null) {
            return 20;
        }
        return this.preferenceStore.getInt("RECENT_FILES");
    }

    private void fireContentChanged() {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((Runnable)listeners[i]).run();
            ++i;
        }
    }

    public void editorHistoryChanged() {
        this.fireContentChanged();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("RECENT_FILES".equals(event.getProperty())) {
            this.fireContentChanged();
        }
    }

    public void addContentChangeListener(Runnable listener) {
        this.addListenerObject(listener);
    }

    public void removeContentChangeListener(Runnable listener) {
        this.removeListenerObject(listener);
    }
}

