/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.dom.IDKey;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;

public class NodeAdaptableProvider
implements INodeAdaptableProvider {
    private ElementRegistry registry;
    private INodeAdaptableFactory factory;
    private Document primaryDocument;

    public NodeAdaptableProvider(ElementRegistry registry, INodeAdaptableFactory factory, Document primaryDocument) {
        this.registry = registry;
        this.factory = factory;
        this.primaryDocument = primaryDocument;
    }

    private Object getID(Node node) {
        Element e;
        String id;
        if (node instanceof Element && (id = (e = (Element)node).getAttribute("id")) != null && !"".equals(id)) {
            Document doc;
            Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            if (doc.equals(this.primaryDocument)) {
                return id;
            }
            return new IDKey(doc, id);
        }
        return null;
    }

    public IAdaptable getAdaptable(Node node) {
        Object e;
        if (node == null) {
            return null;
        }
        Object id = this.getID(node);
        if (id != null && (e = this.registry.getElement(id)) != null && e instanceof IAdaptable) {
            return (IAdaptable)e;
        }
        e = this.registry.getElement(node);
        if (e instanceof IAdaptable) {
            return (IAdaptable)e;
        }
        IAdaptable adaptable = this.createAdaptable(node);
        if (adaptable != null) {
            this.register(adaptable, node);
            return adaptable;
        }
        return null;
    }

    private void register(IAdaptable adapter, Node node) {
        Object id = this.getID(node);
        if (id != null) {
            this.registry.registerByKey(id, adapter);
        }
        this.registry.registerByKey(node, adapter);
    }

    private IAdaptable createAdaptable(Node node) {
        IAdaptable adaptable = this.factory.createAdaptable(node);
        if (adaptable != null && adaptable.getAdapter(Node.class) == node) {
            return adaptable;
        }
        return null;
    }
}

