/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.internal.sharing.DOMUtils;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.internal.sharing.LocalNetworkSharingService;
import org.xmind.core.internal.sharing.SharedContact;
import org.xmind.core.sharing.IContactManager;
import org.xmind.core.sharing.ISharedContact;
import org.xmind.core.sharing.SharingEvent;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContactManager
implements IContactManager {
    private static final String FILE_ACCESS_CONTROLLER = "access_controller.xml";
    private static final String TAG_ACCESS_CONTROLLER = "access-controller";
    private static final String TAG_CONTACTS = "contacts";
    private static final String TAG_CONTACT = "contact";
    private static final String TAG_ID = "id";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ACCESS_LEVEL = "access-level";
    private static boolean DEBUGGING = LocalNetworkSharing.isDebugging("/debug");
    private List<ISharedContact> contacts = new ArrayList<ISharedContact>();
    private Map<String, Integer> accessLevelMap = new HashMap<String, Integer>();
    private File metaFile = null;
    private LocalNetworkSharingService service;
    private ISharedContact myselfContact;
    private String verificationCode;

    public ContactManager(LocalNetworkSharingService service) {
        this.service = service;
        this.load();
    }

    private void load() {
        long start = System.currentTimeMillis();
        try {
            File metaFile = this.getMetaFile();
            if (!metaFile.exists()) {
                return;
            }
            try {
                Element contactsEle;
                Document doc = this.getDocumentBuilder().parse(metaFile);
                Element root = doc.getDocumentElement();
                Element idEle = DOMUtils.getFirstChildElementByTag(root, "id");
                if (idEle != null) {
                    this.myselfContact = new SharedContact(idEle.getTextContent(), this.service.getLocalLibrary().getName());
                }
                if ((contactsEle = DOMUtils.getFirstChildElementByTag(root, TAG_CONTACTS)) != null) {
                    Element[] contactEles;
                    Element[] elementArray = contactEles = DOMUtils.childElementArrayByTag(contactsEle, TAG_CONTACT);
                    int n = contactEles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element contactEle = elementArray[n2];
                        String id = contactEle.getAttribute("id");
                        Integer accessLevel = Integer.parseInt(contactEle.getAttribute(ATT_ACCESS_LEVEL));
                        SharedContact contact = new SharedContact(id, contactEle.getAttribute(ATT_NAME));
                        this.accessLevelMap.put(id, accessLevel);
                        this.contacts.add(contact);
                        ++n2;
                    }
                }
            }
            catch (Throwable e) {
                LocalNetworkSharing.log("Error occurred while loading shared access controller info.", e);
            }
        }
        finally {
            long end = System.currentTimeMillis();
            if (DEBUGGING) {
                System.out.println("Local shared access controller loaded: " + (end - start) + " ms");
            }
        }
    }

    private File getMetaFile() {
        if (this.metaFile == null) {
            this.metaFile = new File(LocalNetworkSharing.getDefault().getDataDirectory(), FILE_ACCESS_CONTROLLER);
        }
        return this.metaFile;
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (Exception exception) {}
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }
        });
        return documentBuilder;
    }

    private synchronized void save() {
        long start = System.currentTimeMillis();
        try {
            try {
                Document doc = this.getDocumentBuilder().newDocument();
                Element root = DOMUtils.createElement(doc, TAG_ACCESS_CONTROLLER);
                Element idELe = DOMUtils.createElement(root, "id");
                idELe.setTextContent(this.getMyselfContact().getID());
                Element contactsEle = DOMUtils.createElement(root, TAG_CONTACTS);
                for (ISharedContact c : this.contacts) {
                    Element contactEle = DOMUtils.createElement(contactsEle, TAG_CONTACT);
                    contactEle.setAttribute("id", c.getID());
                    contactEle.setAttribute(ATT_NAME, c.getName());
                    contactEle.setAttribute(ATT_ACCESS_LEVEL, Integer.toString(this.getAccessLevel(c.getID())));
                }
                File metaFile = this.getMetaFile();
                metaFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(metaFile);
                try {
                    DOMUtils.save(doc, output, true);
                }
                finally {
                    output.close();
                }
            }
            catch (Throwable e) {
                LocalNetworkSharing.log("Error occurred while saving access controller info.", e);
                long end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("Local shared library saved: " + (end - start) + " ms");
                }
            }
        }
        finally {
            long end = System.currentTimeMillis();
            if (DEBUGGING) {
                System.out.println("Local shared library saved: " + (end - start) + " ms");
            }
        }
    }

    public ISharedContact getMyselfContact() {
        if (this.myselfContact == null) {
            this.myselfContact = new SharedContact(UUID.randomUUID().toString(), this.service.getLocalLibrary().getName());
            this.save();
        }
        return this.myselfContact;
    }

    public boolean isContact(String contactID) {
        if (contactID != null) {
            for (ISharedContact c : this.contacts) {
                if (!contactID.equals(c.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public int getAccessLevel(String contactID) {
        Integer accessLevel;
        if (contactID != null && (accessLevel = this.accessLevelMap.get(contactID)) != null) {
            return accessLevel;
        }
        return 1;
    }

    public synchronized ISharedContact addContact(String contactID, String name, int accessLevel) {
        if (contactID == null || "".equals(contactID) || name == null || "".equals(name)) {
            return null;
        }
        SharedContact contact = null;
        for (ISharedContact c : this.contacts) {
            if (!contactID.equals(c.getID())) continue;
            contact = (SharedContact)c;
            contact.setName(name);
            this.accessLevelMap.put(contactID, accessLevel);
            break;
        }
        if (contact == null) {
            contact = new SharedContact(contactID, name);
            this.accessLevelMap.put(contactID, accessLevel);
            this.contacts.add(contact);
        }
        this.save();
        this.service.fireSharingEvent(new SharingEvent(SharingEvent.Type.CONTACT_ADDED, this.service.getLocalLibrary(), contactID, this.service.getLocalLibrary().getMaps()));
        return contact;
    }

    public synchronized ISharedContact[] getContacts() {
        return this.contacts.toArray(new ISharedContact[this.contacts.size()]);
    }

    public synchronized ISharedContact findContactByID(String contactID) {
        if (contactID == null || "".equals(contactID)) {
            return null;
        }
        for (ISharedContact c : this.contacts) {
            if (!contactID.equals(c.getID())) continue;
            return c;
        }
        return null;
    }

    public synchronized void updateContactName(String contactID, String name) {
        ISharedContact contact = this.findContactByID(contactID);
        if (contact == null) {
            return;
        }
        if (name == null || "".equals(name) || name.equals(contact.getName())) {
            return;
        }
        ((SharedContact)contact).setName(name);
        this.save();
    }

    public String getVerificationCode() {
        if (this.verificationCode == null) {
            this.verificationCode = UUID.randomUUID().toString();
        }
        return this.verificationCode;
    }
}

