/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.ISourceProvider2;
import org.xmind.gef.command.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCommand
extends Command
implements ISourceProvider2 {
    protected static final List<Object> NO_SOURCES = Collections.emptyList();
    private ISourceProvider sourceDelegate;
    private boolean sourceCollectable = true;

    public SourceCommand(Object source) {
        Assert.isNotNull((Object)source);
        this.sourceDelegate = new ArraySourceProvider(source);
    }

    public SourceCommand(Collection<?> sources) {
        Assert.isNotNull(sources);
        for (Object source : sources) {
            Assert.isNotNull(source);
        }
        this.sourceDelegate = new ArraySourceProvider(sources);
    }

    public SourceCommand(ISourceProvider sourceDelegate) {
        this.sourceDelegate = sourceDelegate;
    }

    protected SourceCommand() {
        this.sourceDelegate = null;
    }

    @Override
    public boolean hasSource() {
        return this.sourceDelegate != null && this.sourceDelegate.hasSource();
    }

    @Override
    public List<Object> getSources() {
        if (this.sourceDelegate == null) {
            return NO_SOURCES;
        }
        return this.sourceDelegate.getSources();
    }

    @Override
    public Object getSource() {
        return this.sourceDelegate == null ? null : this.sourceDelegate.getSource();
    }

    public void setSourceDelegate(ISourceProvider sourceProvider) {
        this.sourceDelegate = sourceProvider;
    }

    public ISourceProvider getSourceDelegate() {
        return this.sourceDelegate;
    }

    protected void setSource(Object newSource) {
        Assert.isNotNull((Object)newSource);
        if (this.sourceDelegate == null) {
            this.sourceDelegate = new ArraySourceProvider();
        }
        if (this.sourceDelegate instanceof ArraySourceProvider) {
            ((ArraySourceProvider)this.sourceDelegate).setSource(newSource);
        }
    }

    protected void setSources(Collection<?> newSources) {
        Assert.isNotNull(newSources);
        for (Object source : newSources) {
            Assert.isNotNull(source);
        }
        if (this.sourceDelegate == null) {
            this.sourceDelegate = new ArraySourceProvider();
        }
        if (this.sourceDelegate instanceof ArraySourceProvider) {
            ((ArraySourceProvider)this.sourceDelegate).setSources(newSources);
        }
    }

    protected void addSource(Object newSource) {
        Assert.isNotNull((Object)newSource);
        if (this.sourceDelegate == null) {
            this.sourceDelegate = new ArraySourceProvider();
        }
        if (this.sourceDelegate instanceof ArraySourceProvider) {
            ((ArraySourceProvider)this.sourceDelegate).addSource(newSource);
        }
    }

    protected void addSources(Collection<?> newSources) {
        Assert.isNotNull(newSources);
        for (Object source : newSources) {
            Assert.isNotNull(source);
        }
        if (this.sourceDelegate == null) {
            this.sourceDelegate = new ArraySourceProvider();
        }
        if (this.sourceDelegate instanceof ArraySourceProvider) {
            ((ArraySourceProvider)this.sourceDelegate).addSources(newSources);
        }
    }

    @Override
    public boolean isSourceCollectable() {
        return this.sourceCollectable;
    }

    @Override
    public void setSourceCollectable(boolean sourceCollectable) {
        this.sourceCollectable = sourceCollectable;
    }
}

