/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.FontResourceDescriptor;
import org.xmind.ui.internal.svgsupport.SVGDefinitionConstants;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGTextElement
extends SVGShape {
    private FontResourceDescriptor fontDescriptor;
    private List<TextSpan> spans;

    SVGTextElement() {
        this.spans = new ArrayList<TextSpan>();
    }

    public SVGTextElement(FontResourceDescriptor fontDescriptor) {
        this.fontDescriptor = fontDescriptor;
    }

    @Override
    public void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseText(implemention, parent);
    }

    @Override
    public Path generatePath(Display device) {
        Font font = (Font)this.getResourceManager().create((DeviceResourceDescriptor)this.fontDescriptor);
        Path path = new Path((Device)device);
        for (TextSpan span : this.spans) {
            path.addString(span.text, new PrecisionPoint((double)span.x, (double)span.y), font);
        }
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return INVALID_RECT;
    }

    private void parseText(Element implemention, SVGShape parent) {
        String fontFamily = implemention.getAttribute("font-family").trim();
        int fontSize = (int)this.getFloatAttribute(implemention, "font-size");
        String fontStyle = implemention.getAttribute("font-weight").trim();
        int style = 0;
        if (fontStyle.contains(SVGDefinitionConstants.BOLD)) {
            style |= 1;
        }
        if (fontStyle.contains(SVGDefinitionConstants.ITALIC)) {
            style |= 2;
        }
        this.fontDescriptor = new FontResourceDescriptor(fontFamily, fontSize, style);
        NodeList list = implemention.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element ele = (Element)node;
                String text = ele.getTextContent();
                float x = this.getFloatAttribute(implemention, "x");
                float y = this.getFloatAttribute(implemention, "y");
                this.spans.add(new TextSpan(x, y, text));
            }
            ++i;
        }
    }

    @Override
    protected SVGShape clone() {
        SVGTextElement text = new SVGTextElement();
        text.fontDescriptor = this.fontDescriptor;
        text.spans = this.spans;
        text.setInfo(this.getInfo().clone());
        return text;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVGTextElement) {
            SVGTextElement text = (SVGTextElement)obj;
            if (this.getInfo() != null && this.getInfo().equals(text.getInfo()) && this.fontDescriptor != null && this.fontDescriptor.equals((Object)text.fontDescriptor) && this.spans.size() == text.spans.size()) {
                int i = 0;
                while (i < this.spans.size()) {
                    TextSpan span1 = this.spans.get(i);
                    TextSpan span2 = text.spans.get(i);
                    if (span1.x != span2.x || span1.y != span2.y || !span1.text.equals(span2.text)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + this.fontDescriptor.hashCode();
        for (TextSpan span : this.spans) {
            result = result * 31 + Float.floatToIntBits(span.x);
            result = result * 31 + Float.floatToIntBits(span.y);
            result = result * 31 + span.text.hashCode();
        }
        return result;
    }

    public String toString() {
        return "SVGText(" + this.fontDescriptor.toString() + ")";
    }

    public void addText(float x, float y, String text) {
        if (this.spans == null) {
            this.spans = new ArrayList<TextSpan>();
        }
        this.spans.add(new TextSpan(x, y, text));
    }

    private static class TextSpan {
        private float x;
        private float y;
        private String text;

        public TextSpan(float x, float y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }
    }
}

