/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.views.ThemeGroupCore;
import org.xmind.ui.internal.views.ThemeLabelProvider;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class ThemeResourceManagerViewer
extends ResourceManagerViewer {
    private static final int FRAME_HEIGHT = 72;
    private static final int FRAME_WIDTH = 132;

    @Override
    public void createControl(Composite container) {
        super.createControl(container);
        this.setContentProvider((IContentProvider)new ThemeCategorizedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ThemeCategorizedLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new ResourceManagerViewer.ResourceCategorizedSelectTool(this));
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(container, 64);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setInput(ThemeGroupCore.getInstance());
    }

    @Override
    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        super.initNestedGalleryViewer(galleryViewerer);
        galleryViewerer.getEditDomain().installTool("edit tool", (ITool)new ThemeNestedViewerNameEditTool());
    }

    @Override
    protected void initProperties() {
        super.initProperties();
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(132, 72));
    }

    protected ITool createNestedViewerEditTool() {
        return new ThemeNestedViewerNameEditTool();
    }

    public void update(Object[] elements) {
        Object[] themeGroupList;
        Object[] objectArray = themeGroupList = ((ThemeCategorizedContentProvider)this.getContentProvider()).getElements(this.getInput());
        int n = themeGroupList.length;
        int n2 = 0;
        while (n2 < n) {
            Object tg = objectArray[n2];
            ThemeGroupCore.CategorizedThemeGroup themeGroup = (ThemeGroupCore.CategorizedThemeGroup)tg;
            GalleryViewer galleryViewer = this.getNestedViewer(themeGroup);
            galleryViewer.update(elements);
            ++n2;
        }
    }

    public void startEditing(IStyle theme) {
        List<ThemeGroupCore.CategorizedThemeGroup> themeGroups = ThemeGroupCore.getInstance().getThemeGroups();
        for (ThemeGroupCore.CategorizedThemeGroup themeGroup : themeGroups) {
            List<IStyle> styles = themeGroup.getItems();
            if (!styles.contains(theme)) continue;
            GalleryViewer galleryViewer = this.getNestedViewer(themeGroup);
            EditDomain domain = galleryViewer.getEditDomain();
            ITool tool = domain.getDefaultTool();
            ((GallerySelectTool)tool).getStatus().setStatus(1, true);
            domain.handleRequest("edit", (IViewer)galleryViewer);
            break;
        }
    }

    public void selectDefault() {
        List categories = this.getCategories();
        if (categories == null || categories.isEmpty() || !(categories.get(0) instanceof ThemeGroupCore.CategorizedThemeGroup)) {
            return;
        }
        Object defaultCategory = null;
        for (Object category : this.getCategories()) {
            if ("default".equals(((ThemeGroupCore.CategorizedThemeGroup)category).getId())) {
                defaultCategory = category;
                this.setSelectionToCategory(category, (ISelection)new StructuredSelection((Object)MindMapUI.getResourceManager().getDefaultTheme()), true);
                continue;
            }
            this.setSelectionToCategory(category, (ISelection)StructuredSelection.EMPTY, false);
        }
        this.reveal(defaultCategory);
    }

    protected GalleryViewer createNestedViewer() {
        return new ThemeGalleryViewer();
    }

    private class ThemeCategorizedContentProvider
    implements ITreeContentProvider {
        private ThemeCategorizedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((ThemeGroupCore)inputElement).getThemeGroups().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ThemeGroupCore.CategorizedThemeGroup) {
                return ((ThemeGroupCore.CategorizedThemeGroup)parentElement).getItems().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ThemeGroupCore.CategorizedThemeGroup) {
                return ThemeGroupCore.getInstance();
            }
            if (element instanceof IStyle) {
                List<ThemeGroupCore.CategorizedThemeGroup> themeGroups = ThemeGroupCore.getInstance().getThemeGroups();
                for (ThemeGroupCore.CategorizedThemeGroup themeGroup : themeGroups) {
                    List<IStyle> styles = themeGroup.getItems();
                    if (!styles.contains(element)) continue;
                    return themeGroup;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ThemeGroupCore || element instanceof ThemeGroupCore.CategorizedThemeGroup;
        }
    }

    private class ThemeCategorizedLabelProvider
    extends ThemeLabelProvider
    implements IFontProvider {
        private ThemeCategorizedLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ThemeGroupCore.CategorizedThemeGroup) {
                return ((ThemeGroupCore.CategorizedThemeGroup)element).getName();
            }
            if (element instanceof IStyle && "theme".equals(((IStyle)element).getType())) {
                return ((IStyle)element).getName();
            }
            return super.getText(element);
        }

        public Font getFont(Object element) {
            FontData data = ThemeResourceManagerViewer.this.getContainer().getFont().getFontData()[0];
            if (Util.isMac()) {
                data.setHeight(12);
            } else {
                data.setHeight(9);
            }
            data.setStyle(0);
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            return ThemeResourceManagerViewer.this.getResourceManager().createFont(fontDescriptor);
        }
    }

    private class ThemeGalleryViewer
    extends GalleryViewer {
        private ThemeGalleryViewer() {
        }

        protected boolean isTitleEditable(IPart p) {
            IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserThemeSheet();
            return styleSheet == null ? false : styleSheet.getAllStyles().contains(p.getModel());
        }
    }

    class ThemeNestedGalleryViewer
    extends GalleryViewer {
        ThemeNestedGalleryViewer() {
        }

        protected boolean isTitleEditable(IPart p) {
            if (p.getModel() instanceof IStyle) {
                IStyle style = (IStyle)p.getModel();
                IResourceManager rm = MindMapUI.getResourceManager();
                Set systemThemeSets = rm.getUserThemeSheet().getStyles("master-styles");
                return systemThemeSets.contains(style);
            }
            return false;
        }
    }

    private class ThemeNestedViewerNameEditTool
    extends GalleryEditTool {
        private ThemeNestedViewerNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserThemeSheet();
            ThemeResourceManagerViewer.this.refresh();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(142);
        }
    }
}

