/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            utility_functions.h
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Wed Oct 27 10:00:21 1999
 *                                                                             
 * Last Modification:   Wed Oct 27 10:00:21 1999
 *                                                                             
 * Copyright:           Georg Huettenegger
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#ifndef ___UTILITY_FUNCTIONS_H
#define ___UTILITY_FUNCTIONS_H

#include "gplextor-tool.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Searches the device_data list for device_name and if found returns
 * the GPlextorToolData structure (uses +5 for the stored device names
 * so that e.g. sg0 is used of /dev/sg0).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
GPlextorToolData * find_gptd_with_device_name (GPlextorToolAppletData * gptad,
                                               char * device_name);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Common function whenever one of the two device selection combos got
 * a new value (property_page is TRUE when the changed combo box is that
 * of the property page). Changes all other visible GUI elements
 * accordingly (for example possibly using adjust_prop_toggles and
 * adjust_prop_volume).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void device_changed (GPlextorToolAppletData * gptad,
                     gboolean property_page);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Common function whenever one of the two speed selection combos got
 * a new value (property_page is TRUE when the changed combo box is that
 * of the property page). Changes a possibly visible second combo box too.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void speed_changed (GPlextorToolAppletData * gptad,
                    gboolean property_page);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Function called whenever the spindown of one device was changed.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void spindown_changed (GPlextorToolAppletData * gptad);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Updates the toggles of the property page according to the current
 * device (given with gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void adjust_prop_toggles (GPlextorToolAppletData * gptad,
                          GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Updates the ui volume parts of the property page according to the current
 * device (given with gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void adjust_prop_volume (GPlextorToolAppletData * gptad,
			 GPlextorToolData * gptd);

#if (defined CALL_TRACE) || (defined VERBOSE_OUTPUT)

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Functions to perform flushed output (to be able to redirect 
 * verbose output to a file).
 *                                                                             
 *----------------------------------------------------------------------------*
 */

void flushed_output_0 (FILE * output_ptr, const char * msg_ptr);
void flushed_output_1_int (FILE * output_ptr, const char * msg_ptr,
                           const int arg1);
void flushed_output_2_int (FILE * output_ptr, const char * msg_ptr,
                           const int arg1, const int arg2);
void flushed_output_1_string (FILE * output_ptr, const char * msg_ptr,
                              const char * arg1);
void flushed_output_2_string (FILE * output_ptr, const char * msg_ptr,
                              const char * arg1, const char * arg2);

#endif

#endif

/*============================================================================*
 *============================================================================*
 * EOF utility_functions.h
 *============================================================================*
 *============================================================================*
 */
