/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.structures;

import com.hankcs.hanlp.dependency.perceptron.structures.Sentence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class IndexMaps
implements Serializable {
    public final String rootString;
    public String[] idWord;
    private HashMap<String, Integer> wordId;
    private HashMap<Integer, Integer> labels;
    private HashMap<Integer, Integer> brown4Clusters;
    private HashMap<Integer, Integer> brown6Clusters;
    private HashMap<String, Integer> brownFullClusters;

    public IndexMaps(HashMap<String, Integer> wordId, HashMap<Integer, Integer> labels, String rootString, HashMap<Integer, Integer> brown4Clusters, HashMap<Integer, Integer> brown6Clusters, HashMap<String, Integer> brownFullClusters) {
        this.wordId = wordId;
        this.labels = labels;
        this.idWord = new String[wordId.size() + 1];
        this.idWord[0] = "ROOT";
        Iterator<String> iterator = wordId.keySet().iterator();
        while (iterator.hasNext()) {
            String word;
            this.idWord[wordId.get((Object)word).intValue()] = word = iterator.next();
        }
        this.brown4Clusters = brown4Clusters;
        this.brown6Clusters = brown6Clusters;
        this.brownFullClusters = brownFullClusters;
        this.rootString = rootString;
    }

    public Sentence makeSentence(String[] words, String[] posTags, boolean rootFirst, boolean lowerCased) {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        ArrayList<Integer> tags = new ArrayList<Integer>();
        ArrayList<Integer> bc4 = new ArrayList<Integer>();
        ArrayList<Integer> bc6 = new ArrayList<Integer>();
        ArrayList<Integer> bcf = new ArrayList<Integer>();
        int i = 0;
        for (String word : words) {
            if (word.length() == 0) continue;
            String lowerCaseWord = word.toLowerCase();
            if (lowerCased) {
                word = lowerCaseWord;
            }
            int[] clusterIDs = this.clusterId(word);
            bcf.add(clusterIDs[0]);
            bc4.add(clusterIDs[1]);
            bc6.add(clusterIDs[2]);
            String pos = posTags[i];
            int wi = -1;
            if (this.wordId.containsKey(word)) {
                wi = this.wordId.get(word);
            }
            int pi = -1;
            if (this.wordId.containsKey(pos)) {
                pi = this.wordId.get(pos);
            }
            tokens.add(wi);
            tags.add(pi);
            ++i;
        }
        if (!rootFirst) {
            tokens.add(0);
            tags.add(0);
            bcf.add(0);
            bc6.add(0);
            bc4.add(0);
        }
        return new Sentence(tokens, tags, bc4, bc6, bcf);
    }

    public HashMap<String, Integer> getWordId() {
        return this.wordId;
    }

    public HashMap<Integer, Integer> getLabels() {
        return this.labels;
    }

    public int[] clusterId(String word) {
        int[] ids = new int[]{-100, -100, -100};
        if (this.brownFullClusters.containsKey(word)) {
            ids[0] = this.brownFullClusters.get(word);
        }
        if (ids[0] > 0) {
            ids[1] = this.brown4Clusters.get(ids[0]);
            ids[2] = this.brown6Clusters.get(ids[0]);
        }
        return ids;
    }

    public boolean hasClusters() {
        return this.brownFullClusters != null && this.brownFullClusters.size() > 0;
    }
}

