/* $Id: blending.c,v 1.8 2005/07/30 16:31:58 cegger Exp $
******************************************************************************

   Generic color default library implementation

   Copyright (C) 2000 Christoph Eggerg	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


#include <stdlib.h>

#include "config.h"
#include "color.h"


/* Blending manipulation
 */

/* Color blending */
gcp_pixel GGI_color_BlendColor(ggi_visual_t vis,
			const gcp_pixel *pix1,
			const gcp_pixel *pix2, uint16_t alpha)
{
	int rc;
	int r,g,b,a;

	gcp_RGBAcolor base_col;
	gcp_RGBAcolor color_col;

	gcp_pixel blended_pix;


	rc = gcpUnmapRGBAPixel(vis, *pix1, &base_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel() failed");
	rc = gcpUnmapRGBAPixel(vis, *pix2, &color_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel() failed");


	DPRINT_CORE("base_col: (0x%X,0x%X,0x%X,0x%X)\n",
		base_col.r, base_col.g, base_col.b, base_col.a);
	DPRINT_CORE("color_col: (0x%X,0x%X,0x%X,0x%X)\n",
		color_col.r, color_col.g, color_col.b, color_col.a);

#if 0	/* comparison is always false due to limited range of datatype */
	if (alpha > 0xFFFF) {
		alpha = 0xFFFF;
	}	/* if */
#endif

	if (color_col.r == base_col.r) {
		r = base_col.r;
	} else {
		r = (base_col.r + (color_col.r - base_col.r) * alpha) / 0xFFFF;
	}	/* if */

	if (color_col.g == base_col.g) {
		g = base_col.g;
	} else {
		g = (base_col.g + (color_col.g - base_col.g) * alpha) / 0xFFFF;
	}	/* if */

	if (color_col.b == base_col.b) {
		b = base_col.b;
	} else {
		b = (base_col.b + (color_col.b - base_col.b) * alpha) / 0xFFFF;
	}	/* if */

	if (color_col.a == base_col.a) {
		a = base_col.a;
	} else {
		a = (base_col.a + (color_col.a - base_col.a) * alpha) / 0xFFFF;
	}	/* if */


	if (r > 0xFFFF || r < 0) r &= 0xFFFF;
	if (g > 0xFFFF || g < 0) g &= 0xFFFF;
	if (b > 0xFFFF || b < 0) b &= 0xFFFF;
	if (a > 0xFFFF || a < 0) a &= 0xFFFF;

	color_col.r = r;
	color_col.g = g;
	color_col.b = b;
	color_col.a = a;


	DPRINT_CORE("blended_col: (0x%X,0x%X,0x%X,0x%X)\n",
		color_col.r, color_col.g, color_col.b, color_col.a);

	blended_pix = gcpMapRGBAColor(vis, &color_col);
	DPRINT_CORE("blended_pix: %i\n", blended_pix);


	return blended_pix;
}	/* GGI_color_BlendColor */
